/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.actions.OpenFileInSystemEditorAction;
import org.eclipse.team.internal.ui.synchronize.actions.OpenInCompareAction;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.views.navigator.ResourceNavigatorMessages;

public class OpenWithActionGroup
extends ActionGroup {
    private OpenFileInSystemEditorAction openFileAction;
    private OpenInCompareAction openInCompareAction;
    private String name;
    private ISynchronizePageSite site;

    public OpenWithActionGroup(ISynchronizePageSite site, String name) {
        this.name = name;
        this.site = site;
        this.makeActions();
    }

    protected void makeActions() {
        IWorkbenchSite ws = this.site.getWorkbenchSite();
        if (ws != null) {
            this.openFileAction = new OpenFileInSystemEditorAction(ws.getPage());
            this.openInCompareAction = new OpenInCompareAction(this.site, this.name);
        }
    }

    public void fillContextMenu(IMenuManager menu, String groupId) {
        ISelection selection = this.site.getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            this.fillOpenWithMenu(menu, groupId, (IStructuredSelection)selection);
        }
    }

    private void fillOpenWithMenu(IMenuManager menu, String groupId, IStructuredSelection selection) {
        IWorkbenchSite ws;
        if (selection == null || selection.size() != 1) {
            return;
        }
        Object element = selection.getFirstElement();
        IResource[] resources = Utils.getResources(new Object[]{element});
        IResource resource = null;
        if (resources.length == 0) {
            return;
        }
        resource = resources[0];
        if (resource.getType() != 1) {
            return;
        }
        menu.appendToGroup(groupId, (IAction)this.openInCompareAction);
        if (!resource.exists()) {
            return;
        }
        if (this.openFileAction != null) {
            this.openFileAction.selectionChanged(selection);
            menu.appendToGroup(groupId, (IAction)this.openFileAction);
        }
        if ((ws = this.site.getWorkbenchSite()) != null) {
            MenuManager submenu = new MenuManager(ResourceNavigatorMessages.getString((String)"ResourceNavigator.openWith"));
            submenu.add((IContributionItem)new OpenWithMenu(ws.getPage(), (IAdaptable)resource));
            menu.appendToGroup(groupId, (IContributionItem)submenu);
        }
    }

    public void openInCompareEditor() {
        this.openInCompareAction.run();
    }
}

