/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval.ast.instructions;

import com.sun.jdi.InvocationException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaArrayType;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.eval.ast.engine.IRuntimeContext;
import org.eclipse.jdt.internal.debug.eval.ast.engine.Interpreter;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.InstructionsEvaluationMessages;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.RuntimeSignature;

public abstract class Instruction {
    private Interpreter fInterpreter;
    public static final int T_undefined = 0;
    public static final int T_Object = 1;
    public static final int T_char = 2;
    public static final int T_byte = 3;
    public static final int T_short = 4;
    public static final int T_boolean = 5;
    public static final int T_void = 6;
    public static final int T_long = 7;
    public static final int T_double = 8;
    public static final int T_float = 9;
    public static final int T_int = 10;
    public static final int T_String = 11;
    public static final int T_null = 12;
    private static final int[][] fTypeTable = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0}, {0, 0, 10, 10, 10, 0, 0, 7, 8, 9, 10, 11, 0}, {0, 0, 10, 10, 10, 0, 0, 7, 8, 9, 10, 11, 0}, {0, 0, 10, 10, 10, 0, 0, 7, 8, 9, 10, 11, 0}, {0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 11, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 7, 7, 7, 0, 0, 7, 8, 9, 7, 11, 0}, {0, 0, 8, 8, 8, 0, 0, 8, 8, 8, 8, 11, 0}, {0, 0, 9, 9, 9, 0, 0, 9, 8, 9, 9, 11, 0}, {0, 0, 10, 10, 10, 0, 0, 7, 8, 9, 10, 11, 0}, {0, 11, 11, 11, 11, 11, 0, 11, 11, 11, 11, 11, 11}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0}};
    public static final String CLASS = "java.lang.Class";
    public static final String FOR_NAME = "forName";
    public static final String FOR_NAME_SIGNATURE = "(Ljava/lang/String;)Ljava/lang/Class;";

    public abstract int getSize();

    public void setInterpreter(Interpreter interpreter) {
        this.fInterpreter = interpreter;
    }

    public void setLastValue(IJavaValue value) {
        this.fInterpreter.setLastValue(value);
    }

    public void stop() {
        this.fInterpreter.stop();
    }

    public static int getBinaryPromotionType(int left, int right) {
        return fTypeTable[left][right];
    }

    public abstract void execute() throws CoreException;

    protected IRuntimeContext getContext() {
        return this.fInterpreter.getContext();
    }

    protected IJavaDebugTarget getVM() {
        return this.getContext().getVM();
    }

    protected IVariable getInternalVariable(String name) {
        return this.fInterpreter.getInternalVariable(name);
    }

    protected IVariable createInternalVariable(String name, IJavaType referencType) {
        return this.fInterpreter.createInternalVariable(name, referencType);
    }

    protected IJavaObject getClassObject(IJavaType type) throws CoreException {
        if (type instanceof IJavaReferenceType) {
            return ((IJavaReferenceType)type).getClassObject();
        }
        return null;
    }

    protected void jump(int offset) {
        this.fInterpreter.jump(offset);
    }

    protected void push(Object object) {
        this.fInterpreter.push(object);
    }

    protected Object pop() {
        return this.fInterpreter.pop();
    }

    protected IJavaValue popValue() throws CoreException {
        Object element = this.fInterpreter.pop();
        if (element instanceof IJavaVariable) {
            return (IJavaValue)((IJavaVariable)element).getValue();
        }
        return (IJavaValue)element;
    }

    protected void pushNewValue(boolean value) {
        this.fInterpreter.push(this.newValue(value));
    }

    protected IJavaValue newValue(boolean value) {
        return this.getVM().newValue(value);
    }

    protected void pushNewValue(byte value) {
        this.fInterpreter.push(this.newValue(value));
    }

    protected IJavaValue newValue(byte value) {
        return this.getVM().newValue(value);
    }

    protected void pushNewValue(short value) {
        this.fInterpreter.push(this.newValue(value));
    }

    protected IJavaValue newValue(short value) {
        return this.getVM().newValue(value);
    }

    protected void pushNewValue(int value) {
        this.fInterpreter.push(this.newValue(value));
    }

    protected IJavaValue newValue(int value) {
        return this.getVM().newValue(value);
    }

    protected void pushNewValue(long value) {
        this.fInterpreter.push(this.newValue(value));
    }

    protected IJavaValue newValue(long value) {
        return this.getVM().newValue(value);
    }

    protected void pushNewValue(char value) {
        this.fInterpreter.push(this.newValue(value));
    }

    protected IJavaValue newValue(char value) {
        return this.getVM().newValue(value);
    }

    protected void pushNewValue(float value) {
        this.fInterpreter.push(this.newValue(value));
    }

    protected IJavaValue newValue(float value) {
        return this.getVM().newValue(value);
    }

    protected void pushNewValue(double value) {
        this.fInterpreter.push(this.newValue(value));
    }

    protected IJavaValue newValue(double value) {
        return this.getVM().newValue(value);
    }

    protected void pushNewValue(String value) {
        this.fInterpreter.push(this.newValue(value));
    }

    protected IJavaValue newValue(String value) {
        return this.getVM().newValue(value);
    }

    protected void pushNullValue() {
        this.fInterpreter.push(this.nullValue());
    }

    protected IJavaValue nullValue() {
        return this.getVM().nullValue();
    }

    public static int getUnaryPromotionType(int typeId) {
        return fTypeTable[typeId][10];
    }

    protected IJavaType getType(String qualifiedName) throws CoreException {
        IJavaObject classReference = this.classForName(qualifiedName);
        IJavaType[] types = this.getVM().getJavaTypes(qualifiedName);
        this.checkTypes(types, qualifiedName);
        if (types.length == 1) {
            return types[0];
        }
        if (classReference == null) {
            throw new CoreException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 0, MessageFormat.format(InstructionsEvaluationMessages.getString("Instruction.No_type"), qualifiedName), null));
        }
        int length = types.length;
        for (int i = 0; i < length; ++i) {
            IJavaType type = types[i];
            if (!classReference.equals(this.getClassObject(type))) continue;
            return type;
        }
        throw new CoreException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 0, MessageFormat.format(InstructionsEvaluationMessages.getString("Instruction.No_type"), qualifiedName), null));
    }

    protected IJavaArrayType getArrayType(String typeSignature, int dimension) throws CoreException {
        String qualifiedName = RuntimeSignature.toString(typeSignature);
        String braces = "";
        for (int i = 0; i < dimension; ++i) {
            qualifiedName = qualifiedName + "[]";
            braces = braces + "[";
        }
        String signature = braces + typeSignature;
        IJavaObject classReference = this.classForName(signature);
        if (classReference == null) {
            throw new CoreException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 0, MessageFormat.format(InstructionsEvaluationMessages.getString("Instruction.No_type"), qualifiedName), null));
        }
        IJavaType[] types = this.getVM().getJavaTypes(qualifiedName);
        this.checkTypes(types, qualifiedName);
        if (types.length == 1) {
            return (IJavaArrayType)types[0];
        }
        int length = types.length;
        for (int i = 0; i < length; ++i) {
            IJavaType type = types[i];
            if (!classReference.equals(this.getClassObject(type))) continue;
            return (IJavaArrayType)type;
        }
        throw new CoreException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 0, MessageFormat.format(InstructionsEvaluationMessages.getString("Instruction.No_type"), qualifiedName), null));
    }

    protected IJavaObject classForName(String qualifiedName) throws CoreException {
        IJavaType[] types = this.getVM().getJavaTypes(CLASS);
        this.checkTypes(types, qualifiedName);
        if (types.length != 1) {
            throw new CoreException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 0, MessageFormat.format(InstructionsEvaluationMessages.getString("Instruction.No_type"), qualifiedName), null));
        }
        IJavaType receiver = types[0];
        IJavaValue[] args = new IJavaValue[]{this.newValue(qualifiedName)};
        try {
            return (IJavaObject)((IJavaClassType)receiver).sendMessage(FOR_NAME, FOR_NAME_SIGNATURE, args, this.getContext().getThread());
        }
        catch (CoreException e) {
            if (e.getStatus().getException() instanceof InvocationException && ((InvocationException)e.getStatus().getException()).exception().referenceType().name().equals("java.lang.ClassNotFoundException")) {
                return null;
            }
            throw e;
        }
    }

    protected void checkTypes(IJavaType[] types, String qualifiedName) throws CoreException {
        if (types == null || types.length == 0) {
            throw new CoreException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 0, MessageFormat.format(InstructionsEvaluationMessages.getString("Instruction.No_type"), qualifiedName), null));
        }
    }
}

