/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashSet;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.SyncInfoSnapReader_3;
import org.eclipse.core.internal.resources.Synchronizer;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

public class SyncInfoSnapReader {
    protected Workspace workspace;
    protected Synchronizer synchronizer;

    public SyncInfoSnapReader(Workspace workspace, Synchronizer synchronizer) {
        this.workspace = workspace;
        this.synchronizer = synchronizer;
    }

    protected SyncInfoSnapReader getReader(int formatVersion) throws IOException {
        switch (formatVersion) {
            case 3: {
                return new SyncInfoSnapReader_3(this.workspace, this.synchronizer);
            }
        }
        throw new IOException(Policy.bind("resources.format"));
    }

    public void readPartners(DataInputStream input) throws CoreException {
        try {
            int size = input.readInt();
            HashSet<QualifiedName> registry = new HashSet<QualifiedName>(size);
            for (int i = 0; i < size; ++i) {
                String qualifier = input.readUTF();
                String local = input.readUTF();
                registry.add(new QualifiedName(qualifier, local));
            }
            this.synchronizer.setRegistry(registry);
        }
        catch (IOException e) {
            String message = Policy.bind("resources.readSync", e.toString());
            throw new ResourceException(new ResourceStatus(566, message));
        }
    }

    public void readSyncInfo(DataInputStream input) throws IOException {
        int formatVersion = SyncInfoSnapReader.readVersionNumber(input);
        SyncInfoSnapReader reader = this.getReader(formatVersion);
        reader.readSyncInfo(input);
    }

    protected static int readVersionNumber(DataInputStream input) throws IOException {
        return input.readInt();
    }
}

