/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIException;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileVersioner;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ProfileStore {
    private static final String PREF_FORMATTER_PROFILES = "org.eclipse.jdt.ui.formatterprofiles";
    private static final String PREF_FORMATTER_PROFILES_VERSION = "org.eclipse.jdt.ui.formatterprofiles.version";
    private static final String XML_NODE_ROOT = "profiles";
    private static final String XML_NODE_PROFILE = "profile";
    private static final String XML_NODE_SETTING = "setting";
    private static final String XML_ATTRIBUTE_VERSION = "version";
    private static final String XML_ATTRIBUTE_ID = "id";
    private static final String XML_ATTRIBUTE_NAME = "name";
    private static final String XML_ATTRIBUTE_VALUE = "value";

    private ProfileStore() {
    }

    public static List readProfiles() throws CoreException {
        List res = ProfileStore.readProfilesFromPreferences(PREF_FORMATTER_PROFILES);
        if (res == null) {
            return ProfileStore.readOldForCompatibility();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeProfiles(Collection profiles) throws CoreException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(2000);
        try {
            String val;
            ProfileStore.writeProfilesToStream(profiles, stream);
            try {
                val = stream.toString("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                val = stream.toString();
            }
            IPreferenceStore preferenceStore = PreferenceConstants.getPreferenceStore();
            preferenceStore.setValue(PREF_FORMATTER_PROFILES, val);
            preferenceStore.setValue(PREF_FORMATTER_PROFILES_VERSION, 6);
            JavaPlugin.getDefault().savePluginPreferences();
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List readProfilesFromPreferences(String key) throws CoreException {
        String string = PreferenceConstants.getPreferenceStore().getString(key);
        if (string != null && string.length() > 0) {
            byte[] bytes;
            try {
                bytes = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                bytes = string.getBytes();
            }
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            try {
                List res = ProfileStore.readProfilesFromStream(new InputSource(is));
                if (res != null) {
                    for (int i = 0; i < res.size(); ++i) {
                        ProfileVersioner.updateAndComplete((ProfileManager.CustomProfile)res.get(i));
                    }
                }
                List list = res;
                return list;
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List readOldForCompatibility() {
        block9: {
            List list;
            String STORE_FILE = "code_formatter_profiles.xml";
            File file = JavaPlugin.getDefault().getStateLocation().append("code_formatter_profiles.xml").toFile();
            if (!file.exists()) {
                return null;
            }
            FileReader reader = new FileReader(file);
            try {
                List res = ProfileStore.readProfilesFromStream(new InputSource(reader));
                if (res != null) {
                    for (int i = 0; i < res.size(); ++i) {
                        ProfileVersioner.updateAndComplete((ProfileManager.CustomProfile)res.get(i));
                    }
                    ProfileStore.writeProfiles(res);
                }
                file.delete();
                list = res;
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                    throw throwable;
                }
                catch (CoreException e) {
                    JavaPlugin.log(e);
                    break block9;
                }
                catch (IOException e) {
                    JavaPlugin.log(e);
                }
            }
            reader.close();
            return list;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List readProfilesFromFile(File file) throws CoreException {
        List list;
        FileInputStream reader = new FileInputStream(file);
        try {
            list = ProfileStore.readProfilesFromStream(new InputSource(reader));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (IOException e) {
                throw ProfileStore.createException(e, FormatterMessages.getString("CodingStyleConfigurationBlock.error.reading_xml.message"));
            }
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list;
    }

    private static List readProfilesFromStream(InputSource inputSource) throws CoreException {
        ProfileDefaultHandler handler = new ProfileDefaultHandler();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(inputSource, (DefaultHandler)handler);
        }
        catch (SAXException e) {
            throw ProfileStore.createException(e, FormatterMessages.getString("CodingStyleConfigurationBlock.error.reading_xml.message"));
        }
        catch (IOException e) {
            throw ProfileStore.createException(e, FormatterMessages.getString("CodingStyleConfigurationBlock.error.reading_xml.message"));
        }
        catch (ParserConfigurationException e) {
            throw ProfileStore.createException(e, FormatterMessages.getString("CodingStyleConfigurationBlock.error.reading_xml.message"));
        }
        return handler.getProfiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeProfilesToFile(Collection profiles, File file) throws CoreException {
        try {
            FileOutputStream writer = new FileOutputStream(file);
            try {
                ProfileStore.writeProfilesToStream(profiles, writer);
            }
            finally {
                try {
                    ((OutputStream)writer).close();
                }
                catch (IOException e) {}
            }
        }
        catch (IOException e) {
            throw ProfileStore.createException(e, FormatterMessages.getString("CodingStyleConfigurationBlock.error.serializing_xml.message"));
        }
    }

    private static void writeProfilesToStream(Collection profiles, OutputStream stream) throws CoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element rootElement = document.createElement(XML_NODE_ROOT);
            rootElement.setAttribute(XML_ATTRIBUTE_VERSION, Integer.toString(6));
            document.appendChild(rootElement);
            Iterator iter = profiles.iterator();
            while (iter.hasNext()) {
                ProfileManager.Profile profile = (ProfileManager.Profile)iter.next();
                if (!(profile instanceof ProfileManager.CustomProfile)) continue;
                Element profileElement = ProfileStore.createProfileElement((ProfileManager.CustomProfile)profile, document);
                rootElement.appendChild(profileElement);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(document), new StreamResult(stream));
        }
        catch (TransformerException e) {
            throw ProfileStore.createException(e, FormatterMessages.getString("CodingStyleConfigurationBlock.error.serializing_xml.message"));
        }
        catch (ParserConfigurationException e) {
            throw ProfileStore.createException(e, FormatterMessages.getString("CodingStyleConfigurationBlock.error.serializing_xml.message"));
        }
    }

    private static Element createProfileElement(ProfileManager.CustomProfile profile, Document document) {
        Element element = document.createElement(XML_NODE_PROFILE);
        element.setAttribute(XML_ATTRIBUTE_NAME, profile.getName());
        element.setAttribute(XML_ATTRIBUTE_VERSION, Integer.toString(profile.getVersion()));
        Iterator keyIter = ProfileManager.getKeys().iterator();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            String value = (String)profile.getSettings().get(key);
            if (value != null) {
                Element setting = document.createElement(XML_NODE_SETTING);
                setting.setAttribute(XML_ATTRIBUTE_ID, key);
                setting.setAttribute(XML_ATTRIBUTE_VALUE, value);
                element.appendChild(setting);
                continue;
            }
            JavaPlugin.logErrorMessage("ProfileStore: Profile does not contain value for key " + key);
        }
        return element;
    }

    public static void checkCurrentOptionsVersion() {
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        int version = store.getInt(PREF_FORMATTER_PROFILES_VERSION);
        if (version >= 6) {
            return;
        }
        try {
            ProfileManager manager;
            ProfileManager.Profile selected;
            List profiles = ProfileStore.readProfiles();
            if (profiles != null && !profiles.isEmpty() && (selected = (manager = new ProfileManager(profiles)).getSelected()) instanceof ProfileManager.CustomProfile) {
                manager.commitChanges();
            }
            store.setValue(PREF_FORMATTER_PROFILES_VERSION, 6);
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
    }

    private static JavaUIException createException(Throwable t, String message) {
        return new JavaUIException(JavaUIStatus.createError(4, message, t));
    }

    private static final class ProfileDefaultHandler
    extends DefaultHandler {
        private List fProfiles;
        private int fVersion;
        private String fName;
        private Map fSettings;

        private ProfileDefaultHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals(ProfileStore.XML_NODE_SETTING)) {
                String key = attributes.getValue(ProfileStore.XML_ATTRIBUTE_ID);
                String value = attributes.getValue(ProfileStore.XML_ATTRIBUTE_VALUE);
                this.fSettings.put(key, value);
            } else if (qName.equals(ProfileStore.XML_NODE_PROFILE)) {
                this.fName = attributes.getValue(ProfileStore.XML_ATTRIBUTE_NAME);
                this.fSettings = new HashMap(200);
            } else if (qName.equals(ProfileStore.XML_NODE_ROOT)) {
                this.fProfiles = new ArrayList();
                try {
                    this.fVersion = Integer.parseInt(attributes.getValue(ProfileStore.XML_ATTRIBUTE_VERSION));
                }
                catch (NumberFormatException ex) {
                    throw new SAXException(ex);
                }
            }
        }

        public void endElement(String uri, String localName, String qName) {
            if (qName.equals(ProfileStore.XML_NODE_PROFILE)) {
                this.fProfiles.add(new ProfileManager.CustomProfile(this.fName, this.fSettings, this.fVersion));
                this.fName = null;
                this.fSettings = null;
            }
        }

        public List getProfiles() {
            return this.fProfiles;
        }
    }
}

