/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.codegen;

import org.eclipse.jdt.internal.compiler.codegen.CaseLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;

public class Label {
    public CodeStream codeStream;
    static final int POS_NOT_SET = -1;
    public int position = -1;
    public int[] forwardReferences = new int[10];
    public int forwardReferenceCount = 0;
    private boolean isWide = false;

    public Label() {
    }

    public Label(CodeStream codeStream) {
        this.codeStream = codeStream;
    }

    void addForwardReference(int iPos) {
        int length = this.forwardReferences.length;
        if (this.forwardReferenceCount >= length) {
            this.forwardReferences = new int[2 * length];
            System.arraycopy(this.forwardReferences, 0, this.forwardReferences, 0, length);
        }
        this.forwardReferences[this.forwardReferenceCount++] = iPos;
    }

    public void appendForwardReferencesFrom(Label otherLabel) {
        int otherCount = otherLabel.forwardReferenceCount;
        if (otherCount == 0) {
            return;
        }
        int neededSpace = otherCount + this.forwardReferenceCount;
        int length = this.forwardReferences.length;
        if (neededSpace >= length) {
            this.forwardReferences = new int[neededSpace];
            System.arraycopy(this.forwardReferences, 0, this.forwardReferences, 0, this.forwardReferenceCount);
        }
        System.arraycopy(otherLabel.forwardReferences, 0, this.forwardReferences, this.forwardReferenceCount, otherCount);
        this.forwardReferenceCount = neededSpace;
    }

    void branch() {
        if (this.position == -1) {
            this.addForwardReference(this.codeStream.position);
            this.codeStream.position += 2;
            this.codeStream.classFileOffset += 2;
        } else {
            int offset = this.position - this.codeStream.position + 1;
            if (Math.abs(offset) > Short.MAX_VALUE && !this.codeStream.wideMode) {
                throw new AbortMethod(CodeStream.RESTART_IN_WIDE_MODE, null);
            }
            this.codeStream.writeSignedShort(offset);
        }
    }

    void branchWide() {
        if (this.position == -1) {
            this.addForwardReference(this.codeStream.position);
            this.isWide = true;
            this.codeStream.position += 4;
            this.codeStream.classFileOffset += 4;
        } else {
            this.codeStream.writeSignedWord(this.position - this.codeStream.position + 1);
        }
    }

    public boolean hasForwardReferences() {
        return this.forwardReferenceCount != 0;
    }

    public void inlineForwardReferencesFromLabelsTargeting(int gotoLocation) {
        Label[] labels = this.codeStream.labels;
        for (int i = this.codeStream.countLabels - 1; i >= 0; --i) {
            Label label = labels[i];
            if (label.position != gotoLocation || !label.isStandardLabel()) break;
            this.appendForwardReferencesFrom(label);
        }
    }

    public void initialize(CodeStream stream) {
        this.codeStream = stream;
        this.position = -1;
        this.forwardReferenceCount = 0;
    }

    public boolean isStandardLabel() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void place() {
        int i;
        if (this.position != -1) return;
        this.position = this.codeStream.position;
        this.codeStream.addLabel(this);
        int oldPosition = this.position;
        boolean isOptimizedBranch = false;
        if (this.forwardReferenceCount != 0) {
            boolean bl = isOptimizedBranch = this.forwardReferences[this.forwardReferenceCount - 1] + 2 == this.position && this.codeStream.bCodeStream[this.codeStream.classFileOffset - 3] == -89;
            if (isOptimizedBranch) {
                this.codeStream.position = this.position -= 3;
                this.codeStream.classFileOffset -= 3;
                --this.forwardReferenceCount;
                int index = this.codeStream.pcToSourceMapSize - 2;
                if (this.codeStream.lastEntryPC == oldPosition) {
                    this.codeStream.lastEntryPC = this.position;
                }
                if (index >= 0 && this.codeStream.pcToSourceMap[index] == this.position) {
                    this.codeStream.pcToSourceMapSize -= 2;
                }
                if (this.codeStream.generateLocalVariableTableAttributes) {
                    LocalVariableBinding[] locals = this.codeStream.locals;
                    int max = locals.length;
                    for (int i2 = 0; i2 < max; ++i2) {
                        LocalVariableBinding local = locals[i2];
                        if (local == null || local.initializationCount <= 0) continue;
                        if (local.initializationPCs[(local.initializationCount - 1 << 1) + 1] == oldPosition) {
                            local.initializationPCs[(local.initializationCount - 1 << 1) + 1] = this.position;
                        }
                        if (local.initializationPCs[local.initializationCount - 1 << 1] != oldPosition) continue;
                        local.initializationPCs[local.initializationCount - 1 << 1] = this.position;
                    }
                }
            }
        }
        for (i = 0; i < this.forwardReferenceCount; ++i) {
            int offset = this.position - this.forwardReferences[i] + 1;
            if (Math.abs(offset) > Short.MAX_VALUE && !this.codeStream.wideMode) {
                throw new AbortMethod(CodeStream.RESTART_IN_WIDE_MODE, null);
            }
            if (this.codeStream.wideMode) {
                if (this.isWide) {
                    this.codeStream.writeSignedWord(this.forwardReferences[i], offset);
                    continue;
                }
                this.codeStream.writeSignedShort(this.forwardReferences[i], offset);
                continue;
            }
            this.codeStream.writeSignedShort(this.forwardReferences[i], offset);
        }
        if (!isOptimizedBranch) return;
        for (i = 0; i < this.codeStream.countLabels; ++i) {
            Label label = this.codeStream.labels[i];
            if (oldPosition != label.position) continue;
            label.position = this.position;
            if (label instanceof CaseLabel) {
                int offset = this.position - ((CaseLabel)label).instructionPosition;
                for (int j = 0; j < label.forwardReferenceCount; ++j) {
                    int forwardPosition = label.forwardReferences[j];
                    this.codeStream.writeSignedWord(forwardPosition, offset);
                }
                continue;
            }
            for (int j = 0; j < label.forwardReferenceCount; ++j) {
                int forwardPosition = label.forwardReferences[j];
                int offset = this.position - forwardPosition + 1;
                if (Math.abs(offset) > Short.MAX_VALUE && !this.codeStream.wideMode) {
                    throw new AbortMethod(CodeStream.RESTART_IN_WIDE_MODE, null);
                }
                if (this.codeStream.wideMode) {
                    if (this.isWide) {
                        this.codeStream.writeSignedWord(forwardPosition, offset);
                        continue;
                    }
                    this.codeStream.writeSignedShort(forwardPosition, offset);
                    continue;
                }
                this.codeStream.writeSignedShort(forwardPosition, offset);
            }
        }
    }

    public String toString() {
        String basic = this.getClass().getName();
        basic = basic.substring(basic.lastIndexOf(46) + 1);
        StringBuffer buffer = new StringBuffer(basic);
        buffer.append('@').append(Integer.toHexString(this.hashCode()));
        buffer.append("(position=").append(this.position);
        buffer.append(", forwards = [");
        for (int i = 0; i < this.forwardReferenceCount - 1; ++i) {
            buffer.append(this.forwardReferences[i] + ", ");
        }
        if (this.forwardReferenceCount >= 1) {
            buffer.append(this.forwardReferences[this.forwardReferenceCount - 1]);
        }
        buffer.append("] )");
        return buffer.toString();
    }
}

