/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.search;

import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.core.ICategory;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.internal.search.BaseSearchCategory;
import org.eclipse.update.search.IQueryUpdateSiteAdapter;
import org.eclipse.update.search.IUpdateSearchFilter;
import org.eclipse.update.search.IUpdateSearchQuery;
import org.eclipse.update.search.IUpdateSearchResultCollector;

public class SiteSearchCategory
extends BaseSearchCategory {
    private IUpdateSearchQuery[] queries = new IUpdateSearchQuery[]{new Query()};
    private static final String CATEGORY_ID = "org.eclipse.update.core.unified-search";

    public SiteSearchCategory() {
        super(CATEGORY_ID);
    }

    public IUpdateSearchQuery[] getQueries() {
        return this.queries;
    }

    private static class Query
    implements IUpdateSearchQuery {
        private Query() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(ISite site, String[] categoriesToSkip, IUpdateSearchFilter filter, IUpdateSearchResultCollector collector, IProgressMonitor monitor) {
            int i;
            ISiteFeatureReference[] refs = site.getFeatureReferences();
            HashSet<String> ignores = new HashSet<String>();
            if (categoriesToSkip != null) {
                for (i = 0; i < categoriesToSkip.length; ++i) {
                    ignores.add(categoriesToSkip[i]);
                }
            }
            monitor.beginTask("", refs.length);
            for (i = 0; i < refs.length; ++i) {
                ISiteFeatureReference ref = refs[i];
                boolean skipFeature = false;
                if (monitor.isCanceled()) break;
                if (ignores.size() > 0) {
                    ICategory[] categories = ref.getCategories();
                    for (int j = 0; j < categories.length; ++j) {
                        ICategory category = categories[j];
                        if (!ignores.contains(category.getName())) continue;
                        skipFeature = true;
                        break;
                    }
                }
                try {
                    if (skipFeature || !filter.accept(ref)) continue;
                    IFeature feature = ref.getFeature(null);
                    if (filter.accept(feature)) {
                        collector.accept(feature);
                    }
                    monitor.subTask(feature.getLabel());
                    continue;
                }
                catch (CoreException e) {
                    System.out.println((Object)e);
                    continue;
                }
                finally {
                    monitor.worked(1);
                }
            }
        }

        public IQueryUpdateSiteAdapter getQuerySearchSite() {
            return null;
        }
    }
}

