/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.launch;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.AbstractDebugEventHandler;
import org.eclipse.debug.internal.ui.views.launch.LaunchView;
import org.eclipse.debug.internal.ui.views.launch.LaunchViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;

public class LaunchViewEventHandler
extends AbstractDebugEventHandler
implements ILaunchesListener2 {
    private ThreadTimer fThreadTimer = new ThreadTimer();
    private IStackFrame fLastStackFrame = null;

    public LaunchViewEventHandler(LaunchView view) {
        super(view);
        DebugPlugin plugin = DebugPlugin.getDefault();
        plugin.getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    protected void doHandleDebugEvents(DebugEvent[] events) {
        this.fThreadTimer.handleDebugEvents(events);
        Object suspendee = null;
        block7: for (int i = 0; i < events.length; ++i) {
            DebugEvent event = events[i];
            Object source = event.getSource();
            if (!(source instanceof IStackFrame || source instanceof IThread || source instanceof IDebugTarget || source instanceof IProcess)) {
                return;
            }
            switch (event.getKind()) {
                case 4: {
                    this.insert(source);
                    if (!(source instanceof IDebugTarget)) continue block7;
                    ILaunch launch = ((IDebugTarget)source).getLaunch();
                    this.getLaunchView().autoExpand(launch, false, true);
                    continue block7;
                }
                case 8: {
                    if (source instanceof IThread) {
                        this.clearSourceSelection(source);
                        this.fThreadTimer.getTimedOutThreads().remove(source);
                        this.remove(source);
                        continue block7;
                    }
                    if (source instanceof IDebugTarget) {
                        this.clearSourceSelection(source);
                    }
                    Object parent = ((ITreeContentProvider)this.getTreeViewer().getContentProvider()).getParent(source);
                    this.refresh(parent);
                    continue block7;
                }
                case 1: {
                    this.doHandleResumeEvent(event, source);
                    continue block7;
                }
                case 2: {
                    if (suspendee != null && suspendee.equals(source)) continue block7;
                    this.doHandleSuspendEvent(source, event);
                    suspendee = source;
                    continue block7;
                }
                case 16: {
                    IStackFrame lastFrame;
                    if (source instanceof IStackFrame && source.equals(lastFrame = this.getLaunchView().getStackFrame())) {
                        this.getLaunchView().setStackFrame(null);
                        this.getLaunchView().showEditorForCurrentSelection();
                    }
                    if (event.getDetail() == 256) {
                        this.labelChanged(source);
                        continue block7;
                    }
                    this.refresh(source);
                }
            }
        }
    }

    protected void doHandleResumeEvent(DebugEvent event, Object source) {
        if (!event.isEvaluation()) {
            this.clearSourceSelection(source);
        }
        if (event.isEvaluation() || event.isStepStart()) {
            IThread thread = this.getThread(source);
            if (thread != null) {
                this.fThreadTimer.startTimer(thread);
            }
            return;
        }
        this.refresh(source);
        if (source instanceof IThread) {
            try {
                IThread[] threads = ((IThread)source).getDebugTarget().getThreads();
                for (int i = 0; i < threads.length; ++i) {
                    IStackFrame frame = threads[i].getTopStackFrame();
                    if (frame == null) continue;
                    this.selectAndReveal(frame);
                    return;
                }
            }
            catch (DebugException debugException) {
                // empty catch block
            }
            this.selectAndReveal(source);
            return;
        }
    }

    protected void updateRunningThread(IThread thread) {
        this.labelChanged(thread);
        this.getLaunchViewer().updateStackFrameImages(thread);
        this.clearSourceSelection(thread);
    }

    protected void doHandleSuspendEvent(Object element, DebugEvent event) {
        IThread thread = this.getThread(element);
        if (thread != null) {
            this.fThreadTimer.stopTimer(thread);
        }
        boolean wasTimedOut = this.fThreadTimer.getTimedOutThreads().remove(thread);
        if (event.isEvaluation() && (event.getDetail() & 0x80) != 0 && thread != null && !wasTimedOut) {
            return;
        }
        if (element instanceof IThread) {
            this.doHandleSuspendThreadEvent((IThread)element, event, wasTimedOut);
            return;
        }
        this.refresh(element);
    }

    protected void doHandleSuspendThreadEvent(IThread thread, DebugEvent event, boolean wasTimedOut) {
        if (!thread.isSuspended() || !this.isAvailable()) {
            return;
        }
        boolean evaluationEvent = event.isEvaluation();
        try {
            IStackFrame frame = thread.getTopStackFrame();
            if (frame != null && frame.equals(this.fLastStackFrame)) {
                if (wasTimedOut) {
                    this.getLaunchViewer().updateStackFrameImages(thread);
                }
                this.getLaunchViewer().update(new Object[]{thread, frame}, null);
                if (!evaluationEvent) {
                    this.getLaunchViewer().setSelection((ISelection)new StructuredSelection((Object)frame));
                } else if (wasTimedOut) {
                    this.getLaunchView().showEditorForCurrentSelection();
                }
                return;
            }
        }
        catch (DebugException e) {
            // empty catch block
        }
        this.getLaunchView().autoExpand(thread, true, !evaluationEvent);
        try {
            this.fLastStackFrame = thread.getTopStackFrame();
        }
        catch (DebugException e) {
            this.fLastStackFrame = null;
        }
    }

    protected void updateForDebugEvents(DebugEvent[] events) {
        super.updateForDebugEvents(events);
        if (this.isViewVisible()) {
            return;
        }
        this.doHandleDebugEvents(events);
    }

    public void dispose() {
        super.dispose();
        this.fThreadTimer.stop();
        DebugPlugin plugin = DebugPlugin.getDefault();
        plugin.getLaunchManager().removeLaunchListener((ILaunchesListener)this);
    }

    private void clearSourceSelection(Object source) {
        if (this.getViewer() != null) {
            this.getLaunchView().clearSourceSelection(source);
        }
    }

    protected LaunchViewer getLaunchViewer() {
        return (LaunchViewer)this.getViewer();
    }

    protected LaunchView getLaunchView() {
        return (LaunchView)this.getView();
    }

    private IThread getThread(Object element) {
        IThread thread = null;
        if (element instanceof IThread) {
            thread = (IThread)element;
        } else if (element instanceof IStackFrame) {
            thread = ((IStackFrame)element).getThread();
        }
        return thread;
    }

    public void launchesAdded(final ILaunch[] launches) {
        Runnable r = new Runnable(){

            public void run() {
                if (LaunchViewEventHandler.this.isAvailable()) {
                    if (launches.length == 1) {
                        LaunchViewEventHandler.this.insert(launches[0]);
                    } else {
                        LaunchViewEventHandler.this.refresh();
                    }
                    for (int i = 0; i < launches.length; ++i) {
                        if (!launches[i].hasChildren()) continue;
                        LaunchViewEventHandler.this.getLaunchView().autoExpand(launches[i], false, i == launches.length - 1);
                    }
                }
            }
        };
        this.getView().syncExec(r);
    }

    public void launchesChanged(final ILaunch[] launches) {
        Runnable r = new Runnable(){

            public void run() {
                if (LaunchViewEventHandler.this.isAvailable()) {
                    if (launches.length == 1) {
                        LaunchViewEventHandler.this.refresh(launches[0]);
                    } else {
                        LaunchViewEventHandler.this.refresh();
                    }
                    for (int i = 0; i < launches.length; ++i) {
                        if (!launches[i].hasChildren()) continue;
                        LaunchViewEventHandler.this.getLaunchView().autoExpand(launches[i], false, i == launches.length - 1);
                    }
                }
            }
        };
        this.getView().syncExec(r);
    }

    public void launchesRemoved(final ILaunch[] launches) {
        Runnable r = new Runnable(){

            public void run() {
                if (LaunchViewEventHandler.this.isAvailable()) {
                    if (launches.length == 1) {
                        LaunchViewEventHandler.this.remove(launches[0]);
                    } else {
                        LaunchViewEventHandler.this.refresh();
                    }
                    ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
                    IDebugTarget[] targets = lm.getDebugTargets();
                    if (targets.length > 0) {
                        IDebugTarget target = targets[targets.length - 1];
                        try {
                            IThread[] threads = target.getThreads();
                            for (int i = 0; i < threads.length; ++i) {
                                if (!threads[i].isSuspended()) continue;
                                LaunchViewEventHandler.this.getLaunchView().autoExpand(threads[i], false, true);
                                return;
                            }
                        }
                        catch (DebugException de) {
                            DebugUIPlugin.log(de);
                        }
                        LaunchViewEventHandler.this.getLaunchView().autoExpand(target.getLaunch(), false, true);
                    }
                }
            }
        };
        this.getView().asyncExec(r);
    }

    public void launchesTerminated(final ILaunch[] launches) {
        if (this.fLastStackFrame != null) {
            ILaunch launch = this.fLastStackFrame.getLaunch();
            for (int i = 0; i < launches.length; ++i) {
                ILaunch terminatedLaunch = launches[i];
                if (!terminatedLaunch.equals(launch)) continue;
                this.fLastStackFrame = null;
            }
        }
        Runnable r = new Runnable(){

            public void run() {
                LaunchViewEventHandler.this.getLaunchView().launchesTerminated(launches);
            }
        };
        this.getView().asyncExec(r);
    }

    class ThreadTimer {
        private Thread fThread;
        private long TIMEOUT = 500L;
        private long timeEmpty = 0L;
        private long MAX_TIME_EMPTY = 3000L;
        private boolean fStopped = false;
        private Object fLock = new Object();
        HashMap fStopTimes = new HashMap();
        HashSet fTimedOutThreads = new HashSet();

        ThreadTimer() {
        }

        public Set getTimedOutThreads() {
            return this.fTimedOutThreads;
        }

        public void handleDebugEvents(DebugEvent[] events) {
            if (this.fStopped) {
                return;
            }
            int numEvents = events.length;
            for (int i = 0; i < numEvents; ++i) {
                DebugEvent event = events[i];
                if (event.getKind() != 8 || !(event.getSource() instanceof IDebugTarget)) continue;
                ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
                for (int j = 0; j < launches.length; ++j) {
                    IDebugTarget[] targets = launches[j].getDebugTargets();
                    for (int k = 0; k < targets.length; ++k) {
                        IDebugTarget target = targets[k];
                        if (target == null || target.isDisconnected() || target.isTerminated()) continue;
                        return;
                    }
                }
                this.stop();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startTimer(IThread thread) {
            Object object = this.fLock;
            synchronized (object) {
                this.fStopTimes.put(thread, new Long(System.currentTimeMillis() + this.TIMEOUT));
                if (this.fThread == null) {
                    this.startThread();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Object object = this.fLock;
            synchronized (object) {
                this.fStopped = true;
                this.fThread = null;
                this.fStopTimes.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopTimer(IThread thread) {
            Object object = this.fLock;
            synchronized (object) {
                this.fStopTimes.remove(thread);
            }
        }

        private void startThread() {
            this.fThread = new Thread(new Runnable(this){
                private final /* synthetic */ ThreadTimer this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    ThreadTimer.access$002(this.this$1, false);
                    while (!ThreadTimer.access$000(this.this$1)) {
                        ThreadTimer.access$100(this.this$1);
                    }
                }
            }, "Thread timer");
            this.fThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkTimers() {
            Map.Entry[] entries;
            long timeToWait = this.TIMEOUT;
            Object object = this.fLock;
            synchronized (object) {
                if (this.fStopTimes.size() == 0) {
                    if (this.timeEmpty == 0L) {
                        this.timeEmpty = System.currentTimeMillis();
                    } else if (System.currentTimeMillis() - this.timeEmpty > this.MAX_TIME_EMPTY) {
                        this.stop();
                        return;
                    }
                } else {
                    this.timeEmpty = 0L;
                }
                entries = this.fStopTimes.entrySet().toArray(new Map.Entry[0]);
            }
            long currentTime = System.currentTimeMillis();
            Map.Entry entry = null;
            int numEntries = entries.length;
            for (int i = 0; i < numEntries; ++i) {
                entry = entries[i];
                Long entryValue = (Long)entry.getValue();
                if (entryValue == null) continue;
                long stopTime = entryValue;
                if (stopTime <= currentTime) {
                    IThread thread = (IThread)entry.getKey();
                    this.fStopTimes.remove(thread);
                    LaunchViewEventHandler.this.getView().asyncExec(new Runnable(this, thread){
                        private final /* synthetic */ IThread val$thread;
                        private final /* synthetic */ ThreadTimer this$1;
                        {
                            this.this$1 = this$1;
                            this.val$thread = val$thread;
                        }

                        public void run() {
                            this.this$1.fTimedOutThreads.add(this.val$thread);
                            ThreadTimer.access$200(this.this$1).updateRunningThread(this.val$thread);
                        }
                    });
                    continue;
                }
                timeToWait = Math.min(timeToWait, stopTime - currentTime);
            }
            try {
                Thread.sleep(timeToWait);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }

        static /* synthetic */ boolean access$002(ThreadTimer x0, boolean x1) {
            x0.fStopped = x1;
            return x0.fStopped;
        }

        static /* synthetic */ boolean access$000(ThreadTimer x0) {
            return x0.fStopped;
        }

        static /* synthetic */ void access$100(ThreadTimer x0) {
            x0.checkTimers();
        }

        static /* synthetic */ LaunchViewEventHandler access$200(ThreadTimer x0) {
            return x0.LaunchViewEventHandler.this;
        }
    }
}

