/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.TracingOptionsManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.launcher.AbstractLauncherTab;
import org.eclipse.pde.internal.ui.launcher.ILauncherSettings;
import org.eclipse.pde.internal.ui.launcher.TracingPropertySource;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;
import org.eclipse.ui.help.WorkbenchHelp;

public class TracingLauncherTab
extends AbstractLauncherTab
implements ILauncherSettings {
    private Button fTracingCheck;
    private CheckboxTableViewer fPluginViewer;
    private IPluginModelBase[] fTraceableModels;
    private Properties fMasterOptions = new Properties();
    private Hashtable fPropertySources = new Hashtable();
    private FormToolkit toolkit;
    private ScrolledPageBook pageBook;
    private Label fPropertyLabel;
    private Image fImage;
    private Button fSelectAllButton;
    private Button fDeselectAllButton;

    public TracingLauncherTab() {
        PDEPlugin.getDefault().getLabelProvider().connect(this);
        this.fImage = PDEPluginImages.DESC_DOC_SECTION_OBJ.createImage();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        Dialog.applyDialogFont((Control)container);
        this.createEnableTracingButton(container);
        Label separator = new Label(container, 258);
        separator.setLayoutData((Object)new GridData(768));
        this.createSashSection(container);
        this.createButtonSection(container);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.launcher_tracing");
    }

    private void createButtonSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        this.fSelectAllButton = new Button(container, 8);
        this.fSelectAllButton.setText(PDEPlugin.getResourceString("TracingLauncherTab.selectAll"));
        this.fSelectAllButton.setLayoutData((Object)new GridData(32));
        SWTUtil.setButtonDimensionHint(this.fSelectAllButton);
        this.fSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TracingLauncherTab.this.fPluginViewer.setAllChecked(true);
                TracingLauncherTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fDeselectAllButton = new Button(container, 8);
        this.fDeselectAllButton.setText(PDEPlugin.getResourceString("TracinglauncherTab.deselectAll"));
        this.fDeselectAllButton.setLayoutData((Object)new GridData(32));
        SWTUtil.setButtonDimensionHint(this.fDeselectAllButton);
        this.fDeselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TracingLauncherTab.this.fPluginViewer.setAllChecked(false);
                TracingLauncherTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createEnableTracingButton(Composite container) {
        this.fTracingCheck = new Button(container, 32);
        this.fTracingCheck.setText(PDEPlugin.getResourceString("TracingLauncherTab.tracing"));
        this.fTracingCheck.setLayoutData((Object)new GridData(768));
        this.fTracingCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TracingLauncherTab.this.masterCheckChanged(true);
                TracingLauncherTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createSashSection(Composite container) {
        SashForm sashForm = new SashForm(container, 256);
        sashForm.setLayoutData((Object)new GridData(1808));
        this.createPluginViewer((Composite)sashForm);
        this.createPropertySheetClient((Composite)sashForm);
    }

    private void createPluginViewer(Composite sashForm) {
        Composite composite = new Composite(sashForm, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(PDEPlugin.getResourceString("TracingLauncherTab.plugins"));
        this.fPluginViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        this.fPluginViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fPluginViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fPluginViewer.setSorter((ViewerSorter)new ListUtil.PluginSorter());
        this.fPluginViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                TracingLauncherTab.this.pluginSelected(TracingLauncherTab.this.getSelectedModel());
            }
        });
        this.fPluginViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                TracingLauncherTab.this.updateLaunchConfigurationDialog();
            }
        });
        GridData gd = new GridData(1808);
        gd.widthHint = 125;
        gd.heightHint = 100;
        this.fPluginViewer.getTable().setLayoutData((Object)gd);
        this.fPluginViewer.setInput((Object)this.getTraceableModels());
    }

    private void createPropertySheetClient(Composite sashForm) {
        int margin;
        Composite tableChild = new Composite(sashForm, 0);
        GridLayout layout = new GridLayout();
        tableChild.setLayout((Layout)layout);
        this.fPropertyLabel = new Label(tableChild, 0);
        this.fPropertyLabel.setLayoutData((Object)new GridData(768));
        this.updatePropertyLabel(null);
        layout.marginWidth = layout.marginHeight = (margin = this.createPropertySheet(tableChild));
    }

    protected int createPropertySheet(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        int toolkitBorderStyle = this.toolkit.getBorderStyle();
        int style = toolkitBorderStyle == 2048 ? 0 : 2048;
        this.pageBook = new ScrolledPageBook(parent, style | 0x200 | 0x100);
        this.toolkit.adapt((Control)this.pageBook, false, false);
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        gd.widthHint = 125;
        this.pageBook.setLayoutData((Object)gd);
        if (style == 0) {
            this.pageBook.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
            this.toolkit.paintBordersFor(parent);
        }
        return style == 0 ? 2 : 0;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.pageBook.getParent().getParent().layout(true);
    }

    public void dispose() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
        if (this.fImage != null) {
            this.fImage.dispose();
        }
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
        super.dispose();
    }

    public FormToolkit getToolkit() {
        return this.toolkit;
    }

    private IPluginModelBase[] getTraceableModels() {
        if (this.fTraceableModels == null) {
            PluginModelManager manager = PDECore.getDefault().getModelManager();
            IPluginModelBase[] models = manager.getPlugins();
            ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
            for (int i = 0; i < models.length; ++i) {
                if (!TracingOptionsManager.isTraceable((IPluginModelBase)models[i])) continue;
                result.add(models[i]);
            }
            this.fTraceableModels = result.toArray(new IPluginModelBase[result.size()]);
        }
        return this.fTraceableModels;
    }

    private TracingPropertySource getPropertySource(IPluginModelBase model) {
        if (model == null) {
            return null;
        }
        TracingPropertySource source = (TracingPropertySource)this.fPropertySources.get(model);
        if (source == null) {
            String id = model.getPluginBase().getId();
            Hashtable defaults = PDECore.getDefault().getTracingOptionsManager().getTemplateTable(id);
            source = new TracingPropertySource(model, this.fMasterOptions, defaults, this);
            this.fPropertySources.put(model, source);
        }
        return source;
    }

    private void masterCheckChanged(boolean userChange) {
        boolean enabled = this.fTracingCheck.getSelection();
        this.fPluginViewer.getTable().setEnabled(enabled);
        this.pageBook.setEnabled(enabled);
        this.fSelectAllButton.setEnabled(enabled);
        this.fDeselectAllButton.setEnabled(enabled);
    }

    private void disposePropertySources() {
        Enumeration enumeration = this.fPropertySources.elements();
        while (enumeration.hasMoreElements()) {
            TracingPropertySource source = (TracingPropertySource)enumeration.nextElement();
            this.pageBook.removePage((Object)source.getModel());
        }
        this.fPropertySources.clear();
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.fMasterOptions.clear();
        this.disposePropertySources();
        try {
            this.fTracingCheck.setSelection(config.getAttribute("tracing", false));
            Map options = config.getAttribute("tracingOptions", (Map)null);
            options = options == null ? PDECore.getDefault().getTracingOptionsManager().getTracingTemplateCopy() : PDECore.getDefault().getTracingOptionsManager().getTracingOptions(options);
            this.fMasterOptions.putAll((Map<?, ?>)options);
            this.masterCheckChanged(false);
            IPluginModelBase model = this.getLastSelectedPlugin(config);
            if (model != null) {
                this.fPluginViewer.setSelection((ISelection)new StructuredSelection((Object)model));
            } else {
                this.pluginSelected(null);
            }
            String checked = config.getAttribute("checked", (String)null);
            if (checked == null) {
                this.fPluginViewer.setAllChecked(true);
            } else if (checked.equals("[NONE]")) {
                this.fPluginViewer.setAllChecked(false);
            } else {
                StringTokenizer tokenizer = new StringTokenizer(checked, ",");
                ArrayList<IPluginModelBase> list = new ArrayList<IPluginModelBase>();
                PluginModelManager manager = PDECore.getDefault().getModelManager();
                while (tokenizer.hasMoreTokens()) {
                    String id = tokenizer.nextToken();
                    ModelEntry entry = manager.findEntry(id);
                    if (entry == null) continue;
                    list.add(entry.getActiveModel());
                }
                this.fPluginViewer.setCheckedElements(list.toArray());
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private IPluginModelBase getLastSelectedPlugin(ILaunchConfiguration config) throws CoreException {
        String pluginID = config.getAttribute("selectedPlugin", (String)null);
        if (pluginID != null) {
            ModelEntry entry = PDECore.getDefault().getModelManager().findEntry(pluginID);
            return entry == null ? null : entry.getActiveModel();
        }
        return null;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        boolean tracingEnabled = this.fTracingCheck.getSelection();
        config.setAttribute("tracing", tracingEnabled);
        if (tracingEnabled) {
            IPluginModelBase model = this.getSelectedModel();
            String id = model == null ? null : model.getPluginBase().getId();
            config.setAttribute("selectedPlugin", id);
            boolean changes = false;
            Enumeration enumeration = this.fPropertySources.elements();
            while (enumeration.hasMoreElements()) {
                TracingPropertySource source = (TracingPropertySource)enumeration.nextElement();
                if (!source.isModified()) continue;
                changes = true;
                source.save();
            }
            if (changes) {
                config.setAttribute("tracingOptions", (Map)this.fMasterOptions);
            }
        } else {
            config.setAttribute("selectedPlugin", (String)null);
        }
        Object[] checked = this.fPluginViewer.getCheckedElements();
        if (checked.length == this.fPluginViewer.getTable().getItemCount()) {
            config.setAttribute("checked", (String)null);
        } else if (checked.length == 0) {
            config.setAttribute("checked", "[NONE]");
        } else {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < checked.length; ++i) {
                IPluginModelBase model = (IPluginModelBase)checked[i];
                buffer.append(model.getPluginBase().getId());
                if (i >= checked.length - 1) continue;
                buffer.append(',');
            }
            config.setAttribute("checked", buffer.toString());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("tracing", false);
        config.setAttribute("checked", "[NONE]");
    }

    private void updatePropertyLabel(IPluginModelBase model) {
        String text = model == null ? PDEPlugin.getResourceString("TracingLauncherTab.options") : PDEPlugin.getDefault().getLabelProvider().getText(model);
        this.fPropertyLabel.setText(text);
    }

    private void pluginSelected(IPluginModelBase model) {
        TracingPropertySource source = this.getPropertySource(model);
        if (source == null) {
            this.pageBook.showEmptyPage();
        } else {
            if (!this.pageBook.hasPage((Object)model)) {
                Composite parent = this.pageBook.createPage((Object)model);
                source.createContents(parent);
            }
            this.pageBook.showPage((Object)model);
        }
        this.updatePropertyLabel(model);
    }

    public String getName() {
        return PDEPlugin.getResourceString("TracingLauncherTab.name");
    }

    public Image getImage() {
        return this.fImage;
    }

    private IPluginModelBase getSelectedModel() {
        Object item;
        if (this.fTracingCheck.isEnabled() && (item = ((IStructuredSelection)this.fPluginViewer.getSelection()).getFirstElement()) instanceof IPluginModelBase) {
            return (IPluginModelBase)item;
        }
        return null;
    }
}

