/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.util;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.env.ISourceField;
import org.eclipse.jdt.internal.compiler.env.ISourceImport;
import org.eclipse.jdt.internal.compiler.env.ISourceMethod;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.lookup.CompilerModifiers;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.InitializerElementInfo;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.SourceFieldElementInfo;
import org.eclipse.jdt.internal.core.SourceMethodElementInfo;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;

public class ElementInfoConverter
implements CompilerModifiers {
    private boolean needLocalTypes;
    private ProblemReporter problemReporter;
    private CompilationUnitDeclaration unit;

    public static CompilationUnitDeclaration buildCompilationUnit(SourceTypeElementInfo[] sourceTypes, boolean needLocalTypes, ProblemReporter problemReporter, CompilationResult compilationResult) {
        return new ElementInfoConverter(needLocalTypes, problemReporter).convert(sourceTypes, compilationResult);
    }

    private ElementInfoConverter(boolean needLocalTypes, ProblemReporter problemReporter) {
        this.needLocalTypes = needLocalTypes;
        this.problemReporter = problemReporter;
    }

    private Initializer convert(InitializerElementInfo initializerInfo, CompilationResult compilationResult) {
        Block block = new Block(0);
        Initializer initializer = new Initializer(block, 0);
        int start = initializerInfo.getDeclarationSourceStart();
        int end = initializerInfo.getDeclarationSourceEnd();
        initializer.name = initializerInfo.getName();
        initializer.sourceStart = initializer.declarationSourceStart = start;
        initializer.sourceEnd = initializer.declarationSourceEnd = end;
        initializer.modifiers = initializerInfo.getModifiers();
        IJavaElement[] children = initializerInfo.getChildren();
        int typesLength = children.length;
        if (typesLength > 0) {
            Statement[] statements = new Statement[typesLength];
            for (int i = 0; i < typesLength; ++i) {
                JavaElement type = (JavaElement)children[i];
                try {
                    TypeDeclaration localType = this.convert((SourceTypeElementInfo)type.getElementInfo(), compilationResult);
                    if ((localType.bits & 0x200) != 0) {
                        QualifiedAllocationExpression expression = new QualifiedAllocationExpression(localType);
                        expression.type = localType.superclass;
                        localType.superclass = null;
                        localType.superInterfaces = null;
                        localType.allocation = expression;
                        statements[i] = expression;
                        continue;
                    }
                    statements[i] = localType;
                    continue;
                }
                catch (JavaModelException e) {
                    // empty catch block
                }
            }
            block.statements = statements;
        }
        return initializer;
    }

    private FieldDeclaration convert(SourceFieldElementInfo sourceField, CompilationResult compilationResult) {
        IJavaElement[] children;
        int typesLength;
        FieldDeclaration field = new FieldDeclaration();
        int start = sourceField.getNameSourceStart();
        int end = sourceField.getNameSourceEnd();
        field.name = sourceField.getName();
        field.sourceStart = start;
        field.sourceEnd = end;
        field.type = this.createTypeReference(sourceField.getTypeName(), start, end);
        field.declarationSourceStart = sourceField.getDeclarationSourceStart();
        field.declarationSourceEnd = sourceField.getDeclarationSourceEnd();
        field.modifiers = sourceField.getModifiers();
        if (this.needLocalTypes && (typesLength = (children = sourceField.getChildren()).length) > 0) {
            ArrayInitializer initializer = new ArrayInitializer();
            field.initialization = initializer;
            Expression[] expressions = new Expression[typesLength];
            initializer.expressions = expressions;
            for (int i = 0; i < typesLength; ++i) {
                IJavaElement localType = children[i];
                try {
                    TypeDeclaration anonymousLocalTypeDeclaration = this.convert((SourceTypeElementInfo)((JavaElement)localType).getElementInfo(), compilationResult);
                    QualifiedAllocationExpression expression = new QualifiedAllocationExpression(anonymousLocalTypeDeclaration);
                    expression.type = anonymousLocalTypeDeclaration.superclass;
                    anonymousLocalTypeDeclaration.superclass = null;
                    anonymousLocalTypeDeclaration.superInterfaces = null;
                    anonymousLocalTypeDeclaration.allocation = expression;
                    expressions[i] = expression;
                    continue;
                }
                catch (JavaModelException e) {
                    // empty catch block
                }
            }
        }
        return field;
    }

    private AbstractMethodDeclaration convert(SourceMethodElementInfo sourceMethod, CompilationResult compilationResult) {
        IJavaElement[] children;
        int typesLength;
        AbstractMethodDeclaration method;
        AbstractMethodDeclaration decl;
        int start = sourceMethod.getNameSourceStart();
        int end = sourceMethod.getNameSourceEnd();
        if (sourceMethod.isConstructor()) {
            decl = new ConstructorDeclaration(compilationResult);
            decl.isDefaultConstructor = false;
            method = decl;
        } else {
            decl = new MethodDeclaration(compilationResult);
            ((MethodDeclaration)decl).returnType = this.createTypeReference(sourceMethod.getReturnTypeName(), start, end);
            method = decl;
        }
        method.selector = sourceMethod.getSelector();
        method.modifiers = sourceMethod.getModifiers();
        method.sourceStart = start;
        method.sourceEnd = end;
        method.declarationSourceStart = sourceMethod.getDeclarationSourceStart();
        method.declarationSourceEnd = sourceMethod.getDeclarationSourceEnd();
        char[][] argumentTypeNames = sourceMethod.getArgumentTypeNames();
        char[][] argumentNames = sourceMethod.getArgumentNames();
        int argumentCount = argumentTypeNames == null ? 0 : argumentTypeNames.length;
        long position = (long)start << 32 + end;
        method.arguments = new Argument[argumentCount];
        for (int i = 0; i < argumentCount; ++i) {
            method.arguments[i] = new Argument(argumentNames[i], position, this.createTypeReference(argumentTypeNames[i], start, end), 0);
        }
        char[][] exceptionTypeNames = sourceMethod.getExceptionTypeNames();
        int exceptionCount = exceptionTypeNames == null ? 0 : exceptionTypeNames.length;
        method.thrownExceptions = new TypeReference[exceptionCount];
        for (int i = 0; i < exceptionCount; ++i) {
            method.thrownExceptions[i] = this.createTypeReference(exceptionTypeNames[i], start, end);
        }
        if (this.needLocalTypes && (typesLength = (children = sourceMethod.getChildren()).length) != 0) {
            Statement[] statements = new Statement[typesLength];
            for (int i = 0; i < typesLength; ++i) {
                JavaElement type = (JavaElement)children[i];
                try {
                    TypeDeclaration localType = this.convert((SourceTypeElementInfo)type.getElementInfo(), compilationResult);
                    if ((localType.bits & 0x200) != 0) {
                        QualifiedAllocationExpression expression = new QualifiedAllocationExpression(localType);
                        expression.type = localType.superclass;
                        localType.superclass = null;
                        localType.superInterfaces = null;
                        localType.allocation = expression;
                        statements[i] = expression;
                        continue;
                    }
                    statements[i] = localType;
                    continue;
                }
                catch (JavaModelException e) {
                    // empty catch block
                }
            }
            method.statements = statements;
        }
        return method;
    }

    private TypeDeclaration convert(SourceTypeElementInfo sourceType, CompilationResult compilationResult) {
        char[][] interfaceNames;
        int end;
        int start;
        TypeDeclaration type = new TypeDeclaration(compilationResult);
        if (sourceType.getEnclosingType() == null) {
            IType typeHandle = sourceType.getHandle();
            try {
                if (typeHandle.isAnonymous()) {
                    type.name = TypeDeclaration.ANONYMOUS_EMPTY_NAME;
                    type.bits |= 0x300;
                } else if (typeHandle.isLocal()) {
                    type.bits |= 0x100;
                }
            }
            catch (JavaModelException e) {}
        } else {
            type.bits |= 0x400;
        }
        if ((type.bits & 0x200) == 0) {
            type.name = sourceType.getName();
        }
        type.sourceStart = start = sourceType.getNameSourceStart();
        type.sourceEnd = end = sourceType.getNameSourceEnd();
        type.modifiers = sourceType.getModifiers();
        type.declarationSourceStart = sourceType.getDeclarationSourceStart();
        type.bodyEnd = type.declarationSourceEnd = sourceType.getDeclarationSourceEnd();
        if (sourceType.getSuperclassName() != null) {
            type.superclass = this.createTypeReference(sourceType.getSuperclassName(), start, end);
        }
        int interfaceCount = (interfaceNames = sourceType.getInterfaceNames()) == null ? 0 : interfaceNames.length;
        type.superInterfaces = new TypeReference[interfaceCount];
        for (int i = 0; i < interfaceCount; ++i) {
            type.superInterfaces[i] = this.createTypeReference(interfaceNames[i], start, end);
        }
        ISourceType[] sourceMemberTypes = sourceType.getMemberTypes();
        int sourceMemberTypeCount = sourceMemberTypes == null ? 0 : sourceMemberTypes.length;
        type.memberTypes = new TypeDeclaration[sourceMemberTypeCount];
        for (int i = 0; i < sourceMemberTypeCount; ++i) {
            type.memberTypes[i] = this.convert((SourceTypeElementInfo)sourceMemberTypes[i], compilationResult);
        }
        ISourceField[] sourceFields = sourceType.getFields();
        int sourceFieldCount = sourceFields == null ? 0 : sourceFields.length;
        InitializerElementInfo[] initializers = null;
        int initializerCount = 0;
        if (this.needLocalTypes) {
            initializers = sourceType.getInitializers();
            initializerCount = initializers.length;
            type.fields = new FieldDeclaration[initializerCount + sourceFieldCount];
            for (int i = 0; i < initializerCount; ++i) {
                type.fields[i] = this.convert(initializers[i], compilationResult);
            }
        } else {
            type.fields = new FieldDeclaration[sourceFieldCount];
        }
        int length = initializerCount + sourceFieldCount;
        int index = 0;
        for (int i = initializerCount; i < length; ++i) {
            type.fields[i] = this.convert((SourceFieldElementInfo)sourceFields[index++], compilationResult);
        }
        ISourceMethod[] sourceMethods = sourceType.getMethods();
        int sourceMethodCount = sourceMethods == null ? 0 : sourceMethods.length;
        int neededCount = 0;
        if (!type.isInterface()) {
            neededCount = 1;
            for (int i = 0; i < sourceMethodCount; ++i) {
                if (!sourceMethods[i].isConstructor()) continue;
                neededCount = 0;
                break;
            }
        }
        type.methods = new AbstractMethodDeclaration[sourceMethodCount + neededCount];
        if (neededCount != 0) {
            type.methods[0] = type.createsInternalConstructor(false, false);
        }
        boolean isInterface = type.isInterface();
        for (int i = 0; i < sourceMethodCount; ++i) {
            AbstractMethodDeclaration method = this.convert((SourceMethodElementInfo)sourceMethods[i], compilationResult);
            if (isInterface || method.isAbstract()) {
                method.modifiers |= 0x1000000;
            }
            type.methods[neededCount + i] = method;
        }
        return type;
    }

    private CompilationUnitDeclaration convert(SourceTypeElementInfo[] sourceTypes, CompilationResult compilationResult) {
        ISourceImport[] sourceImports;
        SourceTypeElementInfo sourceType = sourceTypes[0];
        if (sourceType.getName() == null) {
            return null;
        }
        this.unit = new CompilationUnitDeclaration(this.problemReporter, compilationResult, 0);
        int start = sourceType.getNameSourceStart();
        int end = sourceType.getNameSourceEnd();
        if (sourceType.getPackageName() != null && sourceType.getPackageName().length > 0) {
            this.unit.currentPackage = this.createImportReference(sourceType.getPackageName(), start, end, false, 0);
        }
        int importCount = (sourceImports = sourceType.getImports()) == null ? 0 : sourceImports.length;
        this.unit.imports = new ImportReference[importCount];
        for (int i = 0; i < importCount; ++i) {
            ISourceImport sourceImport = sourceImports[i];
            this.unit.imports[i] = this.createImportReference(sourceImport.getName(), sourceImport.getDeclarationSourceStart(), sourceImport.getDeclarationSourceEnd(), sourceImport.onDemand(), sourceImport.getModifiers());
        }
        int typeCount = sourceTypes.length;
        this.unit.types = new TypeDeclaration[typeCount];
        for (int i = 0; i < typeCount; ++i) {
            this.unit.types[i] = this.convert(sourceTypes[i], compilationResult);
        }
        return this.unit;
    }

    private ImportReference createImportReference(char[] importName, int start, int end, boolean onDemand, int modifiers) {
        char[][] qImportName = CharOperation.splitOn('.', importName);
        long[] positions = new long[qImportName.length];
        long position = (long)start << 32 + end;
        for (int i = 0; i < qImportName.length; ++i) {
            positions[i] = position;
        }
        return new ImportReference(qImportName, positions, onDemand, modifiers);
    }

    private TypeReference createTypeReference(char[] typeSignature, int start, int end) {
        int max;
        int dimStart = max = typeSignature.length;
        int dim = 0;
        int identCount = 1;
        block4: for (int i = 0; i < max; ++i) {
            switch (typeSignature[i]) {
                case '[': {
                    if (dim == 0) {
                        dimStart = i;
                    }
                    ++dim;
                    continue block4;
                }
                case '.': {
                    ++identCount;
                }
            }
        }
        if (identCount == 1) {
            if (dim == 0) {
                return new SingleTypeReference(typeSignature, ((long)start << 32) + (long)end);
            }
            char[] identifier = new char[dimStart];
            System.arraycopy(typeSignature, 0, identifier, 0, dimStart);
            return new ArrayTypeReference(identifier, dim, ((long)start << 32) + (long)end);
        }
        long[] positions = new long[identCount];
        long pos = ((long)start << 32) + (long)end;
        for (int i = 0; i < identCount; ++i) {
            positions[i] = pos;
        }
        char[][] identifiers = CharOperation.splitOn('.', typeSignature, 0, dimStart);
        if (dim == 0) {
            return new QualifiedTypeReference(identifiers, positions);
        }
        return new ArrayQualifiedTypeReference(identifiers, dim, positions);
    }
}

