/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.util.ArrayList;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.internal.core.memory.IExtendedMemoryBlock;
import org.eclipse.debug.internal.core.memory.IMemoryRendering;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewTab;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.TabItem;

public abstract class AbstractMemoryViewTab
implements IMemoryViewTab {
    protected IMemoryBlock fMemoryBlock;
    protected TabItem fTabItem;
    protected MenuManager fMenuMgr;
    protected IMemoryRendering fRendering;
    protected String fRenderingId;

    public AbstractMemoryViewTab(IMemoryBlock newMemory, TabItem newTab, MenuManager menuMgr, IMemoryRendering rendering) {
        this.fMemoryBlock = newMemory;
        this.fTabItem = newTab;
        this.fMenuMgr = menuMgr;
        this.fRendering = rendering;
        this.fRenderingId = rendering.getRenderingId();
        this.fTabItem.setData((Object)this);
        this.maintainRefAndEnablement(true);
    }

    public void setEnabled(boolean enabled) {
        this.maintainRefAndEnablement(enabled);
    }

    protected void maintainRefAndEnablement(boolean addReference) {
        if (addReference) {
            ArrayList references;
            if (this.getMemoryBlock() instanceof IExtendedMemoryBlock && (references = this.addReferenceToSynchronizer()).size() == 1 && !((IExtendedMemoryBlock)this.getMemoryBlock()).isEnabled()) {
                ((IExtendedMemoryBlock)this.getMemoryBlock()).enable();
            }
        } else if (!addReference && this.getMemoryBlock() instanceof IExtendedMemoryBlock) {
            ArrayList references = this.removeReferenceFromSynchronizer();
            if (references == null) {
                return;
            }
            if (references.size() == 0 && ((IExtendedMemoryBlock)this.getMemoryBlock()).isEnabled()) {
                ((IExtendedMemoryBlock)this.getMemoryBlock()).disable();
            }
        }
    }

    protected ArrayList addReferenceToSynchronizer() {
        ArrayList<AbstractMemoryViewTab> references = (ArrayList<AbstractMemoryViewTab>)DebugUIPlugin.getDefault().getMemoryBlockViewSynchronizer().getSynchronizedProperty(this.getMemoryBlock(), "org.eclipse.debug.ui.MemoryViewTab.enabledReferences");
        if (references == null) {
            references = new ArrayList<AbstractMemoryViewTab>();
        }
        if (!references.contains(this)) {
            references.add(this);
        }
        DebugUIPlugin.getDefault().getMemoryBlockViewSynchronizer().setSynchronizedProperty(this.getMemoryBlock(), "org.eclipse.debug.ui.MemoryViewTab.enabledReferences", references);
        return references;
    }

    protected ArrayList removeReferenceFromSynchronizer() {
        ArrayList references = (ArrayList)DebugUIPlugin.getDefault().getMemoryBlockViewSynchronizer().getSynchronizedProperty(this.getMemoryBlock(), "org.eclipse.debug.ui.MemoryViewTab.enabledReferences");
        if (references == null) {
            return null;
        }
        if (references.contains(this)) {
            references.remove(this);
        }
        DebugUIPlugin.getDefault().getMemoryBlockViewSynchronizer().setSynchronizedProperty(this.getMemoryBlock(), "org.eclipse.debug.ui.MemoryViewTab.enabledReferences", references);
        return references;
    }

    public void dispose() {
        this.maintainRefAndEnablement(false);
    }

    public IMemoryBlock getMemoryBlock() {
        return this.fMemoryBlock;
    }

    public String getRenderingId() {
        return this.fRendering.getRenderingId();
    }

    public IMemoryRendering getRendering() {
        return this.fRendering;
    }
}

