/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.compare.CompareMessages;
import org.eclipse.jdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;

class JavaNode
extends DocumentRangeNode
implements ITypedElement {
    public static final int CU = 0;
    public static final int PACKAGE = 1;
    public static final int IMPORT_CONTAINER = 2;
    public static final int IMPORT = 3;
    public static final int INTERFACE = 4;
    public static final int CLASS = 5;
    public static final int FIELD = 6;
    public static final int INIT = 7;
    public static final int CONSTRUCTOR = 8;
    public static final int METHOD = 9;
    private int fInitializerCount = 1;
    private boolean fIsEditable;
    private JavaNode fParent;

    public JavaNode(JavaNode parent, int type, String name, int start, int length) {
        super(type, JavaCompareUtilities.buildID(type, name), parent.getDocument(), start, length);
        this.fParent = parent;
        if (parent != null) {
            parent.addChild(this);
            this.fIsEditable = parent.isEditable();
        }
    }

    public JavaNode(IDocument document, boolean editable) {
        super(0, JavaCompareUtilities.buildID(0, "root"), document, 0, document.getLength());
        this.fIsEditable = editable;
    }

    public String getInitializerCount() {
        return Integer.toString(this.fInitializerCount++);
    }

    public String extractMethodName() {
        String id = this.getId();
        int pos = id.indexOf(40);
        if (pos > 0) {
            return id.substring(1, pos);
        }
        return id.substring(1);
    }

    public String extractArgumentList() {
        String id = this.getId();
        int pos = id.indexOf(40);
        if (pos >= 0) {
            return id.substring(pos + 1);
        }
        return id.substring(1);
    }

    public String getName() {
        switch (this.getTypeCode()) {
            case 7: {
                return CompareMessages.getString("JavaNode.initializer");
            }
            case 2: {
                return CompareMessages.getString("JavaNode.importDeclarations");
            }
            case 0: {
                return CompareMessages.getString("JavaNode.compilationUnit");
            }
            case 1: {
                return CompareMessages.getString("JavaNode.packageDeclaration");
            }
        }
        return this.getId().substring(1);
    }

    public String getType() {
        return "java2";
    }

    public boolean isEditable() {
        return this.fIsEditable;
    }

    public Image getImage() {
        ImageDescriptor id = null;
        switch (this.getTypeCode()) {
            case 0: {
                id = JavaCompareUtilities.getImageDescriptor(5);
                break;
            }
            case 1: {
                id = JavaCompareUtilities.getImageDescriptor(11);
                break;
            }
            case 3: {
                id = JavaCompareUtilities.getImageDescriptor(13);
                break;
            }
            case 2: {
                id = JavaCompareUtilities.getImageDescriptor(12);
                break;
            }
            case 5: {
                id = JavaCompareUtilities.getTypeImageDescriptor(true);
                break;
            }
            case 4: {
                id = JavaCompareUtilities.getTypeImageDescriptor(false);
                break;
            }
            case 7: {
                id = JavaCompareUtilities.getImageDescriptor(10);
                break;
            }
            case 8: 
            case 9: {
                id = JavaCompareUtilities.getImageDescriptor(9);
                break;
            }
            case 6: {
                id = JavaCompareUtilities.getImageDescriptor(8);
            }
        }
        return JavaPlugin.getImageDescriptorRegistry().get(id);
    }

    public void setContent(byte[] content) {
        super.setContent(content);
        this.nodeChanged(this);
    }

    public ITypedElement replace(ITypedElement child, ITypedElement other) {
        this.nodeChanged(this);
        return child;
    }

    void nodeChanged(JavaNode node) {
        if (this.fParent != null) {
            this.fParent.nodeChanged(node);
        }
    }
}

