/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaDeleteProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.reorg.CopyToClipboardAction;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgQueries;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.participants.DeleteProcessor;
import org.eclipse.ltk.core.refactoring.participants.DeleteRefactoring;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class CutAction
extends SelectionDispatchAction {
    private CopyToClipboardAction fCopyToClipboardAction;
    static /* synthetic */ Class class$org$eclipse$jdt$internal$corext$refactoring$reorg$JavaDeleteProcessor;

    public CutAction(IWorkbenchSite site, Clipboard clipboard, SelectionDispatchAction pasteAction) {
        super(site);
        this.setText(ReorgMessages.getString("CutAction.text"));
        this.fCopyToClipboardAction = new CopyToClipboardAction(site, clipboard, pasteAction);
        ISharedImages workbenchImages = JavaPlugin.getDefault().getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_CUT"));
        this.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_CUT_HOVER"));
        this.update(this.getSelection());
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.cut_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            if (!CutAction.containsOnlyElementsInsideCompilationUnits(selection) || CutAction.containsTopLevelTypes(selection)) {
                this.setEnabled(false);
                return;
            }
            this.fCopyToClipboardAction.selectionChanged(selection);
            this.setEnabled(this.fCopyToClipboardAction.isEnabled() && this.isDeleteEnabled(selection));
        }
        catch (CoreException e) {
            if (JavaModelUtil.filterNotPresentException(e)) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    private boolean isDeleteEnabled(IStructuredSelection selection) throws CoreException {
        Object[] elements = selection.toArray();
        JavaDeleteProcessor processor = new JavaDeleteProcessor(elements);
        return processor.isApplicable();
    }

    private static boolean containsOnlyElementsInsideCompilationUnits(IStructuredSelection selection) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            if (object instanceof IJavaElement && ReorgUtils.isInsideCompilationUnit((IJavaElement)object)) continue;
            return false;
        }
        return true;
    }

    private static boolean containsTopLevelTypes(IStructuredSelection selection) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            if (!CutAction.isTopLevelType(iter.next())) continue;
            return true;
        }
        return false;
    }

    private static boolean isTopLevelType(Object each) {
        return each instanceof IType && ((IType)each).getDeclaringType() == null;
    }

    public void run(IStructuredSelection selection) {
        try {
            this.selectionChanged(selection);
            if (this.isEnabled()) {
                this.fCopyToClipboardAction.run(selection);
                this.runDelete(selection);
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), RefactoringMessages.getString("OpenRefactoringWizardAction.exception"));
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), RefactoringMessages.getString("OpenRefactoringWizardAction.exception"));
        }
    }

    private void runDelete(IStructuredSelection selection) throws CoreException, InterruptedException, InvocationTargetException {
        Object[] elements = selection.toArray();
        DeleteRefactoring refactoring = this.createRefactoring(elements);
        Assert.isTrue((boolean)refactoring.isApplicable());
        ProgressMonitorDialog context = new ProgressMonitorDialog(this.getShell());
        JavaDeleteProcessor processor = (JavaDeleteProcessor)((Object)refactoring.getAdapter(class$org$eclipse$jdt$internal$corext$refactoring$reorg$JavaDeleteProcessor == null ? (class$org$eclipse$jdt$internal$corext$refactoring$reorg$JavaDeleteProcessor = CutAction.class$("org.eclipse.jdt.internal.corext.refactoring.reorg.JavaDeleteProcessor")) : class$org$eclipse$jdt$internal$corext$refactoring$reorg$JavaDeleteProcessor));
        if (processor != null) {
            processor.setQueries(new ReorgQueries(this.getShell()));
        }
        new RefactoringExecutionHelper((Refactoring)refactoring, RefactoringCore.getConditionCheckingFailedSeverity(), false, this.getShell(), (IRunnableContext)context).perform();
    }

    private DeleteRefactoring createRefactoring(Object[] elements) throws CoreException {
        JavaDeleteProcessor processor = new JavaDeleteProcessor(elements);
        DeleteRefactoring ref = new DeleteRefactoring((DeleteProcessor)processor);
        processor.setSuggestGetterSetterDeletion(false);
        return ref;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

