/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.CorrectionEngine;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaMarkerAnnotation;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposalComparator;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.texteditor.ITextEditor;

public class CorrectionMarkerResolutionGenerator
implements IMarkerResolutionGenerator,
IMarkerResolutionGenerator2 {
    private static final IMarkerResolution[] NO_RESOLUTIONS = new IMarkerResolution[0];

    public boolean hasResolutions(IMarker marker) {
        int id = marker.getAttribute("id", -1);
        ICompilationUnit cu = this.getCompilationUnit(marker);
        return cu != null && JavaCorrectionProcessor.hasCorrections(cu, id);
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        if (!this.hasResolutions(marker)) {
            return NO_RESOLUTIONS;
        }
        try {
            IProblemLocation location;
            IEditorInput input;
            ICompilationUnit cu = this.getCompilationUnit(marker);
            if (cu != null && (input = EditorUtility.getEditorInput(cu)) != null && (location = this.findProblemLocation(input, marker)) != null) {
                AssistContext context = new AssistContext(cu, location.getOffset(), location.getLength());
                ArrayList proposals = new ArrayList();
                JavaCorrectionProcessor.collectCorrections(context, new IProblemLocation[]{location}, proposals);
                Collections.sort(proposals, JavaCompletionProposalComparator.getInstance());
                int nProposals = proposals.size();
                IMarkerResolution[] resolutions = new IMarkerResolution[nProposals];
                for (int i = 0; i < nProposals; ++i) {
                    resolutions[i] = new CorrectionMarkerResolution(context.getCompilationUnit(), location.getOffset(), location.getLength(), (IJavaCompletionProposal)proposals.get(i));
                }
                return resolutions;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return NO_RESOLUTIONS;
    }

    private ICompilationUnit getCompilationUnit(IMarker marker) {
        IJavaElement element;
        IResource res = marker.getResource();
        if (res instanceof IFile && res.isAccessible() && (element = JavaCore.create((IFile)((IFile)res))) instanceof ICompilationUnit) {
            return (ICompilationUnit)element;
        }
        return null;
    }

    private IProblemLocation findProblemLocation(IEditorInput input, IMarker marker) {
        IAnnotationModel model = JavaPlugin.getDefault().getCompilationUnitDocumentProvider().getAnnotationModel(input);
        if (model != null) {
            Iterator iter = model.getAnnotationIterator();
            while (iter.hasNext()) {
                Position pos;
                JavaMarkerAnnotation annot;
                Object curr = iter.next();
                if (!(curr instanceof JavaMarkerAnnotation) || !marker.equals((annot = (JavaMarkerAnnotation)curr).getMarker()) || (pos = model.getPosition((Annotation)annot)) == null) continue;
                return new ProblemLocation(pos.getOffset(), pos.getLength(), annot);
            }
        } else {
            ICompilationUnit cu = this.getCompilationUnit(marker);
            int id = marker.getAttribute("id", -1);
            int start = marker.getAttribute("charStart", -1);
            int end = marker.getAttribute("charEnd", -1);
            int severity = marker.getAttribute("severity", 0);
            String[] arguments = CorrectionEngine.getProblemArguments((IMarker)marker);
            if (cu != null && id != -1 && start != -1 && end != -1 && arguments != null) {
                boolean isError = severity == 2;
                return new ProblemLocation(start, end - start, id, arguments, isError);
            }
        }
        return null;
    }

    public static class CorrectionMarkerResolution
    implements IMarkerResolution,
    IMarkerResolution2 {
        private ICompilationUnit fCompilationUnit;
        private int fOffset;
        private int fLength;
        private IJavaCompletionProposal fProposal;

        public CorrectionMarkerResolution(ICompilationUnit cu, int offset, int length, IJavaCompletionProposal proposal) {
            this.fCompilationUnit = cu;
            this.fOffset = offset;
            this.fLength = length;
            this.fProposal = proposal;
        }

        public String getLabel() {
            return this.fProposal.getDisplayString();
        }

        public void run(IMarker marker) {
            try {
                IEditorPart part = EditorUtility.isOpenInEditor(this.fCompilationUnit);
                if (part == null && (part = EditorUtility.openInEditor(this.fCompilationUnit)) instanceof ITextEditor) {
                    ((ITextEditor)part).selectAndReveal(this.fOffset, this.fLength);
                }
                if (part != null) {
                    IEditorInput input = part.getEditorInput();
                    IDocument doc = JavaPlugin.getDefault().getCompilationUnitDocumentProvider().getDocument(input);
                    this.fProposal.apply(doc);
                }
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }

        public String getDescription() {
            return this.fProposal.getAdditionalProposalInfo();
        }

        public Image getImage() {
            return this.fProposal.getImage();
        }
    }
}

