/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.spelling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.ui.text.javadoc.IHtmlTagConstants;
import org.eclipse.jdt.internal.ui.text.javadoc.IJavaDocTagConstants;
import org.eclipse.jdt.internal.ui.text.spelling.AddWordProposal;
import org.eclipse.jdt.internal.ui.text.spelling.ChangeCaseProposal;
import org.eclipse.jdt.internal.ui.text.spelling.SpellCheckEngine;
import org.eclipse.jdt.internal.ui.text.spelling.WordCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.spelling.WordIgnoreProposal;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellCheckEngine;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.jdt.internal.ui.text.spelling.engine.RankedWordProposal;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;

public class WordQuickFixProcessor
implements IQuickFixProcessor,
IHtmlTagConstants,
IJavaDocTagConstants {
    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        int threshold = PreferenceConstants.getPreferenceStore().getInt("spelling_proposal_threshold");
        int size = 0;
        List proposals = null;
        String[] arguments = null;
        IProblemLocation location = null;
        RankedWordProposal proposal = null;
        IJavaCompletionProposal[] result = null;
        boolean fixed = false;
        boolean match = false;
        boolean sentence = false;
        ISpellCheckEngine engine = SpellCheckEngine.getInstance();
        ISpellChecker checker = engine.createSpellChecker(engine.getLocale(), PreferenceConstants.getPreferenceStore());
        if (checker != null) {
            for (int index = 0; index < locations.length; ++index) {
                location = locations[index];
                if (location.getProblemId() != Integer.MIN_VALUE || (arguments = location.getProblemArguments()) == null || arguments.length <= 4) continue;
                sentence = Boolean.valueOf(arguments[3]);
                match = Boolean.valueOf(arguments[4]);
                boolean bl = fixed = arguments[0].charAt(0) == '<' || arguments[0].charAt(0) == '@';
                if (sentence && match && !fixed) {
                    result = new IJavaCompletionProposal[]{new ChangeCaseProposal(arguments, location.getOffset(), location.getLength(), context, engine.getLocale())};
                    break;
                }
                proposals = new ArrayList(checker.getProposals(arguments[0], sentence));
                size = proposals.size();
                if (threshold > 0 && size > threshold) {
                    Collections.sort(proposals);
                    proposals = proposals.subList(size - threshold - 1, size - 1);
                    size = proposals.size();
                }
                boolean extendable = !fixed ? checker.acceptsWords() : false;
                result = new IJavaCompletionProposal[size + (extendable ? 2 : 1)];
                for (index = 0; index < size; ++index) {
                    proposal = (RankedWordProposal)proposals.get(index);
                    result[index] = new WordCorrectionProposal(proposal.getText(), arguments, location.getOffset(), location.getLength(), context, proposal.getRank());
                }
                if (extendable) {
                    result[index++] = new AddWordProposal(arguments[0], context);
                }
                result[index++] = new WordIgnoreProposal(arguments[0], context);
                break;
            }
        }
        return result;
    }

    public final boolean hasCorrections(ICompilationUnit unit, int id) {
        return id == Integer.MIN_VALUE;
    }
}

