/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.debug.ui.actions.ValidBreakpointLocationLocator;

public class BreakpointMethodLocator
extends ASTVisitor {
    private int fPosition;
    private String fTypeName;
    private String fMethodName;
    private String fMethodSignature;
    private boolean fFound;

    public BreakpointMethodLocator(int position) {
        this.fPosition = position;
        this.fFound = false;
    }

    public String getMethodName() {
        return this.fMethodName;
    }

    public String getMethodSignature() {
        return this.fMethodSignature;
    }

    public String getTypeName() {
        return this.fTypeName;
    }

    private boolean containsPosition(ASTNode node) {
        int startPosition = node.getStartPosition();
        int endPosition = startPosition + node.getLength();
        return startPosition <= this.fPosition && this.fPosition <= endPosition;
    }

    private String computeMethodSignature(MethodDeclaration node) {
        if (node.getExtraDimensions() != 0 || Modifier.isAbstract((int)node.getModifiers())) {
            return null;
        }
        StringBuffer signature = new StringBuffer();
        signature.append('(');
        List parameters = node.parameters();
        Iterator iter = parameters.iterator();
        while (iter.hasNext()) {
            Type type = ((SingleVariableDeclaration)iter.next()).getType();
            if (type instanceof PrimitiveType) {
                this.appendTypeLetter(signature, (PrimitiveType)type);
                continue;
            }
            return null;
        }
        signature.append(')');
        Type returnType = node.getReturnType();
        if (!(returnType instanceof PrimitiveType)) {
            return null;
        }
        this.appendTypeLetter(signature, (PrimitiveType)returnType);
        return signature.toString();
    }

    private void appendTypeLetter(StringBuffer signature, PrimitiveType type) {
        PrimitiveType.Code code = type.getPrimitiveTypeCode();
        if (code == PrimitiveType.BYTE) {
            signature.append('B');
        } else if (code == PrimitiveType.CHAR) {
            signature.append('C');
        } else if (code == PrimitiveType.DOUBLE) {
            signature.append('D');
        } else if (code == PrimitiveType.FLOAT) {
            signature.append('F');
        } else if (code == PrimitiveType.INT) {
            signature.append('I');
        } else if (code == PrimitiveType.LONG) {
            signature.append('J');
        } else if (code == PrimitiveType.SHORT) {
            signature.append('S');
        } else if (code == PrimitiveType.VOID) {
            signature.append('V');
        } else if (code == PrimitiveType.BOOLEAN) {
            signature.append('Z');
        }
    }

    public boolean visit(CompilationUnit node) {
        List types = node.types();
        Iterator iter = types.iterator();
        while (iter.hasNext() && !this.fFound) {
            ((TypeDeclaration)iter.next()).accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(MethodDeclaration node) {
        if (this.containsPosition((ASTNode)node)) {
            this.fMethodName = node.isConstructor() ? "<init>" : node.getName().getIdentifier();
            this.fMethodSignature = this.computeMethodSignature(node);
            this.fTypeName = ValidBreakpointLocationLocator.computeTypeName((ASTNode)node);
            this.fFound = true;
        }
        return false;
    }

    public boolean visit(TypeDeclaration node) {
        if (this.containsPosition((ASTNode)node)) {
            MethodDeclaration[] methods = node.getMethods();
            int length = methods.length;
            for (int i = 0; i < length && !this.fFound; ++i) {
                methods[i].accept((ASTVisitor)this);
            }
            if (!this.fFound) {
                TypeDeclaration[] types = node.getTypes();
                int length2 = types.length;
                for (int i = 0; i < length2 && !this.fFound; ++i) {
                    types[i].accept((ASTVisitor)this);
                }
            }
        }
        return false;
    }
}

