/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.PhrasePositions;
import org.apache.lucene.search.PhraseQueue;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

abstract class PhraseScorer
extends Scorer {
    private Weight weight;
    protected byte[] norms;
    protected float value;
    protected PhraseQueue pq;
    protected PhrasePositions first;
    protected PhrasePositions last;
    private float freq;

    PhraseScorer(Weight weight, TermPositions[] tps, Similarity similarity, byte[] norms) throws IOException {
        super(similarity);
        this.norms = norms;
        this.weight = weight;
        this.value = weight.getValue();
        this.pq = new PhraseQueue(tps.length);
        for (int i = 0; i < tps.length; ++i) {
            this.pq.put(new PhrasePositions(tps[i], i));
        }
        this.pqToList();
    }

    public final void score(HitCollector results, int end) throws IOException {
        Similarity similarity = this.getSimilarity();
        while (this.last.doc < end) {
            while (this.first.doc < this.last.doc) {
                do {
                    this.first.next();
                } while (this.first.doc < this.last.doc);
                this.firstToLast();
                if (this.last.doc < end) continue;
                return;
            }
            this.freq = this.phraseFreq();
            if ((double)this.freq > 0.0) {
                float score = similarity.tf(this.freq) * this.value;
                results.collect(this.first.doc, score *= Similarity.decodeNorm(this.norms[this.first.doc]));
            }
            this.last.next();
        }
    }

    protected abstract float phraseFreq() throws IOException;

    protected final void pqToList() {
        this.first = null;
        this.last = null;
        while (this.pq.top() != null) {
            PhrasePositions pp = (PhrasePositions)this.pq.pop();
            if (this.last != null) {
                this.last.next = pp;
            } else {
                this.first = pp;
            }
            this.last = pp;
            pp.next = null;
        }
    }

    protected final void firstToLast() {
        this.last.next = this.first;
        this.last = this.first;
        this.first = this.first.next;
        this.last.next = null;
    }

    public Explanation explain(int doc) throws IOException {
        Explanation tfExplanation = new Explanation();
        this.score(new HitCollector(){

            public final void collect(int d, float score) {
            }
        }, doc + 1);
        float phraseFreq = this.first.doc == doc ? this.freq : 0.0f;
        tfExplanation.setValue(this.getSimilarity().tf(phraseFreq));
        tfExplanation.setDescription("tf(phraseFreq=" + phraseFreq + ")");
        return tfExplanation;
    }
}

