/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.OperatorExpression;
import org.eclipse.jdt.internal.compiler.ast.OperatorIds;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class CompoundAssignment
extends Assignment
implements OperatorIds {
    public int operator;
    public int assignmentImplicitConversion;

    public CompoundAssignment(Expression lhs, Expression expression, int operator, int sourceEnd) {
        super(lhs, expression, sourceEnd);
        lhs.bits &= 0xFFFFDFFF;
        lhs.bits |= 0x10000;
        this.operator = operator;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return ((Reference)this.lhs).analyseAssignment(currentScope, flowContext, flowInfo, this, true).unconditionalInits();
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        ((Reference)this.lhs).generateCompoundAssignment(currentScope, codeStream, this.expression, this.operator, this.assignmentImplicitConversion, valueRequired);
        if (valueRequired) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public String operatorToString() {
        switch (this.operator) {
            case 14: {
                return "+=";
            }
            case 13: {
                return "-=";
            }
            case 15: {
                return "*=";
            }
            case 9: {
                return "/=";
            }
            case 2: {
                return "&=";
            }
            case 3: {
                return "|=";
            }
            case 8: {
                return "^=";
            }
            case 16: {
                return "%=";
            }
            case 10: {
                return "<<=";
            }
            case 17: {
                return ">>=";
            }
            case 19: {
                return ">>>=";
            }
        }
        return "unknown operator";
    }

    public StringBuffer printExpressionNoParenthesis(int indent, StringBuffer output) {
        this.lhs.printExpression(indent, output).append(' ').append(this.operatorToString()).append(' ');
        return this.expression.printExpression(0, output);
    }

    public TypeBinding resolveType(BlockScope scope) {
        int result;
        this.constant = NotAConstant;
        if (!(this.lhs instanceof Reference) || this.lhs.isThis()) {
            scope.problemReporter().expressionShouldBeAVariable(this.lhs);
            return null;
        }
        TypeBinding lhsType = this.lhs.resolveType(scope);
        TypeBinding expressionType = this.expression.resolveType(scope);
        if (lhsType == null || expressionType == null) {
            return null;
        }
        int lhsId = lhsType.id;
        int expressionId = expressionType.id;
        if (this.restrainUsageToNumericTypes() && !lhsType.isNumericType()) {
            scope.problemReporter().operatorOnlyValidOnNumericType(this, lhsType, expressionType);
            return null;
        }
        if (lhsId > 15 || expressionId > 15) {
            if (lhsId != 11) {
                scope.problemReporter().invalidOperator(this, lhsType, expressionType);
                return null;
            }
            expressionId = 1;
        }
        if ((result = OperatorExpression.OperatorSignatures[this.operator][(lhsId << 4) + expressionId]) == 0) {
            scope.problemReporter().invalidOperator(this, lhsType, expressionType);
            return null;
        }
        if (this.operator == 14) {
            if (lhsId == 1) {
                scope.problemReporter().invalidOperator(this, lhsType, expressionType);
                return null;
            }
            if ((lhsType.isNumericType() || lhsId == 5) && !expressionType.isNumericType()) {
                scope.problemReporter().invalidOperator(this, lhsType, expressionType);
                return null;
            }
        }
        this.lhs.implicitConversion = result >>> 12;
        this.expression.implicitConversion = result >>> 4 & 0xFF;
        this.assignmentImplicitConversion = (lhsId << 4) + (result & 0xF);
        this.resolvedType = lhsType;
        return this.resolvedType;
    }

    public boolean restrainUsageToNumericTypes() {
        return false;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.lhs.traverse(visitor, scope);
            this.expression.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

