/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands.ws;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.ExternalActionManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.commands.CommandEvent;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.commands.ICommandListener;
import org.eclipse.ui.commands.ICommandManager;
import org.eclipse.ui.commands.IKeySequenceBinding;
import org.eclipse.ui.commands.NotDefinedException;
import org.eclipse.ui.keys.KeySequence;
import org.eclipse.ui.keys.KeyStroke;
import org.eclipse.ui.keys.SWTKeySupport;

public final class CommandCallback
implements ExternalActionManager.ICallback {
    private final Map registeredListeners = new HashMap();
    private final IWorkbench workbench;

    public CommandCallback(IWorkbench workbenchToUse) {
        this.workbench = workbenchToUse;
    }

    public void addPropertyChangeListener(String commandId, final IPropertyChangeListener listener) {
        final ICommand command = this.workbench.getCommandSupport().getCommandManager().getCommand(commandId);
        ICommandListener commandListener = new ICommandListener(){

            public void commandChanged(CommandEvent commandEvent) {
                if (commandEvent.hasNameChanged() || commandEvent.haveKeySequenceBindingsChanged()) {
                    PropertyChangeEvent event;
                    try {
                        event = new PropertyChangeEvent((Object)command, "text", null, (Object)command.getName());
                    }
                    catch (NotDefinedException e) {
                        event = new PropertyChangeEvent((Object)command, "text", null, null);
                    }
                    listener.propertyChange(event);
                }
            }
        };
        command.addCommandListener(commandListener);
        this.registeredListeners.put(listener, commandListener);
    }

    public final Integer getAccelerator(String commandId) {
        ICommand command = this.workbench.getCommandSupport().getCommandManager().getCommand(commandId);
        Integer accelerator = null;
        if (command.isDefined()) {
            List keySequenceBindings = command.getKeySequenceBindings();
            int size = keySequenceBindings.size();
            for (int i = 0; i < size; ++i) {
                IKeySequenceBinding keySequenceBinding = (IKeySequenceBinding)keySequenceBindings.get(i);
                List keyStrokes = keySequenceBinding.getKeySequence().getKeyStrokes();
                if (keyStrokes.size() != 1) continue;
                KeyStroke keyStroke = (KeyStroke)keyStrokes.get(0);
                accelerator = new Integer(SWTKeySupport.convertKeyStrokeToAccelerator(keyStroke));
                break;
            }
        }
        return accelerator;
    }

    public final String getAcceleratorText(String commandId) {
        List keySequenceBindings;
        ICommand command = this.workbench.getCommandSupport().getCommandManager().getCommand(commandId);
        String acceleratorText = null;
        if (command.isDefined() && !(keySequenceBindings = command.getKeySequenceBindings()).isEmpty()) {
            IKeySequenceBinding keySequenceBinding = (IKeySequenceBinding)keySequenceBindings.get(0);
            acceleratorText = keySequenceBinding.getKeySequence().format();
        }
        return acceleratorText;
    }

    public boolean isAcceleratorInUse(int accelerator) {
        KeySequence keySequence = KeySequence.getInstance(SWTKeySupport.convertAcceleratorToKeyStroke(accelerator));
        ICommandManager commandManager = this.workbench.getCommandSupport().getCommandManager();
        return commandManager.isPerfectMatch(keySequence) || commandManager.isPartialMatch(keySequence);
    }

    public final boolean isActive(String commandId) {
        ICommand command;
        if (commandId != null && (command = this.workbench.getCommandSupport().getCommandManager().getCommand(commandId)) != null) {
            return command.isDefined() && this.workbench.getActivitySupport().getActivityManager().getIdentifier(command.getId()).isEnabled();
        }
        return true;
    }

    public final void removePropertyChangeListener(String commandId, IPropertyChangeListener listener) {
        ICommand command = this.workbench.getCommandSupport().getCommandManager().getCommand(commandId);
        Object associatedListener = this.registeredListeners.remove(listener);
        if (associatedListener instanceof ICommandListener) {
            ICommandListener commandListener = (ICommandListener)associatedListener;
            command.removeCommandListener(commandListener);
        }
    }
}

