/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.schema.EditableSchema;
import org.eclipse.pde.internal.core.schema.ExternalSchemaDescriptor;
import org.eclipse.pde.internal.core.schema.FileSchemaDescriptor;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.core.schema.StorageSchemaDescriptor;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.pde.internal.ui.editor.context.XMLInputContext;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;

public class SchemaInputContext
extends XMLInputContext {
    public static final String CONTEXT_ID = "schema-context";
    static /* synthetic */ Class class$java$io$File;

    public SchemaInputContext(PDEFormEditor editor, IEditorInput input, boolean primary) {
        super(editor, input, primary);
        this.create();
    }

    public String getId() {
        return CONTEXT_ID;
    }

    protected IBaseModel createModel(IEditorInput input) throws CoreException {
        if (input instanceof SystemFileEditorInput) {
            return this.createExternalModel((SystemFileEditorInput)input);
        }
        if (!(input instanceof IFileEditorInput)) {
            if (input instanceof IStorageEditorInput) {
                return this.createStorageModel((IStorageEditorInput)input);
            }
            return null;
        }
        IFile file = ((IFileEditorInput)input).getFile();
        FileSchemaDescriptor sd = new FileSchemaDescriptor(file);
        ISchema schema = sd.getSchema();
        if (!schema.isValid()) {
            return null;
        }
        if (schema instanceof EditableSchema) {
            ((EditableSchema)schema).setNotificationEnabled(true);
        }
        return schema;
    }

    private IBaseModel createExternalModel(SystemFileEditorInput input) {
        File file = (File)input.getAdapter(class$java$io$File == null ? (class$java$io$File = SchemaInputContext.class$("java.io.File")) : class$java$io$File);
        ExternalSchemaDescriptor sd = new ExternalSchemaDescriptor(file, "", false);
        ISchema schema = sd.getSchema();
        if (!schema.isValid()) {
            return null;
        }
        if (schema instanceof EditableSchema) {
            ((EditableSchema)schema).setNotificationEnabled(true);
        }
        return schema;
    }

    private IBaseModel createStorageModel(IStorageEditorInput input) {
        try {
            IStorage storage = input.getStorage();
            StorageSchemaDescriptor sd = new StorageSchemaDescriptor(storage);
            ISchema schema = sd.getSchema();
            if (!schema.isValid()) {
                return null;
            }
            return schema;
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
            return null;
        }
    }

    protected void addTextEditOperation(ArrayList ops, IModelChangedEvent event) {
    }

    protected void flushModel(IDocument doc) {
        if (!(this.getModel() instanceof IEditable)) {
            return;
        }
        IEditable editableModel = (IEditable)this.getModel();
        if (!editableModel.isDirty()) {
            return;
        }
        try {
            StringWriter swriter = new StringWriter();
            PrintWriter writer = new PrintWriter(swriter);
            editableModel.save(writer);
            writer.flush();
            swriter.close();
            doc.set(swriter.toString());
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
    }

    protected boolean synchronizeModel(IDocument doc) {
        Schema schema = (Schema)this.getModel();
        if (schema == null) {
            return false;
        }
        String text = doc.get();
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(text.getBytes("UTF8"));
            schema.reload((InputStream)stream);
            if (schema instanceof IEditable) {
                ((IEditable)schema).setDirty(false);
            }
            try {
                ((InputStream)stream).close();
            }
            catch (IOException e) {}
        }
        catch (UnsupportedEncodingException e) {
            PDEPlugin.logException(e);
            return false;
        }
        return true;
    }

    protected void reorderInsertEdits(ArrayList ops) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

