/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.templates;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.templates.BaseEditorTemplate;
import org.eclipse.pde.internal.ui.wizards.templates.PluginReference;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.pde.ui.templates.TemplateOption;

public class MultiPageEditorTemplate
extends BaseEditorTemplate {
    private static final String KEY_TITLE = "MultiPageEditorTemplate.title";
    private static final String KEY_DESC = "MultiPageEditorTemplate.desc";
    private static final String KEY_PACKAGE_LABEL = "MultiPageEditorTemplate.packageName";
    private static final String KEY_CLASS_LABEL = "MultiPageEditorTemplate.className";
    private static final String KEY_CONTRIBUTOR_LABEL = "MultiPageEditorTemplate.contributor";
    private static final String KEY_EDITOR_LABEL = "MultiPageEditorTemplate.editorName";
    private static final String KEY_DEFAULT_EDITOR_NAME = "MultiPageEditorTemplate.defaultEditorName";
    private static final String KEY_EXTENSIONS_LABEL = "MultiPageEditorTemplate.extensions";

    public MultiPageEditorTemplate() {
        this.setPageCount(1);
        this.createOptions();
    }

    public String getSectionId() {
        return "multiPageEditor";
    }

    public IPluginReference[] getDependencies(String schemaVersion) {
        if (schemaVersion != null) {
            IPluginReference[] dep = new IPluginReference[]{new PluginReference("org.eclipse.jface.text", null, 0), new PluginReference("org.eclipse.core.resources", null, 0), new PluginReference("org.eclipse.ui", null, 0), new PluginReference("org.eclipse.ui.editors", null, 0), new PluginReference("org.eclipse.ui.ide", null, 0), new PluginReference("org.eclipse.ui.workbench.texteditor", null, 0), new PluginReference("org.eclipse.core.runtime", null, 0)};
            return dep;
        }
        return super.getDependencies(schemaVersion);
    }

    public int getNumberOfWorkUnits() {
        return super.getNumberOfWorkUnits() + 1;
    }

    private void createOptions() {
        this.addOption("packageName", PDEPlugin.getResourceString(KEY_PACKAGE_LABEL), null, 0);
        this.addOption("editorClassName", PDEPlugin.getResourceString(KEY_CLASS_LABEL), "MultiPageEditor", 0);
        this.addOption("contributorClassName", PDEPlugin.getResourceString(KEY_CONTRIBUTOR_LABEL), "MultiPageEditorContributor", 0);
        this.addOption("editorName", PDEPlugin.getResourceString(KEY_EDITOR_LABEL), PDEPlugin.getResourceString(KEY_DEFAULT_EDITOR_NAME), 0);
        this.addOption("extensions", PDEPlugin.getResourceString(KEY_EXTENSIONS_LABEL), "mpe", 0);
    }

    protected void initializeFields(IFieldData data) {
        String id = data.getId();
        this.initializeOption("packageName", id + ".editors");
    }

    public void initializeFields(IPluginModelBase model) {
        String pluginId = model.getPluginBase().getId();
        this.initializeOption("packageName", pluginId + ".editors");
    }

    public boolean isDependentOnParentWizard() {
        return true;
    }

    public void addPages(Wizard wizard) {
        WizardPage page = this.createPage(0, "org.eclipse.pde.doc.user.template_multipage_editor");
        page.setTitle(PDEPlugin.getResourceString(KEY_TITLE));
        page.setDescription(PDEPlugin.getResourceString(KEY_DESC));
        wizard.addPage((IWizardPage)page);
        this.markPagesAdded();
    }

    public void validateOptions(TemplateOption source) {
        if (source.isRequired() && source.isEmpty()) {
            this.flagMissingRequiredOption(source);
        } else {
            this.validateContainerPage(source);
        }
    }

    private void validateContainerPage(TemplateOption source) {
        TemplateOption[] allPageOptions = this.getOptions(0);
        for (int i = 0; i < allPageOptions.length; ++i) {
            TemplateOption nextOption = allPageOptions[i];
            if (!nextOption.isRequired() || !nextOption.isEmpty()) continue;
            this.flagMissingRequiredOption(nextOption);
            return;
        }
        this.resetPageState();
    }

    protected void updateModel(IProgressMonitor monitor) throws CoreException {
        IPluginBase plugin = this.model.getPluginBase();
        IPluginExtension extension = this.createExtension("org.eclipse.ui.editors", true);
        IPluginModelFactory factory = this.model.getPluginFactory();
        String editorClassName = this.getStringOption("packageName") + "." + this.getStringOption("editorClassName");
        String contributorClassName = this.getStringOption("packageName") + "." + this.getStringOption("contributorClassName");
        IPluginElement editorElement = factory.createElement((IPluginObject)extension);
        editorElement.setName("editor");
        editorElement.setAttribute("id", editorClassName);
        editorElement.setAttribute("name", this.getStringOption("editorName"));
        editorElement.setAttribute("icon", "icons/sample.gif");
        editorElement.setAttribute("extensions", this.getStringOption("extensions"));
        editorElement.setAttribute("class", editorClassName);
        editorElement.setAttribute("contributorClass", contributorClassName);
        extension.add((IPluginObject)editorElement);
        if (!extension.isInTheModel()) {
            plugin.add(extension);
        }
    }
}

