/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.internal.browser.BrowserManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.ui.RestartDialog;
import org.eclipse.update.internal.ui.UpdateLabelProvider;
import org.eclipse.update.internal.ui.model.UpdateModel;
import org.eclipse.update.internal.ui.security.UpdateManagerAuthenticator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class UpdateUI
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.update.ui";
    public static final String WEB_APP_ID = "org.eclipse.update";
    private static UpdateUI plugin;
    private ResourceBundle resourceBundle;
    private UpdateModel model;
    private UpdateManagerAuthenticator authenticator;
    private String appServerHost;
    private int appServerPort;
    private UpdateLabelProvider labelProvider;
    private static boolean remindOnCancel;

    public UpdateUI() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.update.internal.ui.UpdateUIPluginResources");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
    }

    public static UpdateUI getDefault() {
        return plugin;
    }

    public static IWorkbenchPage getActivePage() {
        return UpdateUI.getDefault().internalGetActivePage();
    }

    private IWorkbenchPage internalGetActivePage() {
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = UpdateUI.getActiveWorkbenchWindow();
        return window != null ? window.getShell() : null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return UpdateUI.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static String getPluginId() {
        return UpdateUI.getDefault().getBundle().getSymbolicName();
    }

    public UpdateLabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new UpdateLabelProvider();
        }
        return this.labelProvider;
    }

    public static String getString(String key) {
        ResourceBundle bundle = UpdateUI.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public static String getFormattedMessage(String key, String[] args) {
        String text = UpdateUI.getString(key);
        return MessageFormat.format(text, args);
    }

    public static String getFormattedMessage(String key, String arg) {
        String text = UpdateUI.getString(key);
        return MessageFormat.format(text, arg);
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.model = new UpdateModel();
        this.authenticator = new UpdateManagerAuthenticator();
        Authenticator.setDefault(this.authenticator);
        int historyPref = this.getPluginPreferences().getInt("org.eclipse.update.core.historySize");
        if (historyPref > 0) {
            UpdateCore.DEFAULT_HISTORY = historyPref;
        }
    }

    public boolean isWebAppStarted() {
        return this.appServerHost != null;
    }

    public String getAppServerHost() {
        return this.appServerHost;
    }

    public int getAppServerPort() {
        return this.appServerPort;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.model != null) {
            this.model.shutdown();
        }
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        super.stop(context);
    }

    public UpdateModel getUpdateModel() {
        return this.model;
    }

    public static void logException(Throwable e) {
        UpdateUI.logException(e, true);
    }

    public static void logException(Throwable e, boolean showErrorDialog) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, UpdateUI.getPluginId(), 0, message, e);
        }
        UpdateUI.log(status, showErrorDialog);
    }

    public static void log(IStatus status, boolean showErrorDialog) {
        if (status.getSeverity() != 1) {
            if (showErrorDialog) {
                ErrorDialog.openError((Shell)UpdateUI.getActiveWorkbenchShell(), null, null, (IStatus)status);
            }
            Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
            Platform.getLog((Bundle)bundle).log(status);
        } else {
            MessageDialog.openInformation((Shell)UpdateUI.getActiveWorkbenchShell(), null, (String)status.getMessage());
        }
    }

    public static IFeature[] searchSite(String featureId, IConfiguredSite site, boolean onlyConfigured) throws CoreException {
        Object[] references = null;
        references = onlyConfigured ? site.getConfiguredFeatures() : site.getSite().getFeatureReferences();
        Vector<IFeature> result = new Vector<IFeature>();
        for (int i = 0; i < references.length; ++i) {
            IFeature feature = references[i].getFeature(null);
            String id = feature.getVersionedIdentifier().getIdentifier();
            if (!featureId.equals(id)) continue;
            result.add(feature);
        }
        return result.toArray(new IFeature[result.size()]);
    }

    public static IFeature[] getInstalledFeatures(IFeature feature) {
        return UpdateUI.getInstalledFeatures(feature, true);
    }

    public static IFeature[] getInstalledFeatures(IFeature feature, boolean onlyConfigured) {
        Vector<IFeature> features = new Vector<IFeature>();
        try {
            ILocalSite localSite = SiteManager.getLocalSite();
            IInstallConfiguration config = localSite.getCurrentConfiguration();
            IConfiguredSite[] isites = config.getConfiguredSites();
            VersionedIdentifier vid = feature.getVersionedIdentifier();
            String id = vid.getIdentifier();
            for (int i = 0; i < isites.length; ++i) {
                IConfiguredSite isite = isites[i];
                IFeature[] result = UpdateUI.searchSite(id, isite, onlyConfigured);
                for (int j = 0; j < result.length; ++j) {
                    IFeature installedFeature = result[j];
                    features.add(installedFeature);
                }
            }
        }
        catch (CoreException e) {
            UpdateUI.logException(e);
        }
        return features.toArray(new IFeature[features.size()]);
    }

    public UpdateManagerAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public static URL getOriginatingURL(String id) {
        IDialogSettings section = UpdateUI.getOriginatingURLSection();
        String value = section.get(id);
        if (value != null) {
            try {
                return new URL(value);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void setOriginatingURL(String id, URL url) {
        IDialogSettings section = UpdateUI.getOriginatingURLSection();
        section.put(id, url.toString());
    }

    private static IDialogSettings getOriginatingURLSection() {
        IDialogSettings settings = UpdateUI.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection("originatingURLs");
        if (section == null) {
            section = settings.addNewSection("originatingURLs");
        }
        return section;
    }

    public static void requestRestart(boolean restartIsReallyNeeded) {
        boolean restart = RestartDialog.openQuestion(UpdateUI.getActiveWorkbenchShell(), restartIsReallyNeeded);
        if (restart) {
            PlatformUI.getWorkbench().restart();
        }
    }

    public static void showURL(String url) {
        UpdateUI.showURL(url, false);
    }

    public static void showURL(String url, boolean encodeHostAndPort) {
        if (encodeHostAndPort) {
            url = UpdateUI.encodeHostAndPort(url);
        }
        if (SWT.getPlatform().equals("win32")) {
            Program.launch((String)url);
        } else {
            IBrowser browser = BrowserManager.getInstance().createBrowser();
            try {
                browser.displayURL(url);
            }
            catch (Exception e) {
                UpdateUI.logException(e);
            }
        }
    }

    private static String encodeHostAndPort(String urlName) {
        String callbackURL = UpdateUI.getCallbackURLAsString();
        if (callbackURL == null) {
            return urlName;
        }
        String callbackParameter = "updateURL=" + callbackURL;
        if (urlName.indexOf(63) != -1) {
            return urlName + "&" + callbackParameter;
        }
        return urlName + "?" + callbackParameter;
    }

    private static String getCallbackURLAsString() {
        String host = UpdateUI.getDefault().getAppServerHost();
        int port = UpdateUI.getDefault().getAppServerPort();
        if (host == null || port == 0) {
            return null;
        }
        String value = "http://" + host + ":" + port + "/" + WEB_APP_ID + "/install";
        try {
            value = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return value;
    }

    public static boolean getRemindOnCancel() {
        return remindOnCancel;
    }

    public static void setRemindOnCancel(boolean remind) {
        remindOnCancel = remind;
    }

    static {
        remindOnCancel = true;
    }
}

