/*
 * Decompiled with CFR 0.152.
 */
package auto;

import auto.AllGames;
import auto.Distiller;
import auto.conversion;
import auto.moul;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import prpobjects.PrpRootObject;
import prpobjects.Typeid;
import prpobjects.plSoundBuffer;
import prpobjects.prpfile;
import prpobjects.sumfile;
import prpobjects.textfile;
import shared.FileUtils;
import shared.m;
import uam.Uam;
import uru.UruCrypt;
import uru.UruFileTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Max {
    static final boolean deleteTextureFileAfterConvert = true;

    public static void convert3dsmaxToPots(String maxfolder, String potsfolder, String agenames, boolean partialAge) {
        File datfolder = new File(maxfolder + "/dat/");
        ArrayList<String> agenamelist = new ArrayList<String>();
        boolean isempty = true;
        for (String item : agenames.split(",")) {
            String agename = item.trim();
            if (agename.equals("")) continue;
            isempty = false;
            boolean found = false;
            for (File f : datfolder.listFiles()) {
                if (!f.isFile() || !f.getName().toLowerCase().equals(agename.toLowerCase() + ".age")) continue;
                String realagename = f.getName().replace(".age", "");
                agenamelist.add(realagename);
                found = true;
                break;
            }
            if (found) continue;
            m.warn("Unable to find Age: ", agename);
        }
        if (isempty) {
            m.msg("No Ages specified; converting all Ages in 3dsmax's export folder...");
            Max.convert3dsmaxToPots(maxfolder, potsfolder, partialAge);
            return;
        }
        Max.convert3dsmaxToPots(maxfolder, potsfolder, agenamelist, partialAge);
    }

    public static void convert3dsmaxToPots(String maxfolder, String potsfolder, ArrayList<String> ages, boolean partialAge) {
        File datfolder = new File(maxfolder + "/dat/");
        if (ages.size() == 0) {
            m.warn("None of the Ages were found in the 3dsmax export folder.");
            return;
        }
        for (String agename : ages) {
            textfile fnifilet;
            if (!partialAge && (agename.toLowerCase().equals("personal") || agename.toLowerCase().equals("pahts"))) {
                m.err("Woah there!  You probably meant to have the 'Partial Age' option set when making a Relto page or AhraPahts shell.");
                return;
            }
            m.status("Converting Age: ", agename);
            m.increaseindentation();
            String agefilename = maxfolder + "/dat/" + agename + ".age";
            byte[] agefilebs_enc = FileUtils.ReadFile(agefilename);
            UruFileTypes type = UruCrypt.DetectType(agefilebs_enc, AllGames.getPots().g);
            if (type != UruFileTypes.unencrypted) {
                m.warn(agefilename, " should be plain text, *not* encrypted.  Create it with a regular text editor.");
            }
            byte[] agefilebs = UruCrypt.DecryptAny(agefilebs_enc, type);
            textfile agefile = textfile.createFromBytes(agefilebs);
            String prefixstr = agefile.getVariable("SequencePrefix");
            int prefix = Integer.parseInt(prefixstr);
            byte[] agefileoutbs = agefile.saveToByteArray();
            agefileoutbs = UruCrypt.EncryptWhatdoyousee(agefileoutbs);
            String agefileout = potsfolder + "/dat/" + agename + ".age";
            if (!partialAge) {
                FileUtils.WriteFile(agefileout, agefileoutbs, true, true);
            }
            String sumfileout = potsfolder + "/dat/" + agename + ".sum";
            FileUtils.WriteFile(sumfileout, sumfile.createEmptySumfile().getByteArray(), true, true);
            String fnifilename = maxfolder + "/dat/" + agename + ".fni";
            File fnifile = new File(fnifilename);
            if (fnifile.exists()) {
                byte[] fnifilebs = UruCrypt.DecryptAny(fnifilename, AllGames.getPots().g);
                fnifilet = textfile.createFromBytes(fnifilebs);
            } else {
                fnifilet = new textfile();
                fnifilet.appendLine("Graphics.Renderer.SetYon 100000");
                fnifilet.appendLine("Graphics.Renderer.Fog.SetDefLinear 0 0 0");
                fnifilet.appendLine("Graphics.Renderer.Fog.SetDefColor 0 0 0");
                fnifilet.appendLine("Graphics.Renderer.SetClearColor 0 0 0");
            }
            byte[] fnifileoutbs = UruCrypt.EncryptWhatdoyousee(fnifilet.saveToByteArray());
            String fnifileout = potsfolder + "/dat/" + agename + ".fni";
            if (!partialAge) {
                FileUtils.WriteFile(fnifileout, fnifileoutbs, true, true);
            }
            ArrayList<String> prpfiles = new ArrayList<String>();
            for (File f : datfolder.listFiles()) {
                if (!f.isFile() || !f.getName().startsWith(agename + "_District_") || !f.getName().endsWith(".prp")) continue;
                prpfiles.add(f.getName());
            }
            final MaxInfo maxinfo = new MaxInfo();
            String texturesPrp = null;
            for (String prp : prpfiles) {
                if (!prp.endsWith("_District_Textures.prp")) continue;
                texturesPrp = prp;
                break;
            }
            if (partialAge && texturesPrp == null) {
                m.warn("Conversion is set to 'Partial Age', but no Textures prp was found.  If your Age has no textures then this is normal, otherwise you should re-export with 3dsmax.");
            }
            for (String prp : prpfiles) {
                if (partialAge && (prp.toLowerCase().endsWith("_district_builtin.prp") || prp.toLowerCase().endsWith("_district_textures.prp"))) {
                    m.status("Skipping Prp: ", prp);
                    continue;
                }
                m.status("Converting Prp: ", prp);
                m.increaseindentation();
                Vector<String> files = new Vector<String>();
                files.add(prp);
                AllGames.GameInfo moulinfo = moul.getGameInfo();
                moulinfo.renameinfo.prefices.put(agename, prefix);
                final conversion.PostConversionModifier pcm = moulinfo.prpmodifier;
                moulinfo.prpmodifier = new conversion.PostConversionModifier(){

                    public void ModifyPrp(conversion.Info info, conversion.FileInfo file, prpfile prp) {
                        pcm.ModifyPrp(info, file, prp);
                        maxinfo.numSpawnPoints += prp.FindAllObjectsOfType(Typeid.plSpawnModifier).length;
                        maxinfo.numLights += prp.FindAllObjectsOfType(Typeid.plDirectionalLightInfo).length;
                        maxinfo.numLights += prp.FindAllObjectsOfType(Typeid.plOmniLightInfo).length;
                        maxinfo.numLights += prp.FindAllObjectsOfType(Typeid.plLimitedDirLightInfo).length;
                        maxinfo.numLights += prp.FindAllObjectsOfType(Typeid.plSpotLightInfo).length;
                        maxinfo.numPhysics += prp.FindAllObjectsOfType(Typeid.plSimulationInterface).length;
                        Max.FixStreamingSounds(prp);
                    }
                };
                moulinfo.renameinfo.agenames.remove("Personal");
                AllGames.GameConversionSub maxconv = new AllGames.GameConversionSub(moulinfo);
                maxconv.ConvertFiles(maxfolder, potsfolder, files);
                if (partialAge && texturesPrp != null) {
                    String infile = potsfolder + "/dat/" + prp;
                    String textfile2 = maxfolder + "/dat/" + texturesPrp;
                    String outfolder = potsfolder + "/dat/";
                    Distiller.DistillTextures(infile, textfile2, outfolder);
                }
                m.decreaseindentation();
            }
            if (texturesPrp != null) {
                String filetodelete = maxfolder + "/dat/" + texturesPrp;
                FileUtils.DeleteFile(filetodelete, false);
            }
            if (!partialAge && maxinfo.numSpawnPoints == 0) {
                m.warn("Your Age doesn't have a spawnpoint; you won't be able to link into it correctly.");
            }
            if (maxinfo.numLights == 0) {
                m.warn("Your Age doesn't have any lights; everything may appear black.");
            }
            if (!partialAge && maxinfo.numPhysics == 0) {
                m.warn("Your Age doesn't have any colliders; you will fall right through the ground.");
            }
            m.decreaseindentation();
            m.status("Done converting Age!: ", agename);
        }
    }

    public static void FixStreamingSounds(prpfile prp) {
        for (PrpRootObject ro : prp.FindAllObjectsOfType(Typeid.plSoundBuffer)) {
            plSoundBuffer sb = (plSoundBuffer)ro.castTo();
            sb.flags |= 0x10;
        }
    }

    private static boolean ensureFolders(String maxfolder, String potsfolder) {
        if (!AllGames.getPots().isFolderX(potsfolder)) {
            return false;
        }
        File datfolder = new File(maxfolder + "/dat/");
        if (!datfolder.exists() || !datfolder.isDirectory()) {
            m.err("The 3dsmax folder must be set to the folder that the 3dsmax plugin exports to, and so should contain a 'dat' folder.");
            return false;
        }
        File test2 = new File(maxfolder + "/UruExplorer.exe");
        if (test2.exists()) {
            m.err("The 3dsmax export folder should not be Uru's folder.  Create a folder just for 3dsmax to export to.");
            return false;
        }
        return true;
    }

    public static void convert3dsmaxToPots(String maxfolder, String potsfolder, boolean partialAge) {
        if (!Max.ensureFolders(maxfolder, potsfolder)) {
            return;
        }
        if (!Uam.HasPermissions(potsfolder)) {
            return;
        }
        File datfolder = new File(maxfolder + "/dat/");
        ArrayList<String> ages = new ArrayList<String>();
        for (File f : datfolder.listFiles()) {
            if (!f.isFile() || !f.getName().endsWith(".age")) continue;
            String agename = f.getName().replace(".age", "");
            ages.add(agename);
        }
        Max.convert3dsmaxToPots(maxfolder, potsfolder, ages, partialAge);
    }

    private static class MaxInfo {
        int numSpawnPoints = 0;
        int numLights = 0;
        int numPhysics = 0;

        private MaxInfo() {
        }
    }
}

