/*
 * Decompiled with CFR 0.152.
 */
package moulserver;

import java.io.InputStream;
import java.util.HashMap;
import shared.m;
import shared.nested;
import shared.uncaughtexception;

public class ChunkSendHandler {
    public static final int maxbufsize = 100000;
    public HashMap<Integer, ChunkFile> files = new HashMap();

    public ChunkFile startfile(String filename, int filesize, int transId, InputStream is, boolean encrypt) {
        ChunkFile file = this.files.get(transId);
        if (file == null) {
            file = new ChunkFile(filename, filesize, is, encrypt);
            this.files.put(transId, file);
            return file;
        }
        throw new uncaughtexception("File already started?");
    }

    public ChunkFile ack(int transId) {
        return this.files.get(transId);
    }

    public ChunkFile clearfile(int transId) {
        ChunkFile file = this.files.get(transId);
        this.files.remove(transId);
        return file;
    }

    public static class ChunkFile {
        String filename;
        boolean done;
        InputStream is;
        int offset;
        int filesize;
        boolean encrypt;

        public ChunkFile(String filename2, int filesize2, InputStream is2, boolean encrypted) {
            this.filename = filename2;
            this.filesize = filesize2;
            this.is = is2;
            this.done = false;
            this.offset = 0;
            this.encrypt = encrypted;
        }

        public void addChunk(int offset, byte[] chunk) {
        }

        public int offset() {
            return this.offset;
        }

        public byte[] read() {
            try {
                int numread;
                int remaining = this.filesize - this.offset;
                int bufsize = remaining < 100000 ? remaining : 100000;
                byte[] r = new byte[bufsize];
                for (int read = 0; read != bufsize; read += numread) {
                    numread = this.is.read(r, read, bufsize - read);
                    if (numread != -1) continue;
                    m.throwUncaughtException("unexpected");
                }
                this.offset += bufsize;
                if (this.offset == this.filesize) {
                    this.done = true;
                }
                if (this.encrypt) {
                    // empty if block
                }
                return r;
            }
            catch (Exception e2) {
                throw new nested(e2);
            }
        }
    }
}

