/*
 * Decompiled with CFR 0.152.
 */
package prpobjects;

import java.io.File;
import java.util.Vector;
import prpobjects.Urustring;
import prpobjects.uruobj;
import shared.Bytes;
import shared.CryptHashes;
import shared.FileUtils;
import shared.Format;
import shared.b;
import shared.m;
import shared.readexception;
import uru.Bytedeque;
import uru.Bytestream;
import uru.UruCrypt;
import uru.context;

public class sumfile {
    public int filecount;
    int u1;
    public sumfileFileinfo[] files;

    public static sumfile readFromFile(File f, int readversion) {
        sumfile result = null;
        try {
            result = new sumfile(FileUtils.ReadFile(f), true, readversion);
        }
        catch (readexception e2) {
            m.err("Error reading sumfile:", f.getName());
        }
        return result;
    }

    public sumfile(byte[] filedata, boolean isencrypted, int readversion) throws readexception {
        if (isencrypted) {
            filedata = UruCrypt.DecryptWhatdoyousee(filedata);
        }
        context c = new context(new Bytestream(filedata));
        c.readversion = readversion;
        this.filecount = c.readInt();
        this.u1 = c.readInt();
        this.files = (sumfileFileinfo[])c.readArray(sumfileFileinfo.class, this.filecount);
    }

    public static void regenerateSumfile(String potsfolder, String agename) {
        Bytes bytes = sumfile.createSumfile(potsfolder + "/dat/", agename);
        String outfile = potsfolder + "/dat/" + agename + ".sum";
        FileUtils.WriteFile(outfile, bytes);
    }

    public static Bytes createEmptySumfile() {
        int count = 0;
        Bytedeque c = new Bytedeque(Format.none);
        c.writeInt(count);
        c.writeInt(0);
        byte[] result = c.getAllBytes();
        result = UruCrypt.EncryptWhatdoyousee(result);
        return new Bytes(result);
    }

    public static Bytes createSumfile(String infolder, String agename) {
        File datdir = new File(infolder);
        if (!datdir.exists() || !datdir.isDirectory()) {
            m.err("Dat folder not found.");
            return null;
        }
        Vector<String> files = new Vector<String>();
        File[] datfiles = datdir.listFiles();
        for (int i = 0; i < datfiles.length; ++i) {
            String curfilename = datfiles[i].getName();
            if (!curfilename.startsWith(agename + "_") || !curfilename.endsWith(".prp")) continue;
            files.add(curfilename);
        }
        int count = files.size();
        Bytedeque c = new Bytedeque(Format.none);
        c.writeInt(count);
        c.writeInt(0);
        for (int i = 0; i < datfiles.length; ++i) {
            String curfilename = datfiles[i].getName();
            if (!curfilename.startsWith(agename + "_") || !curfilename.endsWith(".prp")) continue;
            byte[] path = new byte[]{100, 97, 116, 92};
            byte[] filenameBytes = b.appendBytes(path, b.StringToBytes(curfilename));
            Urustring filename = new Urustring(filenameBytes);
            filename.compile(c);
            byte[] filecontents = FileUtils.ReadFile(datfiles[i]);
            byte[] md5 = CryptHashes.GetMd5(filecontents);
            c.writeBytes(md5);
            c.writeInt(0);
            c.writeInt(0);
        }
        byte[] result = c.getAllBytes();
        result = UruCrypt.EncryptWhatdoyousee(result);
        return new Bytes(result);
    }

    public static class sumfileFileinfo
    extends uruobj {
        public Urustring filename;
        public byte[] md5;
        public int timestamp;
        int u2;

        public sumfileFileinfo(context c) {
            this.filename = new Urustring(c);
            this.md5 = c.readBytes(16);
            this.timestamp = c.readInt();
            this.u2 = c.readInt();
        }
    }
}

