/*
 * Decompiled with CFR 0.152.
 */
package shared.State;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import java.util.Vector;
import shared.State.IState;
import shared.delegate;
import shared.m;

public class AllStates {
    static HashMap<String, Object> states = new HashMap();
    static Vector<IState> refs = new Vector();
    static Stack<HashMap<String, Object>> stackedStates = new Stack();
    static Vector<delegate> afterInitCallbacks = new Vector();

    public static void push() {
        HashMap oldstates = (HashMap)states.clone();
        stackedStates.push(oldstates);
    }

    public static void pop() {
        HashMap<String, Object> oldstates = stackedStates.pop();
        states = oldstates;
    }

    public static void addCallbackAfterInit(delegate d) {
        afterInitCallbacks.add(d);
    }

    public static void register(IState ref) {
        refs.add(ref);
    }

    public static void setState(String name, Object value) {
        states.put(name, value);
    }

    public static Object getState(String name) {
        return states.get(name);
    }

    public static boolean getStateAsBoolean(String name) {
        Object obj = AllStates.getState(name);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    public static String getStateAsString(String name) {
        Object obj = AllStates.getState(name);
        if (obj instanceof String) {
            return (String)obj;
        }
        return "";
    }

    public static int getStateAsInt(String name) {
        Object obj = AllStates.getState(name);
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return 0;
    }

    public static boolean pullandsave(String filename) {
        AllStates.pullInStates();
        return AllStates.save(filename);
    }

    public static boolean loadandpush(String filename) {
        boolean result = AllStates.load(filename);
        for (IState state : refs) {
            state.initialise();
        }
        if (result) {
            AllStates.pushOutStates();
        }
        return result;
    }

    public static void loadandpush2() {
        for (delegate d : afterInitCallbacks) {
            d.callback(null);
        }
    }

    public static boolean save(String filename) {
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new FileOutputStream(filename));
            out.writeObject(states);
            out.close();
        }
        catch (Exception e2) {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public static boolean load(String filename) {
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new FileInputStream(filename));
            HashMap newStates = (HashMap)in.readObject();
            in.close();
            states = newStates;
        }
        catch (Exception e2) {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e22) {
                // empty catch block
            }
            File f = new File(filename);
            if (f.exists()) {
                m.warn("Unable to load state. Deleting old settings file...");
                AllStates.resetSettings(filename);
            } else {
                m.msg("Settings file doesn't exist yet; creating it.");
                AllStates.pullInStates();
            }
            return false;
        }
        return true;
    }

    public static void pullInStates() {
        for (IState state : refs) {
            String name = state.getStateName();
            Object val = state.getStateValue();
            states.put(name, val);
        }
    }

    private static void pushOutStates() {
        HashSet<String> names = new HashSet<String>();
        for (IState state : refs) {
            String name = state.getStateName();
            if (name == null || name.equals("") || names.contains(name)) {
                m.err("Programming Error: some state widgets have the same/no name.");
                continue;
            }
            names.add(name);
            Object value = states.get(name);
            if (value != null) {
                state.putStateValue(value);
                continue;
            }
            state.putStateValue(state.getDefault());
        }
    }

    public static void revertToDefaults() {
        for (IState state : refs) {
            state.putStateValue(state.getDefault());
        }
    }

    public static void resetSettings(String filename) {
        File f = new File(filename);
        if (f.exists()) {
            boolean success = f.delete();
            if (success) {
                m.msg("Deleted settings file.");
            } else {
                m.msg("Unable to delete settings file.");
            }
        } else {
            m.msg("Settings file doesn't exist.");
        }
    }

    public static void test() {
        AllStates.save("c:\\state2.dat");
    }

    public static void test2() {
        AllStates.load("c:\\state2.dat");
    }

    public static void update(IState state) {
        AllStates.setState(state.getStateName(), state.getStateValue());
    }
}

