/*
 * Decompiled with CFR 0.152.
 */
package deepview2;

import deepview2.dvAges;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import shared.GuiUtils;
import shared.State.AllStates;
import shared.m;
import shared.translation;

public class dvGUI
extends JFrame {
    dvAges ages;
    JTree tree;
    JDesktopPane desktop;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JDesktopPane jDesktopPane1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JToolBar jToolBar1;
    private JTree jTree1;

    public dvGUI() {
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.tree = this.jTree1;
        this.desktop = this.jDesktopPane1;
        this.ages = new dvAges(this);
        this.jSplitPane1.setDividerLocation(300);
        this.setSize(1024, 768);
        this.setTitle(translation.translate("Drizzle Deepview"));
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jScrollPane2 = new JScrollPane();
        this.jDesktopPane1 = new JDesktopPane();
        this.setDefaultCloseOperation(3);
        this.jToolBar1.setRollover(true);
        this.jButton1.setText("Open...");
        this.jButton1.setFocusable(false);
        this.jButton1.setHorizontalTextPosition(0);
        this.jButton1.setVerticalTextPosition(3);
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                dvGUI.this.jButton1ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton1);
        this.jButton2.setText("Save All...");
        this.jButton2.setFocusable(false);
        this.jButton2.setHorizontalTextPosition(0);
        this.jButton2.setVerticalTextPosition(3);
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                dvGUI.this.jButton2ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton2);
        this.jButton3.setText("Reload...");
        this.jButton3.setFocusable(false);
        this.jButton3.setHorizontalTextPosition(0);
        this.jButton3.setVerticalTextPosition(3);
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                dvGUI.this.jButton3ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton3);
        this.jScrollPane1.setViewportView(this.jTree1);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.jScrollPane2.setViewportView(this.jDesktopPane1);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -1, 887, Short.MAX_VALUE).addComponent(this.jSplitPane1, -1, 887, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 501, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        String key = "dvLastFile";
        String lastfile = AllStates.getStateAsString(key);
        String newfile = GuiUtils.getUserSelectedFile(lastfile);
        if (newfile != null) {
            AllStates.setState(key, newfile);
            this.ages.loadPrp(newfile);
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        try {
            this.ages.onSave();
        }
        catch (Exception e2) {
            m.err("Unable to save due to error.");
            e2.printStackTrace();
            GuiUtils.DisplayMessage("Save Error", "Unable to save all prps.");
        }
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.clearWindows();
        this.refreshTree();
    }

    void clearWindows() {
        for (JInternalFrame frame : this.desktop.getAllFrames()) {
            frame.doDefaultCloseAction();
        }
    }

    void refreshTree() {
        this.ages.refreshTree();
    }

    public static void open() {
        dvGUI.open(null);
    }

    public static void open(final String filename) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                dvGUI dvgui = new dvGUI();
                dvgui.setVisible(true);
                if (filename != null && !filename.equals("")) {
                    dvgui.ages.loadPrp(filename);
                }
            }
        });
    }
}

