/*
 * Decompiled with CFR 0.152.
 */
package ie.wombat.jbdiff;

import ie.wombat.jbdiff.Util;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.GZIPOutputStream;

public class JBDiff {
    private static final String VERSION = "jbdiff-0.1.1";

    private static final int min(int x, int y) {
        return x < y ? x : y;
    }

    private static final void split(int[] I, int[] V, int start, int len, int h) {
        int tmp;
        int i;
        if (len < 16) {
            int j;
            for (int k = start; k < start + len; k += j) {
                j = 1;
                int x = V[I[k] + h];
                int i2 = 1;
                while (k + i2 < start + len) {
                    if (V[I[k + i2] + h] < x) {
                        x = V[I[k + i2] + h];
                        j = 0;
                    }
                    if (V[I[k + i2] + h] == x) {
                        int tmp2 = I[k + j];
                        I[k + j] = I[k + i2];
                        I[k + i2] = tmp2;
                        ++j;
                    }
                    ++i2;
                }
                for (i2 = 0; i2 < j; ++i2) {
                    V[I[k + i2]] = k + j - 1;
                }
                if (j != 1) continue;
                I[k] = -1;
            }
            return;
        }
        int x = V[I[start + len / 2] + h];
        int jj = 0;
        int kk = 0;
        for (i = start; i < start + len; ++i) {
            if (V[I[i] + h] < x) {
                ++jj;
            }
            if (V[I[i] + h] != x) continue;
            ++kk;
        }
        kk += (jj += start);
        i = start;
        int j = 0;
        int k = 0;
        while (i < jj) {
            if (V[I[i] + h] < x) {
                ++i;
                continue;
            }
            if (V[I[i] + h] == x) {
                tmp = I[i];
                I[i] = I[jj + j];
                I[jj + j] = tmp;
                ++j;
                continue;
            }
            tmp = I[i];
            I[i] = I[kk + k];
            I[kk + k] = tmp;
            ++k;
        }
        while (jj + j < kk) {
            if (V[I[jj + j] + h] == x) {
                ++j;
                continue;
            }
            tmp = I[jj + j];
            I[jj + j] = I[kk + k];
            I[kk + k] = tmp;
            ++k;
        }
        if (jj > start) {
            JBDiff.split(I, V, start, jj - start, h);
        }
        for (i = 0; i < kk - jj; ++i) {
            V[I[jj + i]] = kk - 1;
        }
        if (jj == kk - 1) {
            I[jj] = -1;
        }
        if (start + len > kk) {
            JBDiff.split(I, V, kk, start + len - kk, h);
        }
    }

    private static void qsufsort(int[] I, int[] V, byte[] oldBuf) {
        int i;
        int oldsize = oldBuf.length;
        int[] buckets = new int[256];
        for (i = 0; i < 256; ++i) {
            buckets[i] = 0;
        }
        for (i = 0; i < oldsize; ++i) {
            int n = oldBuf[i] & 0xFF;
            buckets[n] = buckets[n] + 1;
        }
        for (i = 1; i < 256; ++i) {
            int n = i;
            buckets[n] = buckets[n] + buckets[i - 1];
        }
        for (i = 255; i > 0; --i) {
            buckets[i] = buckets[i - 1];
        }
        buckets[0] = 0;
        i = 0;
        while (i < oldsize) {
            int n = oldBuf[i] & 0xFF;
            int n2 = buckets[n] + 1;
            buckets[n] = n2;
            I[n2] = i++;
        }
        I[0] = oldsize;
        for (i = 0; i < oldsize; ++i) {
            V[i] = buckets[oldBuf[i] & 0xFF];
        }
        V[oldsize] = 0;
        for (i = 1; i < 256; ++i) {
            if (buckets[i] != buckets[i - 1] + 1) continue;
            I[buckets[i]] = -1;
        }
        I[0] = -1;
        int h = 1;
        while (I[0] != -(oldsize + 1)) {
            int len = 0;
            i = 0;
            while (i < oldsize + 1) {
                if (I[i] < 0) {
                    len -= I[i];
                    i -= I[i];
                    continue;
                }
                if (len != 0) {
                    I[i - len] = -len;
                }
                len = V[I[i]] + 1 - i;
                JBDiff.split(I, V, i, len, h);
                i += len;
                len = 0;
            }
            if (len != 0) {
                I[i - len] = -len;
            }
            h += h;
        }
        for (i = 0; i < oldsize + 1; ++i) {
            I[V[i]] = i;
        }
    }

    private static final int matchlen(byte[] oldBuf, int oldOffset, byte[] newBuf, int newOffset) {
        int i;
        int end = JBDiff.min(oldBuf.length - oldOffset, newBuf.length - newOffset);
        for (i = 0; i < end && oldBuf[oldOffset + i] == newBuf[newOffset + i]; ++i) {
        }
        return i;
    }

    private static final int search(int[] I, byte[] oldBuf, byte[] newBuf, int newBufOffset, int start, int end, IntByRef pos) {
        if (end - start < 2) {
            int y;
            int x = JBDiff.matchlen(oldBuf, I[start], newBuf, newBufOffset);
            if (x > (y = JBDiff.matchlen(oldBuf, I[end], newBuf, newBufOffset))) {
                pos.value = I[start];
                return x;
            }
            pos.value = I[end];
            return y;
        }
        int x = start + (end - start) / 2;
        if (Util.memcmp(oldBuf, I[x], newBuf, newBufOffset) < 0) {
            return JBDiff.search(I, oldBuf, newBuf, newBufOffset, x, end, pos);
        }
        return JBDiff.search(I, oldBuf, newBuf, newBufOffset, start, x, pos);
    }

    public static void bsdiff(File oldFile, File newFile, File diffFile) throws IOException {
        int oldsize = (int)oldFile.length();
        byte[] oldBuf = new byte[oldsize];
        FileInputStream in = new FileInputStream(oldFile);
        Util.readFromStream(in, oldBuf, 0, oldsize);
        in.close();
        int[] I = new int[oldsize + 1];
        int[] V = new int[oldsize + 1];
        JBDiff.qsufsort(I, V, oldBuf);
        V = null;
        System.gc();
        int newsize = (int)newFile.length();
        byte[] newBuf = new byte[newsize];
        in = new FileInputStream(newFile);
        Util.readFromStream(in, newBuf, 0, newsize);
        in.close();
        int dblen = 0;
        byte[] db = new byte[newsize];
        int eblen = 0;
        byte[] eb = new byte[newsize];
        DataOutputStream diffOut = new DataOutputStream(new FileOutputStream(diffFile));
        diffOut.write("jbdiff40".getBytes("US-ASCII"));
        diffOut.writeLong(-1L);
        diffOut.writeLong(-1L);
        diffOut.writeLong(newsize);
        int scan = 0;
        int len = 0;
        int lastscan = 0;
        int lastpos = 0;
        int lastoffset = 0;
        IntByRef pos = new IntByRef();
        int ctrlBlockLen = 0;
        while (scan < newsize) {
            int oldscore = 0;
            int scsc = scan += len;
            while (scan < newsize) {
                len = JBDiff.search(I, oldBuf, newBuf, scan, 0, oldsize, pos);
                while (scsc < scan + len) {
                    if (scsc + lastoffset < oldsize && oldBuf[scsc + lastoffset] == newBuf[scsc]) {
                        ++oldscore;
                    }
                    ++scsc;
                }
                if (len == oldscore && len != 0 || len > oldscore + 8) break;
                if (scan + lastoffset < oldsize && oldBuf[scan + lastoffset] == newBuf[scan]) {
                    --oldscore;
                }
                ++scan;
            }
            if (len == oldscore && scan != newsize) continue;
            int s = 0;
            int Sf = 0;
            int lenf = 0;
            int i = 0;
            while (lastscan + i < scan && lastpos + i < oldsize) {
                if (oldBuf[lastpos + i] == newBuf[lastscan + i]) {
                    ++s;
                }
                if (s * 2 - ++i <= Sf * 2 - lenf) continue;
                Sf = s;
                lenf = i;
            }
            int lenb = 0;
            if (scan < newsize) {
                s = 0;
                int Sb = 0;
                for (i = 1; scan >= lastscan + i && pos.value >= i; ++i) {
                    if (oldBuf[pos.value - i] == newBuf[scan - i]) {
                        ++s;
                    }
                    if (s * 2 - i <= Sb * 2 - lenb) continue;
                    Sb = s;
                    lenb = i;
                }
            }
            if (lastscan + lenf > scan - lenb) {
                int overlap = lastscan + lenf - (scan - lenb);
                s = 0;
                int Ss = 0;
                int lens = 0;
                for (i = 0; i < overlap; ++i) {
                    if (newBuf[lastscan + lenf - overlap + i] == oldBuf[lastpos + lenf - overlap + i]) {
                        ++s;
                    }
                    if (newBuf[scan - lenb + i] == oldBuf[pos.value - lenb + i]) {
                        --s;
                    }
                    if (s <= Ss) continue;
                    Ss = s;
                    lens = i + 1;
                }
                lenf += lens - overlap;
                lenb -= lens;
            }
            for (i = 0; i < lenf; ++i) {
                db[dblen + i] = (byte)(newBuf[lastscan + i] - oldBuf[lastpos + i]);
            }
            for (i = 0; i < scan - lenb - (lastscan + lenf); ++i) {
                eb[eblen + i] = newBuf[lastscan + lenf + i];
            }
            dblen += lenf;
            eblen += scan - lenb - (lastscan + lenf);
            diffOut.writeInt(lenf);
            diffOut.writeInt(scan - lenb - (lastscan + lenf));
            diffOut.writeInt(pos.value - lenb - (lastpos + lenf));
            ctrlBlockLen += 12;
            lastscan = scan - lenb;
            lastpos = pos.value - lenb;
            lastoffset = pos.value - scan;
        }
        GZIPOutputStream gzOut = new GZIPOutputStream(diffOut);
        gzOut.write(db, 0, dblen);
        gzOut.finish();
        int diffBlockLen = diffOut.size() - ctrlBlockLen - 32;
        gzOut = new GZIPOutputStream(diffOut);
        gzOut.write(eb, 0, eblen);
        gzOut.finish();
        long extraBlockLen = diffOut.size() - diffBlockLen - ctrlBlockLen - 32;
        diffOut.close();
        RandomAccessFile diff = new RandomAccessFile(diffFile, "rw");
        diff.seek(8L);
        diff.writeLong(ctrlBlockLen);
        diff.writeLong(diffBlockLen);
        diff.close();
    }

    public static void main(String[] arg) throws IOException {
        if (arg.length != 3) {
            System.err.println("usage example: java -Xmx200m ie.wombat.jbdiff.JBDiff oldfile newfile patchfile\n");
            return;
        }
        File oldFile = new File(arg[0]);
        File newFile = new File(arg[1]);
        File diffFile = new File(arg[2]);
        JBDiff.bsdiff(oldFile, newFile, diffFile);
    }

    private static class IntByRef {
        public int value;

        private IntByRef() {
        }
    }
}

