/*
 * Decompiled with CFR 0.152.
 */
package SevenZip;

import SevenZip.Archive.IInArchive;
import SevenZip.Archive.SevenZip.Handler;
import SevenZip.Archive.SevenZipEntry;
import SevenZip.ArchiveExtractCallback;
import SevenZip.MyRandomAccessFile;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;

public class J7zip {
    static void PrintHelp() {
        System.out.println("\nUsage:  JZip <l|t|x> <archive_name> [<file_names>...]\n  l : Lists files\n  t : Tests archive.7z\n  x : eXtracts files\n");
    }

    static void listing(IInArchive archive, Vector<String> listOfNames, boolean techMode) {
        if (!techMode) {
            System.out.println("  Date   Time   Attr         Size   Compressed  Name");
            System.out.println("-------------- ----- ------------ ------------  ------------");
        }
        long size = 0L;
        long packSize = 0L;
        long nbFiles = 0L;
        for (int i = 0; i < archive.size(); ++i) {
            SevenZipEntry item = archive.getEntry(i);
            DateFormat formatter = DateFormat.getDateTimeInstance(3, 3);
            String str_tm = formatter.format(new Date(item.getTime()));
            if (!listOfNames.contains(item.getName())) continue;
            if (techMode) {
                System.out.println("Path = " + item.getName());
                System.out.println("Size = " + item.getSize());
                System.out.println("Packed Size = " + item.getCompressedSize());
                System.out.println("Modified = " + str_tm);
                System.out.println("   Attributes : " + item.getAttributesString());
                long crc = item.getCrc();
                if (crc != -1L) {
                    System.out.println("CRC = " + Long.toHexString(crc).toUpperCase());
                } else {
                    System.out.println("CRC =");
                }
                System.out.println("Method = " + item.getMethods());
                System.out.println("");
            } else {
                System.out.print(str_tm + " " + item.getAttributesString());
                System.out.print(String.format("%13d", item.getSize()));
                System.out.print(String.format("%13d", item.getCompressedSize()));
                System.out.println("  " + item.getName());
            }
            size += item.getSize();
            packSize += item.getCompressedSize();
            ++nbFiles;
        }
        if (!techMode) {
            System.out.println("-------------- ----- ------------ ------------  ------------");
            System.out.print(String.format("                    %13d%13d %d files", size, packSize, nbFiles));
        }
    }

    static void testOrExtract(IInArchive archive, Vector<String> listOfNames, int mode) throws Exception {
        ArchiveExtractCallback extractCallbackSpec;
        ArchiveExtractCallback extractCallback = extractCallbackSpec = new ArchiveExtractCallback();
        extractCallbackSpec.Init(archive);
        extractCallbackSpec.PasswordIsDefined = false;
        try {
            int res;
            int len = 0;
            int[] arrays = null;
            if (listOfNames.size() >= 1) {
                arrays = new int[listOfNames.size()];
                for (int i = 0; i < archive.size(); ++i) {
                    if (!listOfNames.contains(archive.getEntry(i).getName())) continue;
                    arrays[len++] = i;
                }
            }
            if ((res = len == 0 ? archive.Extract(null, -1, mode, extractCallback) : archive.Extract(arrays, len, mode, extractCallback)) == 0) {
                if (extractCallbackSpec.NumErrors == 0L) {
                    System.out.println("Ok Done");
                } else {
                    System.out.println(" " + extractCallbackSpec.NumErrors + " errors");
                }
            } else {
                System.out.println("ERROR !!");
            }
        }
        catch (IOException e2) {
            System.out.println("IO error : " + e2.getLocalizedMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println("\nJ7zip 4.43 ALPHA 2 (" + Runtime.getRuntime().availableProcessors() + " CPUs)");
        if (args.length < 2) {
            J7zip.PrintHelp();
            return;
        }
        boolean MODE_LISTING = false;
        boolean MODE_TESTING = true;
        int MODE_EXTRACT = 2;
        int mode = -1;
        Vector<String> listOfNames = new Vector<String>();
        for (int i = 2; i < args.length; ++i) {
            listOfNames.add(args[i]);
        }
        if (args[0].equals("l")) {
            mode = 0;
        } else if (args[0].equals("t")) {
            mode = 1;
        } else if (args[0].equals("x")) {
            mode = 2;
        } else {
            J7zip.PrintHelp();
            return;
        }
        String filename = args[1];
        MyRandomAccessFile istream = new MyRandomAccessFile(filename, "r");
        Handler archive = new Handler();
        int ret = archive.Open(istream);
        if (ret != 0) {
            System.out.println("ERROR !");
            return;
        }
        switch (mode) {
            case 0: {
                J7zip.listing(archive, listOfNames, false);
                break;
            }
            case 1: {
                J7zip.testOrExtract(archive, listOfNames, 1);
                break;
            }
            case 2: {
                J7zip.testOrExtract(archive, listOfNames, 0);
            }
        }
        archive.close();
    }
}

