/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.LazyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHandlerContainer
extends AbstractHandler
implements HandlerContainer {
    @Override
    public Handler[] getChildHandlers() {
        Object list = this.expandChildren(null, null);
        return (Handler[])LazyList.toArray(list, Handler.class);
    }

    @Override
    public Handler[] getChildHandlersByClass(Class<?> byclass) {
        Object list = this.expandChildren(null, byclass);
        return (Handler[])LazyList.toArray(list, byclass);
    }

    @Override
    public Handler getChildHandlerByClass(Class<?> byclass) {
        Object list = this.expandChildren(null, byclass);
        if (list == null) {
            return null;
        }
        return (Handler)LazyList.get(list, 0);
    }

    protected Object expandChildren(Object list, Class<?> byClass) {
        return list;
    }

    protected Object expandHandler(Handler handler, Object list, Class<Handler> byClass) {
        if (handler == null) {
            return list;
        }
        if (byClass == null || byClass.isAssignableFrom(handler.getClass())) {
            list = LazyList.add(list, handler);
        }
        if (handler instanceof AbstractHandlerContainer) {
            list = ((AbstractHandlerContainer)handler).expandChildren(list, byClass);
        } else if (handler instanceof HandlerContainer) {
            HandlerContainer container = (HandlerContainer)((Object)handler);
            Object[] handlers = byClass == null ? container.getChildHandlers() : container.getChildHandlersByClass(byClass);
            list = LazyList.addArray(list, handlers);
        }
        return list;
    }

    @Override
    protected void dump(StringBuilder b2, String indent) {
        super.dump(b2, indent);
        Handler[] handlers = this.getHandlers();
        if (handlers != null) {
            int last = handlers.length - 1;
            for (int h = 0; h <= last; ++h) {
                b2.append(indent);
                b2.append(" +-");
                if (handlers[h] instanceof AbstractHandler) {
                    ((AbstractHandler)handlers[h]).dump(b2, indent + (h == last ? "   " : " | "));
                    continue;
                }
                b2.append(handlers[h]);
                b2.append("\n");
            }
        }
    }
}

