/*
 * Decompiled with CFR 0.152.
 */
package pythondec3.ast;

import pythondec.PyNone;
import pythondec.op;
import pythondec3.ast.Ast;
import pythondec3.ast.Dsgn;
import pythondec3.ast.Expr;
import pythondec3.ast.IList;
import pythondec3.ast.List;
import pythondec3.ast.Tok;
import pythondec3.ast.sgen;
import shared.m;
import shared.uncaughtexception;

public abstract class Stmt
extends Ast {

    public static class Classdef
    extends Stmt {
        Ast classname;
        IList baseclasses;
        Expr.Makefunction s3;
        public Ast nametostoreas;

        public Classdef(Ast t1, Ast s2, Ast s3, Ast s4) {
            this.classname = t1;
            this.baseclasses = (IList)((Object)s2);
            this.s3 = (Expr.Makefunction)s3;
            this.nametostoreas = s4;
        }

        @Override
        public boolean isimportant() {
            return true;
        }

        @Override
        public void gen2(sgen s) {
            String c2;
            String c1 = this.classname.getGenString();
            if (!c1.equals(c2 = this.nametostoreas.getGenString())) {
                m.throwUncaughtException("unhandled");
            }
            s.endline();
            s.indent();
            s.out("class ");
            this.nametostoreas.gen(s);
            if (this.baseclasses.getlist().size() != 0) {
                s.out("(");
                for (int i = 0; i < this.baseclasses.getlist().size(); ++i) {
                    if (i != 0) {
                        s.out(", ");
                    }
                    ((Ast)this.baseclasses.getlist().get(this.baseclasses.getlist().size() - i - 1)).gen(s);
                }
                s.out(")");
            }
            s.out(":");
            s.endline();
            s.endline();
            s.increaseindentation();
            this.s3.genAsClass(s, c2);
            s.decreaseindentation();
            s.endline();
        }
    }

    public static class Ifelse
    extends Stmt {
        Ast expr;
        Tok ifcmd;
        List ifstmts;
        List elsestmts;

        public Ifelse(Ast expr, Ast ifcmd, Ast ifstmts, Ast elsestmts) {
            this.expr = expr;
            this.ifcmd = (Tok)ifcmd;
            this.ifstmts = (List)ifstmts;
            this.elsestmts = (List)elsestmts;
        }

        @Override
        public void gen2(sgen s) {
            this.gen2(s, false);
        }

        public void gen2(sgen s, boolean iselif) {
            if (this.ifcmd.oi.o != op.JUMP_IF_FALSE) {
                m.throwUncaughtException("unhandled");
            }
            s.indent();
            if (iselif) {
                s.out("elif");
            } else {
                s.out("if");
            }
            s.out(" ");
            this.expr.gen(s);
            s.out(":");
            s.endline();
            s.increaseindentation();
            this.ifstmts.gen(s);
            s.decreaseindentation();
            if (this.elsestmts.size() != 0) {
                if (this.elsestmts.size() == 1 && this.elsestmts.get(0) instanceof Ifelse) {
                    Ifelse elses = (Ifelse)this.elsestmts.get(0);
                    elses.gen2(s, true);
                } else {
                    s.indent();
                    s.out("else:");
                    s.endline();
                    s.increaseindentation();
                    this.elsestmts.gen(s);
                    s.decreaseindentation();
                }
            }
        }
    }

    public static class Whileelse
    extends Stmt {
        Ast expr;
        List whilestmts;
        List elsestmts;

        public Whileelse(Ast expr, Ast whilestmts, Ast elsestmts) {
            this.expr = expr;
            this.whilestmts = (List)whilestmts;
            this.elsestmts = (List)elsestmts;
        }

        @Override
        public void gen2(sgen s) {
            s.indent();
            s.out("while");
            s.out(" (");
            if (this.expr == null) {
                s.out("1");
            } else {
                this.expr.gen(s);
            }
            s.out("):");
            s.endline();
            s.increaseindentation();
            this.whilestmts.gen(s);
            s.decreaseindentation();
            if (this.elsestmts.size() != 0) {
                s.indent();
                s.out("else:");
                s.endline();
                s.increaseindentation();
                this.elsestmts.gen(s);
                s.decreaseindentation();
            }
        }
    }

    public static class Continue
    extends Stmt {
        @Override
        public void gen2(sgen s) {
            s.indent();
            s.out("continue");
            s.endline();
        }
    }

    public static class Break
    extends Stmt {
        @Override
        public void gen2(sgen s) {
            s.indent();
            s.out("break");
            s.endline();
        }
    }

    public static class Forelse
    extends Stmt {
        Tok type;
        Ast expr;
        Ast desig;
        List forstmts;
        List elsestmts;

        public Forelse(Tok token) {
            this.type = token;
        }

        public Forelse setvals(Ast expr, Ast desig, Ast forstmts, Ast elsestmts) {
            this.expr = expr;
            this.desig = desig;
            this.forstmts = (List)forstmts;
            this.elsestmts = (List)elsestmts;
            return this;
        }

        @Override
        public void gen2(sgen s) {
            if (this.type.oi.o != op.FOR_ITER) {
                m.throwUncaughtException("unhandled");
            }
            s.indent();
            s.out("for ");
            this.desig.gen(s);
            s.out(" in ");
            this.expr.gen(s);
            s.out(":");
            s.endline();
            s.increaseindentation();
            this.forstmts.gen(s);
            s.decreaseindentation();
            if (this.elsestmts.size() != 0) {
                s.indent();
                s.out("else:");
                s.endline();
                s.increaseindentation();
                this.elsestmts.gen(s);
                s.decreaseindentation();
            }
        }
    }

    public static class Try
    extends Stmt {

        public static class Except
        extends Ast {
            Ast stmts;

            public Except(Ast stmts) {
                this.stmts = stmts;
            }

            @Override
            public void gen2(sgen s) {
                s.indent();
                s.out("except:");
                s.endline();
                s.increaseindentation();
                this.stmts.gen(s);
                s.decreaseindentation();
            }
        }

        public static class Exceptcond
        extends Ast {
            Ast expr;
            Tok compareop;
            Ast remover;
            List stmts;

            public Exceptcond(Ast expr, Tok compareop, Ast remover, Ast stmts) {
                this.expr = expr;
                this.compareop = compareop;
                this.remover = remover;
                this.stmts = (List)stmts;
            }

            @Override
            public void gen2(sgen s) {
                if (!this.compareop.oi.pattr.equals("exception match")) {
                    m.throwUncaughtException("unhandled");
                }
                s.indent();
                s.out("except ");
                this.expr.gen(s);
                if (this.remover != null) {
                    s.out(", ");
                    this.remover.gen(s);
                }
                s.out(":");
                s.endline();
                s.increaseindentation();
                this.stmts.gen(s);
                s.decreaseindentation();
            }
        }

        public static class Tryexcept2
        extends Try
        implements IList {
            List trystmts;
            List escepts = new List();
            List finstmts;

            public List getlist() {
                return this.escepts;
            }

            public Tryexcept2(Ast elsestmts) {
                this.finstmts = (List)elsestmts;
            }

            public Ast setStmts(Ast trystmts) {
                this.trystmts = (List)trystmts;
                return this;
            }

            @Override
            public void gen2(sgen s) {
                s.indent();
                s.out("try:");
                s.endline();
                s.increaseindentation();
                this.trystmts.gen(s);
                s.decreaseindentation();
                for (int i = 0; i < this.escepts.size(); ++i) {
                    Object escept = this.escepts.get(this.escepts.size() - i - 1);
                    ((Ast)escept).gen(s);
                }
                if (this.finstmts.size() != 0) {
                    s.indent();
                    s.out("else:");
                    s.endline();
                    s.increaseindentation();
                    this.finstmts.gen(s);
                    s.decreaseindentation();
                }
            }
        }

        public static class Tryfinally
        extends Try {
            List trystmts;
            Tok loadconsttok;
            List finstmts;

            public Tryfinally(Ast trystmts, Tok loadconsttok, Ast finstmts) {
                this.trystmts = (List)trystmts;
                this.loadconsttok = loadconsttok;
                this.finstmts = (List)finstmts;
            }

            @Override
            public void gen2(sgen s) {
                if (!(this.loadconsttok.oi.pattr instanceof PyNone)) {
                    m.throwUncaughtException("unhandled");
                }
                s.indent();
                s.out("try:");
                s.endline();
                s.increaseindentation();
                this.trystmts.gen(s);
                s.decreaseindentation();
                s.indent();
                s.out("finally:");
                s.endline();
                s.increaseindentation();
                this.finstmts.gen(s);
                s.decreaseindentation();
            }
        }
    }

    public static class Import
    extends Stmt {
        Tok loadconst;
        Tok importname;
        Ast importer;
        List importerlist;
        int type;

        public Import(Tok loadconst, Tok importname, Ast importer, Ast importerlist, int type) {
            this.loadconst = loadconst;
            this.importname = importname;
            this.importer = importer;
            this.importerlist = (List)importerlist;
            this.type = type;
        }

        @Override
        public void gen2(sgen s) {
            if (this.type == 1) {
                s.indent();
                s.out("import ");
                this.importer.gen(s);
                s.endline();
            } else if (this.type == 2) {
                s.indent();
                s.out("from ");
                String name = this.importname.getName(s);
                s.out(name);
                s.out(" import *");
                s.endline();
            } else if (this.type == 3) {
                s.indent();
                s.out("from ");
                String name = this.importname.getName(s);
                s.out(name);
                s.out(" import ");
                for (int i = 0; i < this.importerlist.size(); ++i) {
                    if (i != 0) {
                        s.out(", ");
                    }
                    ((Ast)this.importerlist.get(i)).gen(s);
                }
                s.endline();
            }
        }

        public static class Importer2
        extends Ast {
            Tok importfrom;
            Ast desig;

            public Importer2(Tok importfrom, Ast desig) {
                this.importfrom = importfrom;
                this.desig = desig;
            }

            @Override
            public void gen2(sgen s) {
                String name = this.importfrom.getName(s);
                s.out(name);
                String dstr = this.desig.getGenString();
                if (!name.equals(dstr)) {
                    s.out(" as ");
                    this.desig.gen(s);
                }
            }
        }

        public static class Importer
        extends Ast {
            Tok importname;
            Tok loadattr;
            Ast desig;

            public Importer(Tok importname, Tok loadattr, Ast desig) {
                this.importname = importname;
                this.loadattr = loadattr;
                this.desig = desig;
            }

            @Override
            public void gen2(sgen s) {
                if (this.loadattr != null) {
                    m.throwUncaughtException("unhandled.");
                }
                String name = this.importname.getName(s);
                s.out(name);
                String dstr = this.desig.getGenString();
                if (!name.equals(dstr) && !name.startsWith(dstr + ".")) {
                    s.out(" as ");
                    this.desig.gen(s);
                }
            }
        }
    }

    public static class Del
    extends Stmt {
        Dsgn desig;

        public Del(Ast desig) {
            this.desig = (Dsgn)desig;
        }

        @Override
        public void gen2(sgen s) {
            s.indent();
            s.out("del ");
            this.desig.gen(s);
            s.endline();
        }
    }

    public static class Exprstmt
    extends Stmt {
        Ast expr;

        public Exprstmt(Ast expr) {
            this.expr = expr;
        }

        @Override
        public void gen2(sgen s) {
            s.indent();
            this.expr.gen(s);
            s.endline();
        }
    }

    public static class Inplace
    extends Stmt {
        Dsgn desig;
        Ast expr;
        Tok inplacetok;

        public Inplace(Dsgn desig, Ast expr, Ast inplacetok) {
            this.desig = desig;
            this.expr = expr;
            this.inplacetok = (Tok)inplacetok;
        }

        @Override
        public void gen2(sgen s) {
            s.indent();
            this.desig.gen(s);
            s.out(" ");
            String opstr = this.getInplaceStr();
            s.out(opstr);
            s.out(" ");
            this.expr.gen(s);
            s.endline();
        }

        public String getInplaceStr() {
            switch (this.inplacetok.oi.o) {
                case INPLACE_ADD: {
                    return "+=";
                }
                case INPLACE_SUBTRACT: {
                    return "-=";
                }
                case INPLACE_OR: {
                    return "|=";
                }
                case INPLACE_AND: {
                    return "&=";
                }
                case INPLACE_DIVIDE: {
                    return "/=";
                }
                case INPLACE_MULTIPLY: {
                    return "*=";
                }
                case INPLACE_POWER: {
                    return "**=";
                }
                case INPLACE_FLOOR_DIVIDE: {
                    return "//=";
                }
                case INPLACE_MODULO: {
                    return "%=";
                }
                case INPLACE_XOR: {
                    return "^=";
                }
                case INPLACE_RSHIFT: {
                    return ">>=";
                }
                case INPLACE_LSHIFT: {
                    return "<<=";
                }
            }
            throw new uncaughtexception("unhandled");
        }

        public Inplace(Ast s1, Ast s2, Ast s3, Ast s4) {
            this.desig = (Dsgn)s4;
            this.inplacetok = (Tok)s3;
            this.expr = s2;
            if (!s1.getGenString().equals(this.desig.getGenString())) {
                m.throwUncaughtException("unexpected/unhandled");
            }
        }
    }

    public static class Raisevarargs
    extends Stmt
    implements IList {
        List args = new List();

        public List getlist() {
            return this.args;
        }

        @Override
        public void gen2(sgen s) {
            s.indent();
            s.out("raise ");
            for (int i = 0; i < this.args.size(); ++i) {
                if (i != 0) {
                    s.out(", ");
                }
                Object expr = this.args.get(this.args.size() - i - 1);
                ((Ast)expr).gen(s);
            }
            s.endline();
        }
    }

    public static class Exec
    extends Stmt {
        Ast s1;
        Expr s2;
        Expr s3;

        public Exec(Ast s1, Ast s2, Ast s3) {
            this.s1 = s1;
            this.s2 = (Expr)s2;
            this.s3 = (Expr)s3;
        }

        @Override
        public void gen2(sgen s) {
            s.indent();
            s.out("exec ");
            this.s1.gen(s);
            if (this.s2 != null && !this.s2.isNoneConst()) {
                s.out(" in ");
                this.s2.gen(s);
            }
            if (this.s3 != null && !this.s3.isNoneConst()) {
                s.out(", ");
                this.s3.gen(s);
            }
            s.endline();
        }
    }

    public static class Yield
    extends Stmt {
        Ast expr;

        public Yield(Ast expr) {
            this.expr = expr;
        }

        @Override
        public void gen2(sgen s) {
            s.indent();
            s.out("yield ");
            this.expr.gen(s);
            s.endline();
        }
    }

    public static class Assert
    extends Stmt {
        Ast s1;
        Ast s2;
        Tok s3;
        Ast s4;

        public Assert(Ast s1, Ast s2, Tok s3, Ast s4) {
            this.s1 = s1;
            this.s2 = s2;
            this.s3 = s3;
            this.s4 = s4;
        }

        @Override
        public void gen2(sgen s) {
            s.indent();
            s.out("assert ");
            this.s2.gen(s);
            if (this.s4 != null) {
                s.out(", ");
                this.s4.gen(s);
            }
            s.endline();
        }
    }
}

