/*
 * Decompiled with CFR 0.152.
 */
package relationvis;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Random;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import prpobjects.Uruobjectdesc;
import prpobjects.prpfile;
import relationvis.entity;
import relationvis.relation;
import shared.FindAllDescendants;
import shared.m;

public class CrossRefPanel
extends JPanel {
    Vector<entity> entities;
    Vector<relation> relations;
    BufferedImage rawimg;
    Graphics2D img;
    boolean movemode = false;
    entity moveentity;
    int width = 950;
    int height = 550;
    public int leftborder = 200;
    boolean includeRelationsThatPointToThemselves = false;
    public int boxsize = 4;
    Color marked = Color.RED;
    Color unmarked = Color.BLUE;
    Color background = Color.WHITE;
    Color arrow = Color.GREEN;

    public void initAsCrossLinkReport(String infile) {
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.entities = new Vector();
        this.relations = new Vector();
        this.rawimg = new BufferedImage(this.width, this.height, 2);
        this.img = this.rawimg.createGraphics();
        this.leftborder = 100;
        this.boxsize = 6;
        prpfile prp = prpfile.createFromFile(infile, false);
        Vector<Uruobjectdesc> refs = FindAllDescendants.FindAllDescendantsByClass(Uruobjectdesc.class, prp);
        for (Uruobjectdesc ref : refs) {
            this.addEntity(ref.toString());
        }
        for (Uruobjectdesc ref : refs) {
            if (ref.rootobj == null) continue;
            this.addRelation(ref.rootobj.toString(), ref.toString());
        }
        final CrossRefPanel ths = this;
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e2) {
            }

            @Override
            public void mouseMoved(MouseEvent e2) {
                entity ent = ths.findEntityAtPixel(e2.getX(), e2.getY());
                String msg = ent == null ? "" : ent.name;
                JPanel gls = (JPanel)SwingUtilities.getRootPane(ths).getGlassPane();
                int w = gls.getWidth();
                gls.setLayout(null);
                gls.setVisible(false);
                gls.removeAll();
                JLabel label = new JLabel(msg);
                Point newpos = SwingUtilities.convertPoint(ths, e2.getX(), e2.getY(), gls);
                label.setBounds(newpos.x + 15, newpos.y - 10, 1000, 20);
                gls.add(label);
                gls.setVisible(true);
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e2) {
            }

            @Override
            public void mousePressed(MouseEvent e2) {
                ths.handleClick(0, e2.getButton(), e2.getX(), e2.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
                ths.handleClick(1, e2.getButton(), e2.getX(), e2.getY());
            }

            @Override
            public void mouseEntered(MouseEvent e2) {
            }

            @Override
            public void mouseExited(MouseEvent e2) {
            }
        });
        this.assignRandomPositions();
        this.drawAll();
    }

    public void deleteMarkedEntities() {
        int i;
        int i2;
        int numents = this.entities.size();
        Vector<entity> removees = new Vector<entity>();
        for (i2 = 0; i2 < numents; ++i2) {
            if (!this.entities.get((int)i2).ismarked) continue;
            removees.add(this.entities.get(i2));
        }
        for (i2 = 0; i2 < removees.size(); ++i2) {
            this.entities.remove(removees.get(i2));
        }
        int relcount = this.relations.size();
        Vector<relation> deletees2 = new Vector<relation>();
        for (i = 0; i < relcount; ++i) {
            relation currel = this.relations.get(i);
            if (this.hasEntity(currel.from.name) && this.hasEntity(currel.to.name)) continue;
            deletees2.add(currel);
        }
        for (i = 0; i < deletees2.size(); ++i) {
            this.relations.remove(deletees2.get(i));
        }
        this.drawAll();
    }

    public void markLinks(boolean doLeftLinks, boolean doRightLinks) {
        entity curent;
        int i;
        int numents = this.entities.size();
        for (i = 0; i < numents; ++i) {
            curent = this.entities.get(i);
            curent.temp1 = false;
        }
        for (i = 0; i < numents; ++i) {
            int j;
            curent = this.entities.get(i);
            if (!curent.ismarked) continue;
            curent.temp1 = true;
            if (doLeftLinks) {
                for (j = 0; j < curent.leftlinks.size(); ++j) {
                    curent.leftlinks.get((int)j).temp1 = true;
                }
            }
            if (!doRightLinks) continue;
            for (j = 0; j < curent.rightlinks.size(); ++j) {
                curent.rightlinks.get((int)j).temp1 = true;
            }
        }
        for (i = 0; i < numents; ++i) {
            curent = this.entities.get(i);
            curent.ismarked = curent.temp1;
        }
        this.drawAll();
    }

    public void markEntitiesThatStartWith(String start) {
        int numents = this.entities.size();
        start = start.toLowerCase();
        for (int i = 0; i < numents; ++i) {
            if (!this.entities.get((int)i).name.toLowerCase().startsWith(start)) continue;
            this.entities.get((int)i).ismarked = true;
        }
        this.drawAll();
    }

    public void markEntitiesThatEndWith(String end) {
        int numents = this.entities.size();
        end = end.toLowerCase();
        for (int i = 0; i < numents; ++i) {
            if (!this.entities.get((int)i).name.toLowerCase().endsWith(end)) continue;
            this.entities.get((int)i).ismarked = true;
        }
        this.drawAll();
    }

    public void clearAllMarks() {
        int numents = this.entities.size();
        for (int i = 0; i < numents; ++i) {
            this.entities.get((int)i).ismarked = false;
        }
        this.drawAll();
    }

    public void handleClick(int downOrUp, int mousebutton, int xpos, int ypos) {
        if (downOrUp == 0) {
            entity ent;
            if (mousebutton == 1) {
                entity ent2 = this.findEntityAtPixel(xpos, ypos);
                if (ent2 != null) {
                    this.movemode = true;
                    this.moveentity = ent2;
                }
            } else if (mousebutton == 3) {
                entity ent3 = this.findEntityAtPixel(xpos, ypos);
                if (ent3 != null) {
                    ent3.ismarked = !ent3.ismarked;
                    this.drawAll();
                }
            } else if ((mousebutton == 2 || mousebutton == 0) && (ent = this.findEntityAtPixel(xpos, ypos)) != null) {
                this.drawMessage("Name:" + ent.name);
            }
        } else if (mousebutton == 1 && this.movemode) {
            this.movemode = false;
            this.moveentity.xpos = xpos;
            this.moveentity.ypos = ypos;
            this.drawAll();
        }
    }

    public void drawMessage(String s) {
        m.msg(s);
    }

    public void drawAll() {
        this.img.setColor(this.background);
        this.img.fillRect(0, 0, this.width, this.height);
        this.drawRelations();
        this.drawEntities();
        this.repaintOld();
    }

    public entity findEntityAtPixel(int xpos, int ypos) {
        int numents = this.entities.size();
        for (int i = numents - 1; i >= 0; --i) {
            entity curent = this.entities.get(i);
            if (xpos < curent.xpos || xpos > curent.xpos + this.boxsize || ypos < curent.ypos || ypos > curent.ypos + this.boxsize) continue;
            return curent;
        }
        return null;
    }

    public void assignRandomPositions() {
        Random rng = new Random();
        int numents = this.entities.size();
        for (int i = 0; i < numents; ++i) {
            int xpos = this.leftborder + rng.nextInt(this.width - this.leftborder - this.boxsize);
            int ypos = rng.nextInt(this.height - this.boxsize);
            entity curent = this.entities.get(i);
            curent.xpos = xpos;
            curent.ypos = ypos;
        }
    }

    public void drawRelations() {
        this.img.setColor(this.arrow);
        int numrels = this.relations.size();
        for (int i = 0; i < numrels; ++i) {
            relation currel = this.relations.get(i);
            entity from = currel.from;
            entity to = currel.to;
            this.img.drawLine(from.xpos, from.ypos, to.xpos, to.ypos);
            if (!from.ismarked && !to.ismarked) continue;
            double k = 0.9;
            double l = 0.05;
            int x0 = (int)((double)from.xpos + k * (double)(to.xpos - from.xpos) - l * (double)(to.ypos - from.ypos));
            int x1 = (int)((double)from.xpos + k * (double)(to.xpos - from.xpos) + l * (double)(to.ypos - from.ypos));
            int y0 = (int)((double)from.ypos + k * (double)(to.ypos - from.ypos) + l * (double)(to.xpos - from.xpos));
            int y1 = (int)((double)from.ypos + k * (double)(to.ypos - from.ypos) - l * (double)(to.xpos - from.xpos));
            this.img.drawLine(x0, y0, to.xpos, to.ypos);
            this.img.drawLine(x1, y1, to.xpos, to.ypos);
        }
    }

    public void drawEntities() {
        int numents = this.entities.size();
        for (int i = 0; i < numents; ++i) {
            entity curent = this.entities.get(i);
            if (curent.ismarked) {
                this.img.setColor(this.marked);
                this.img.drawRect(curent.xpos, curent.ypos, this.boxsize, this.boxsize);
                this.img.fillRect(curent.xpos, curent.ypos, this.boxsize, this.boxsize);
                continue;
            }
            this.img.setColor(this.unmarked);
            this.img.drawRect(curent.xpos, curent.ypos, this.boxsize, this.boxsize);
        }
    }

    public void addEntity(String entityname) {
        if (!this.hasEntity(entityname)) {
            this.addEntity(new entity(entityname));
        }
    }

    public void addRelation(String fromname, String toname) {
        entity from = this.findEntity(fromname);
        entity to = this.findEntity(toname);
        if (from != null && to != null) {
            if (!(!this.includeRelationsThatPointToThemselves && from.equals(to) || this.hasRelation(fromname, toname))) {
                this.addRelation(new relation(from, to));
                from.rightlinks.add(to);
                to.leftlinks.add(from);
            }
        } else {
            m.err("not both entities were found.");
        }
    }

    public boolean hasEntity(String name) {
        return this.findEntity(name) != null;
    }

    public boolean hasRelation(String fromname, String toname) {
        return this.findRelation(fromname, toname) != null;
    }

    public entity findEntity(String name) {
        int numentities = this.entities.size();
        for (int i = 0; i < numentities; ++i) {
            if (!this.entities.get((int)i).name.equals(name)) continue;
            return this.entities.get(i);
        }
        return null;
    }

    public relation findRelation(String fromname, String toname) {
        int size = this.relations.size();
        for (int i = 0; i < size; ++i) {
            if (!this.relations.get((int)i).from.name.equals(fromname) || !this.relations.get((int)i).to.name.equals(toname)) continue;
            return this.relations.get(i);
        }
        return null;
    }

    public void addEntity(entity ent) {
        this.entities.add(ent);
    }

    public void addRelation(relation rel) {
        this.relations.add(rel);
    }

    public void drawToCanvas(Graphics dest) {
        this.drawToCanvas(dest, 0, 0);
    }

    public void drawToCanvas(Graphics dest, int xpos, int ypos) {
        dest.drawImage(this.rawimg, xpos, ypos, null);
    }

    public void repaintOld() {
        this.getGraphics().drawImage(this.rawimg, 0, 0, null);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.rawimg != null) {
            g.drawImage(this.rawimg, 0, 0, null);
        }
    }

    @Override
    public void paintBorder(Graphics g) {
    }
}

