/*
 * Decompiled with CFR 0.152.
 */
package shared;

import shared.nested;

public class EscapeUtils {
    public static String unescapeJavaString(String s) {
        StringBuilder r = new StringBuilder();
        int size = s.length();
        StringBuffer unicode = new StringBuffer(4);
        boolean hadSlash = false;
        boolean inUnicode = false;
        for (int i = 0; i < size; ++i) {
            char ch = s.charAt(i);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() != 4) continue;
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    r.append((char)value);
                    unicode.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new nested(nfe);
                }
            }
            if (hadSlash) {
                hadSlash = false;
                switch (ch) {
                    case '\\': {
                        r.append('\\');
                        break;
                    }
                    case '\'': {
                        r.append('\'');
                        break;
                    }
                    case '\"': {
                        r.append('\"');
                        break;
                    }
                    case 'r': {
                        r.append('\r');
                        break;
                    }
                    case 'f': {
                        r.append('\f');
                        break;
                    }
                    case 't': {
                        r.append('\t');
                        break;
                    }
                    case 'n': {
                        r.append('\n');
                        break;
                    }
                    case 'b': {
                        r.append('\b');
                        break;
                    }
                    case 'u': {
                        inUnicode = true;
                        break;
                    }
                    default: {
                        r.append(ch);
                        break;
                    }
                }
                continue;
            }
            if (ch == '\\') {
                hadSlash = true;
                continue;
            }
            r.append(ch);
        }
        if (hadSlash) {
            r.append('\\');
        }
        return r.toString();
    }

    public static String escapeHtmlString(String s) {
        StringBuffer r = new StringBuffer();
        block6: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    r.append("&lt;");
                    continue block6;
                }
                case '>': {
                    r.append("&gt;");
                    continue block6;
                }
                case '&': {
                    r.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    r.append("&quot;");
                    continue block6;
                }
                default: {
                    r.append(ch);
                }
            }
        }
        return r.toString();
    }

    public static String escapeXmlString(String s) {
        if (s == null) {
            s = "";
        }
        StringBuffer r = new StringBuffer();
        block8: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    r.append("&lt;");
                    continue block8;
                }
                case '>': {
                    r.append("&gt;");
                    continue block8;
                }
                case '&': {
                    r.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    r.append("&quot;");
                    continue block8;
                }
                case '\'': {
                    r.append("&apos;");
                    continue block8;
                }
                case '\u001b': {
                    r.append("&#");
                    r.append(Integer.toString(ch));
                    r.append(";");
                    continue block8;
                }
                default: {
                    r.append(ch);
                }
            }
        }
        return r.toString();
    }
}

