/*
 * Decompiled with CFR 0.152.
 */
package uru.server;

import auto.ageLists;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import prpobjects.PrpRootObject;
import prpobjects.Typeid;
import prpobjects.plLayerBink;
import prpobjects.plOneShotMod;
import prpobjects.plSoundBuffer;
import prpobjects.prpfile;
import shared.Concurrent;
import shared.CryptHashes;
import shared.FileUtils;
import shared.Format;
import shared.HttpUtils;
import shared.MemUtils;
import shared.Str;
import shared.b;
import shared.m;
import shared.uncaughtexception;
import shared.zip;
import uru.server.Manifest;
import uru.server.Mfs;
import uru.server.MoulFileInfo;
import uru.server.SerializationUtils;
import uru.server.TextMapFile;

public class Dataserver {
    boolean writedatafiles = false;
    boolean writemanifestfiles = true;
    DataserverType type;
    String root;
    String outroot;
    DataserverInfo info;
    DataserverInfo oldinfo;
    ArrayList<String> prpfiles;
    HashMap<String, HashSet<String>> pages;
    private static final String[] installfiles = new String[]{"/UruSetup.exe", "/UruLauncher.exe", "/Uru.exe", "/msvcp60.dll", "/eax.dll", "/msvcrt.dll", "/ReleaseNotes.html", "/UAM32.dll"};
    private static final String[] agepaths = new String[]{"/dat/", "/sfx/", "/avi/"};

    public static void MirrorServer(String serverdns, String outfolder, boolean includeGeneralFiles, boolean includePotsAges, boolean includeAgelistAges, boolean includeAvailableLinksAges, boolean includeCustomAges, String customAges) {
        byte[] data;
        LinkedHashSet<String> manifests = new LinkedHashSet<String>();
        if (includeGeneralFiles) {
            Dataserver.SaveFile(serverdns, outfolder, "/status/lobbylist.txt");
            Dataserver.TryToSaveFile(serverdns, outfolder, "/status/index_eng.html");
            Dataserver.TryToSaveFile(serverdns, outfolder, "/status/index_fra.html");
            Dataserver.TryToSaveFile(serverdns, outfolder, "/status/index_ger.html");
            Dataserver.SaveAndParseAndSaveMfs(serverdns, outfolder, "/install/Expanded/ClientSetupNew.mfs", "/install/Expanded/");
            Dataserver.SaveAndParseAndSaveMfs(serverdns, outfolder, "/game_clients/drcExplorer/client.mfs", "/game_clients/drcExplorer/");
        }
        if (includePotsAges) {
            for (String age : ageLists.potsages) {
                if (manifests.contains(age)) continue;
                try {
                    Dataserver.SaveAndParseAndSaveMfs(serverdns, outfolder, "/game_data/dat/" + age + ".mfs", "/game_data/");
                    manifests.add(age);
                }
                catch (Exception e2) {
                    m.warn("Unable to download all of Age: ", age);
                }
            }
        }
        if (includeAgelistAges) {
            data = Dataserver.SaveFile(serverdns, outfolder, "/game_data/dat/agelist.txt");
            String data2 = b.BytesToString(data);
            for (String age : data2.split("\n")) {
                if ((age = age.trim()).equals("") || manifests.contains(age)) continue;
                try {
                    Dataserver.SaveAndParseAndSaveMfs(serverdns, outfolder, "/game_data/dat/" + age + ".mfs", "/game_data/");
                    manifests.add(age);
                }
                catch (Exception e3) {
                    m.warn("Unable to download all of Age: ", age);
                }
            }
        }
        if (includeAvailableLinksAges) {
            data = HttpUtils.geturl("http://" + serverdns + "/game_clients/drcExplorer/AvailableLinks.inf");
            String data2 = b.BytesToString(data);
            for (String line : data2.split("\n")) {
                line = line.trim();
                String age = null;
                if (line.startsWith("restorationlink:")) {
                    age = line.substring("restorationlink:".length(), line.indexOf(","));
                } else if (line.startsWith("publiclink:")) {
                    age = line.substring("publiclink:".length(), line.indexOf(","));
                } else if (line.startsWith("link:")) {
                    age = line.substring("link:".length(), line.indexOf(","));
                }
                if (age == null || manifests.contains(age)) continue;
                try {
                    Dataserver.SaveAndParseAndSaveMfs(serverdns, outfolder, "/game_data/dat/" + age + ".mfs", "/game_data/");
                    manifests.add(age);
                }
                catch (Exception e4) {
                    m.warn("Unable to download all of Age: ", age);
                }
            }
        }
        if (includeCustomAges) {
            for (String line : customAges.split("\n")) {
                String age;
                if ((line = line.trim()).startsWith("#") || line.equals("") || manifests.contains(age = line)) continue;
                try {
                    Dataserver.SaveAndParseAndSaveMfs(serverdns, outfolder, "/game_data/dat/" + age + ".mfs", "/game_data/");
                    manifests.add(age);
                }
                catch (Exception e5) {
                    m.warn("Unable to download all of Age: ", age);
                }
            }
        }
        m.status("Done mirroring the dataserver!");
    }

    private static boolean HasFile(String filename, byte[] md5, boolean md5OnDecompressed) {
        File f = new File(filename);
        if (f.isDirectory()) {
            throw new uncaughtexception("A folder exists which should be a file: " + filename);
        }
        if (!f.exists()) {
            return false;
        }
        if (!md5OnDecompressed) {
            byte[] actualmd5 = CryptHashes.GetHash(filename, CryptHashes.Hashtype.md5);
            return b.isEqual(md5, actualmd5);
        }
        byte[] actualmd5 = CryptHashes.GetHash(zip.decompressGzip(FileUtils.ReadFile(f)), CryptHashes.Hashtype.md5);
        return b.isEqual(md5, actualmd5);
    }

    private static void SaveIfNeeded(String serverdns, String outfolder, String serverpath, String basepath, Mfs.MfsEntry entry, String relpath) {
        boolean compressed = entry.flag == 8;
        String path = basepath + relpath + entry.filename + (compressed ? ".gz" : "");
        String source = "http://" + serverdns + path;
        String destin = outfolder + path;
        if (!Dataserver.HasFile(destin, entry.md5, compressed)) {
            byte[] data = HttpUtils.geturl(source);
            FileUtils.WriteFile(destin, data, true);
        }
    }

    private static void SaveAndParseAndSaveMfs(String serverdns, String outfolder, String serverpath, String basepath) {
        Mfs mfs = Dataserver.SaveAndParseMfs(serverdns, outfolder, serverpath);
        for (Mfs.MfsEntry entry : mfs.base) {
            Dataserver.SaveIfNeeded(serverdns, outfolder, serverpath, basepath, entry, "");
        }
        for (Mfs.MfsEntry entry : mfs.pages) {
            Dataserver.SaveIfNeeded(serverdns, outfolder, serverpath, basepath, entry, "/dat/");
        }
        for (Mfs.MfsEntry entry : mfs.other) {
            Dataserver.SaveIfNeeded(serverdns, outfolder, serverpath, basepath, entry, "");
        }
    }

    private static byte[] TryToSaveFile(String serverdns, String outfolder, String serverpath) {
        try {
            byte[] result = Dataserver.SaveFile(serverdns, outfolder, serverpath);
            return result;
        }
        catch (Exception e2) {
            return null;
        }
    }

    private static byte[] SaveFile(String serverdns, String outfolder, String serverpath) {
        byte[] data = HttpUtils.geturl("http://" + serverdns + serverpath);
        if (data == null) {
            throw new uncaughtexception("Unable to read file from server: " + serverpath);
        }
        FileUtils.WriteFile(outfolder + serverpath, data, true);
        return data;
    }

    private static Mfs SaveAndParseMfs(String serverdns, String outfolder, String serverpath) {
        byte[] data = Dataserver.SaveFile(serverdns, outfolder, serverpath);
        Mfs result = Mfs.readFromString(b.BytesToString(data));
        return result;
    }

    public static void CreateFiles(String root2, String outfolder2, boolean writeDataFiles) {
        Dataserver ds = new Dataserver(root2, outfolder2);
        ds.writedatafiles = writeDataFiles;
        ds.type = DataserverType.moul;
        ds.generate();
    }

    public static void CreateFilesMoul(String root2, String outfolder2, boolean writeDataFiles) {
        Dataserver ds = new Dataserver(root2, outfolder2);
        ds.writedatafiles = writeDataFiles;
        ds.type = DataserverType.moul;
        ds.generate();
    }

    public Dataserver(String root2, String outfolder2) {
        this.root = root2 + "/";
        this.outroot = outfolder2 + "/";
        this.prpfiles = new ArrayList();
        File datdir = new File(this.root + "/dat/");
        for (File f : datdir.listFiles()) {
            String filename;
            if (!f.isFile() || !(filename = f.getName()).endsWith(".prp")) continue;
            this.prpfiles.add(f.getName());
        }
        this.pages = new HashMap();
        for (String prpfile2 : this.prpfiles) {
            int idx = prpfile2.indexOf("_District_");
            String agename = prpfile2.substring(0, idx);
            String pagename = prpfile2.substring(idx + "_District_".length(), prpfile2.length() - ".prp".length());
            HashSet<String> ages = this.pages.get(pagename);
            if (ages == null) {
                ages = new HashSet();
                this.pages.put(pagename, ages);
            }
            ages.add(agename);
        }
    }

    public void generate() {
        this.generateMoul();
    }

    public String GetPrefixPath(String relpath) {
        if (this.IsAgeFile(relpath)) {
            return "/game_data/";
        }
        if (this.IsInstallFile(relpath)) {
            return "/install/Expanded/";
        }
        return "/game_clients/drcExplorer/";
    }

    private boolean IsAgeFile(String relpath) {
        if (relpath.endsWith(".txt")) {
            return false;
        }
        for (String s : agepaths) {
            if (!relpath.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private boolean IsInstallFile(String relpath) {
        for (String s : installfiles) {
            if (!relpath.equals(s)) continue;
            return true;
        }
        return false;
    }

    private boolean IsClientFile(String relpath) {
        return !this.IsAgeFile(relpath) && !this.IsInstallFile(relpath);
    }

    private void ReadFileInfo(String relpath) {
        String abspath = this.root + "/" + relpath;
        File f = new File(abspath);
        if (!f.exists()) {
            m.throwUncaughtException("woops!");
        }
        if (f.isDirectory()) {
            for (File child : f.listFiles()) {
                this.ReadFileInfo(relpath + "/" + child.getName());
            }
        } else {
            String[] ignoreequals;
            String[] ignoreends;
            String[] ignorestarts;
            for (String i : ignorestarts = new String[]{"/KIimages/", "/log/", "/MyJournals/", "/sfx/streamingCache/", "/vnode_cache/", "/vnodes/", "/init/", "/DrizzleDataserver", "/originalfiles/"}) {
                if (!relpath.startsWith(i)) continue;
                return;
            }
            for (String i : ignoreends = new String[]{".sum"}) {
                if (!relpath.endsWith(i)) continue;
                return;
            }
            for (String i : ignoreequals = new String[]{"/plClientSetup.cfg", "/dev_mode.dat"}) {
                if (!relpath.equals(i)) continue;
                return;
            }
            long filesize = f.length();
            long moddate = f.lastModified();
            DataserverInfo.DataserverFileInfo curinfo = this.oldinfo.map.get(relpath);
            if (curinfo != null && curinfo.filesize == filesize && curinfo.lastmodified == moddate) {
                this.info.map.put(relpath, curinfo);
            } else {
                curinfo = new DataserverInfo.DataserverFileInfo();
                curinfo.relpath = relpath;
                curinfo.filesize = filesize;
                curinfo.lastmodified = moddate;
                byte[] filedata = FileUtils.ReadFile(abspath);
                curinfo.md5 = CryptHashes.GetMd5(filedata);
                byte[] compressedfiledata = zip.compressGzip(filedata);
                curinfo.compressedfilesize = b.Int32ToInt64(compressedfiledata.length);
                curinfo.compressedmd5 = CryptHashes.GetMd5(filedata);
                FileUtils.WriteFile(new File(this.outroot + "/game_data/" + relpath + ".gz"), compressedfiledata, true, true, false, true);
                if (!this.IsAgeFile(relpath)) {
                    if (this.IsInstallFile(relpath)) {
                        FileUtils.WriteFile(new File(this.outroot + "/install/Expanded/" + relpath + ".gz"), compressedfiledata, true, true, false, true);
                    } else {
                        FileUtils.WriteFile(new File(this.outroot + "/game_clients/drcExplorer/" + relpath + ".gz"), compressedfiledata, true, true, false, true);
                    }
                }
                if (relpath.toLowerCase().endsWith(".prp")) {
                    prpfile prp = prpfile.createFromFile(abspath, true);
                    for (PrpRootObject obj : prp.FindAllObjectsOfType(Typeid.plLayerBink)) {
                        plLayerBink bink = (plLayerBink)obj.castTo();
                        String binkfilename = bink.parent.filename.toString();
                        if (binkfilename.startsWith("avi/")) {
                            binkfilename = "/" + binkfilename;
                        } else if (!binkfilename.startsWith("/avi/")) {
                            m.throwUncaughtException("Weird bik filename: " + binkfilename);
                        }
                        curinfo.avifiles.add(binkfilename);
                    }
                    for (PrpRootObject obj : prp.FindAllObjectsOfType(Typeid.plSoundBuffer)) {
                        plSoundBuffer sb = (plSoundBuffer)obj.castTo();
                        String oggfilename = sb.oggfile.toString();
                        int flags = sb.flags;
                        DataserverInfo.SfxInfo sfxinfo = new DataserverInfo.SfxInfo();
                        sfxinfo.relpath = "/sfx/" + oggfilename;
                        sfxinfo.flags = flags;
                        curinfo.sfxfiles.put(oggfilename, sfxinfo);
                    }
                    for (PrpRootObject obj : prp.FindAllObjectsOfType(Typeid.plOneShotMod)) {
                        plOneShotMod osm = (plOneShotMod)obj.castTo();
                        String animname = osm.animobjectname.toString();
                        curinfo.oneshotmods.add(animname);
                    }
                }
                this.info.map.put(relpath, curinfo);
                MemUtils.GarbageCollect();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void generateMoul() {
        String infile;
        String filename;
        Object relpath;
        m.status("Starting dataserver file creation...");
        this.info = new DataserverInfo();
        String dataserverfileinfo = this.outroot + "/DrizzleDataserverInfo.dat";
        this.oldinfo = (DataserverInfo)SerializationUtils.ReadFromFile(dataserverfileinfo, false);
        if (this.oldinfo == null) {
            m.status("Starting from scratch...");
            this.oldinfo = new DataserverInfo();
        } else {
            m.status("Updating previous info...");
        }
        this.ReadFileInfo("");
        HashMap<String, Integer> soundflags = new HashMap<String, Integer>();
        Concurrent.HashSetMap<Object, String> files = new Concurrent.HashSetMap<Object, String>();
        ArrayList agefiles = new ArrayList();
        ArrayList sdlfiles = new ArrayList();
        File overridefile = new File(this.root + "/DrizzleDataserverOverrides.txt");
        if (overridefile.exists()) {
            Iterator<DataserverInfo.DataserverFileInfo> of_contents = FileUtils.ReadFileAsString(overridefile);
            TextMapFile overrides = new TextMapFile((String)((Object)of_contents));
            for (TextMapFile.Item item : overrides.entries) {
                String string = item.left;
                String manifest = item.right;
                m.msg("Override: ", string, " ", manifest);
                files.addToSet(string, manifest);
            }
        }
        for (DataserverInfo.DataserverFileInfo fileinfo : this.info.map.values()) {
            relpath = fileinfo.relpath;
            if (this.IsAgeFile((String)relpath)) {
                String age;
                if (((String)relpath).endsWith(".p2f")) {
                    files.addToSet(relpath, "GUI.mfs");
                    continue;
                }
                if (((String)relpath).endsWith(".loc")) {
                    files.addToSet(relpath, "GUI.mfs");
                    continue;
                }
                if (((String)relpath).endsWith(".age")) {
                    age = ((String)relpath).substring(((String)relpath).lastIndexOf("/") + 1, ((String)relpath).length() - ".age".length());
                    files.addToSet(relpath, age + ".mfs");
                    agefiles.add(relpath);
                    continue;
                }
                if (((String)relpath).endsWith(".fni")) {
                    age = ((String)relpath).substring(((String)relpath).lastIndexOf("/") + 1, ((String)relpath).length() - ".fni".length());
                    files.addToSet(relpath, age + ".mfs");
                    continue;
                }
                if (((String)relpath).endsWith(".csv")) {
                    age = ((String)relpath).substring(((String)relpath).lastIndexOf("/") + 1, ((String)relpath).length() - ".csv".length());
                    files.addToSet(relpath, age + ".mfs");
                    continue;
                }
                if (((String)relpath).endsWith(".prp")) {
                    age = ((String)relpath).substring(((String)relpath).lastIndexOf("/") + 1, ((String)relpath).indexOf("_District_"));
                    files.addToSet(relpath, age + ".mfs");
                    for (DataserverInfo.SfxInfo sfxinfo : fileinfo.sfxfiles.values()) {
                        boolean case3;
                        Integer dsflags = (Integer)soundflags.get(sfxinfo.relpath);
                        if (dsflags == null) {
                            dsflags = 0;
                        }
                        boolean case1 = (sfxinfo.flags & 4) != 0 || (sfxinfo.flags & 8) != 0;
                        boolean case2 = (sfxinfo.flags & 0x10) != 0;
                        boolean bl = case3 = !case1 && !case2;
                        if (case1) {
                            dsflags = dsflags | 1;
                        }
                        if (case2) {
                            dsflags = dsflags | 2;
                        }
                        if (case3) {
                            dsflags = dsflags | 4;
                        }
                        soundflags.put(sfxinfo.relpath, dsflags);
                        files.addToSet(sfxinfo.relpath, age + ".mfs");
                    }
                    for (String bikfile : fileinfo.avifiles) {
                        files.addToSet(bikfile, age + ".mfs");
                    }
                    for (String anim : fileinfo.oneshotmods) {
                        if (anim.equals("")) {
                            m.warn("Animation name was left blank in file: ", fileinfo.relpath);
                            continue;
                        }
                        HashSet<String> ages = this.pages.get("Female" + anim);
                        if (ages == null) {
                            m.warn("Animation not found: ", anim);
                            continue;
                        }
                        if (ages.contains("GlobalAnimations") || ages.contains(age)) continue;
                        if (ages.size() > 1) {
                            m.err("Age uses animation from another Age, but there is more than 1 possibility!");
                        }
                        for (String curage : ages) {
                            String prp1 = "/dat/" + curage + "_District_Female" + anim + ".prp";
                            String prp2 = "/dat/" + curage + "_District_Male" + anim + ".prp";
                            files.addToSet(prp1, age + ".mfs");
                            files.addToSet(prp2, age + ".mfs");
                            m.warn("Age uses animation from another Age: ", age, " uses animation from ", curage);
                        }
                    }
                    continue;
                }
                if (((String)relpath).endsWith(".ogg") || ((String)relpath).endsWith(".bik")) continue;
                files.addToSet(relpath, "GUI.mfs");
                continue;
            }
            if (this.IsInstallFile((String)relpath)) {
                files.addToSet(relpath, "ClientSetupNew.mfs");
                continue;
            }
            if (((String)relpath).endsWith(".sdl")) {
                files.addToSet(relpath, "client.mfs");
                sdlfiles.add(relpath);
                continue;
            }
            files.addToSet(relpath, "client.mfs");
        }
        for (DataserverInfo.DataserverFileInfo fileinfo : this.info.map.values()) {
            relpath = fileinfo.relpath;
            Set manifestsBelongedTo = (Set)files.get(relpath);
            if (manifestsBelongedTo != null) continue;
            files.addToSet(relpath, "GUI.mfs");
        }
        boolean forceConvertedAges = false;
        Concurrent.HashSetMap<String, String> manifests = new Concurrent.HashSetMap<String, String>();
        for (String relpath3 : files.keySet()) {
            for (String manifest : (HashSet)files.get(relpath3)) {
                manifests.addToSet(manifest, relpath3);
            }
        }
        if (this.writemanifestfiles) {
            for (Iterator mfs : manifests.keySet()) {
                String outmfs;
                m.msg(new String[]{"Doing manifest file: ", mfs});
                if (((String)((Object)mfs)).equals("ClientSetupNew.mfs")) {
                    String string = "/install/Expanded/";
                    outmfs = this.outroot + string;
                } else if (((String)((Object)mfs)).equals("client.mfs")) {
                    String string = "/game_clients/drcExplorer/";
                    outmfs = this.outroot + string;
                } else {
                    String string = "/game_data/";
                    outmfs = this.outroot + string + "dat/";
                }
                mfsfile mfsf = new mfsfile();
                Manifest moulmanifest = new Manifest();
                for (String relpath4 : (HashSet)manifests.get(mfs)) {
                    void var11_23;
                    DataserverInfo.DataserverFileInfo dfi = this.info.map.get(relpath4);
                    if (dfi == null) {
                        m.msg("Missing file: ", relpath4);
                        continue;
                    }
                    StringBuilder entry = new StringBuilder();
                    String label = dfi.relpath.endsWith(".prp") ? dfi.relpath.substring(dfi.relpath.lastIndexOf("/") + 1) : dfi.relpath.substring(1);
                    entry.append(label);
                    entry.append(",");
                    entry.append(Long.toString(dfi.filesize));
                    entry.append(",");
                    SimpleDateFormat format = new SimpleDateFormat("MM/dd/yy HH:mm:ss");
                    Date d = new Date(dfi.lastmodified);
                    String dresult = format.format(d);
                    entry.append(dresult);
                    entry.append(",");
                    String md5str = b.BytesToHexString(dfi.md5);
                    md5str = md5str.toLowerCase();
                    entry.append(md5str);
                    entry.append(",");
                    Integer flag = (Integer)soundflags.get(dfi.relpath);
                    if (flag == null) {
                        flag = 0;
                    }
                    flag = flag | 8;
                    entry.append(Integer.toString(flag));
                    if ((flag & 8) != 0) {
                        entry.append(",");
                        entry.append(Long.toString(dfi.compressedfilesize));
                    }
                    if (dfi.relpath.endsWith(".age")) {
                        mfsf.base.add(entry.toString());
                    } else if (dfi.relpath.endsWith(".fni")) {
                        mfsf.base.add(entry.toString());
                    } else if (dfi.relpath.endsWith(".csv")) {
                        mfsf.base.add(entry.toString());
                    } else if (dfi.relpath.endsWith(".p2f")) {
                        mfsf.base.add(entry.toString());
                    } else if (dfi.relpath.endsWith(".prp")) {
                        mfsf.pages.add(entry.toString());
                    } else {
                        mfsf.other.add(entry.toString());
                    }
                    MoulFileInfo mi = new MoulFileInfo();
                    mi.SetFilename(dfi.relpath);
                    mi.SetDownloadname((String)var11_23 + dfi.relpath + ".gz");
                    mi.Hash = new Str(b.BytesToHexString(dfi.md5));
                    mi.CompressedHash = new Str(b.BytesToHexString(dfi.compressedmd5));
                    mi.Filesize = (int)dfi.filesize;
                    mi.Compressedsize = (int)dfi.compressedfilesize;
                    Integer sndflag = (Integer)soundflags.get(dfi.relpath);
                    if (sndflag == null) {
                        sndflag = 0;
                    }
                    mi.Flags = sndflag;
                    moulmanifest.getFiles().add(mi);
                }
                String[] startprogs = new String[]{"UruExplorer.exe,", "UruIntermediary.exe,"};
                if (((String)((Object)mfs)).equals("client.mfs")) {
                    for (String startprog : startprogs) {
                        for (int i = 0; i < mfsf.other.size(); ++i) {
                            String curs = mfsf.other.get(i);
                            if (!curs.startsWith(startprog)) continue;
                            mfsf.other.set(i, mfsf.other.get(0));
                            mfsf.other.set(0, curs);
                        }
                    }
                }
                FileUtils.SaveFileIfChanged(outmfs + "/" + mfs, mfsf.getBytes(), true, true);
                FileUtils.SaveFileIfChanged(outmfs + "/" + mfs + "_moul", moulmanifest.compileAlone(Format.moul), true, true);
            }
        }
        String agelist_txt = "GlobalAnimations\nGlobalClothing\nGlobalMarkers\nGUI\nCustomAvatars\nGlobalAvatars\n";
        FileUtils.SaveFileIfChanged(this.outroot + "/game_data/dat/agelist.txt", b.StringToBytes(agelist_txt), true, true);
        for (String string : agefiles) {
            filename = string.substring(string.lastIndexOf("/") + 1);
            if (!string.toLowerCase().equals("/dat/" + filename.toLowerCase())) continue;
            infile = this.root + "/" + string;
            String outfile = this.outroot + "/agefiles/" + filename;
            byte[] infiledata = FileUtils.ReadFile(infile);
            FileUtils.SaveFileIfChanged(outfile, infiledata, true, true);
        }
        for (String string : sdlfiles) {
            filename = string.substring(string.lastIndexOf("/") + 1);
            if (!string.toLowerCase().equals("/sdl/" + filename.toLowerCase())) continue;
            infile = this.root + "/" + string;
            String outfile = this.outroot + "/sdlfiles/" + filename;
            byte[] infiledata = FileUtils.ReadFile(infile);
            FileUtils.SaveFileIfChanged(outfile, infiledata, true, true);
        }
        byte[] filebs = SerializationUtils.SaveToBytes(this.info);
        FileUtils.SaveFileIfChanged(dataserverfileinfo, filebs, true, true);
        m.status("Done generating the dataserver!");
    }

    public static class mfsfile {
        int format;
        Vector<String> base = new Vector();
        Vector<String> pages = new Vector();
        Vector<String> other = new Vector();

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("[version]\nformat=5\n\n");
            result.append("[base]\n");
            for (String s : this.base) {
                result.append(s);
                result.append("\n");
            }
            result.append("\n");
            result.append("[pages]\n");
            for (String s : this.pages) {
                result.append(s);
                result.append("\n");
            }
            result.append("\n");
            result.append("[other]\n");
            for (String s : this.other) {
                result.append(s);
                result.append("\n");
            }
            return result.toString();
        }

        public byte[] getBytes() {
            return b.StringToBytes(this.toString());
        }
    }

    public static class DataserverInfo
    implements Serializable {
        HashMap<String, DataserverFileInfo> map = new HashMap();

        public static class SfxInfo
        implements Serializable {
            String relpath;
            int flags;
        }

        public static class DataserverFileInfo
        implements Serializable {
            String relpath;
            long filesize;
            long lastmodified;
            byte[] md5;
            HashSet<String> avifiles = new HashSet();
            HashMap<String, SfxInfo> sfxfiles = new HashMap();
            HashSet<String> oneshotmods = new HashSet();
            byte[] compressedmd5;
            long compressedfilesize;
        }
    }

    static enum DataserverType {
        alcugs,
        moul;

    }
}

