/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.event;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.osm.AbstractDataSourceChangeEvent;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class DataSourceAddedEvent
extends AbstractDataSourceChangeEvent {
    private Set<DataSource> current;
    private Set<DataSource> removed;
    private final Set<DataSource> added;

    public DataSourceAddedEvent(DataSet source, Set<DataSource> old, Stream<DataSource> newDataSources) {
        super(source, old);
        CheckParameterUtil.ensureParameterNotNull(newDataSources, "newDataSources");
        this.added = newDataSources.collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public Set<DataSource> getDataSources() {
        if (this.current == null) {
            this.current = new LinkedHashSet<DataSource>(this.getOldDataSources());
            this.current.addAll(this.added);
        }
        return this.current;
    }

    @Override
    public synchronized Set<DataSource> getRemoved() {
        if (this.removed == null) {
            this.removed = this.getOldDataSources().stream().filter(s -> !this.getDataSources().contains(s)).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return this.removed;
    }

    @Override
    public synchronized Set<DataSource> getAdded() {
        return this.added;
    }

    public String toString() {
        return "DataSourceAddedEvent [current=" + this.current + ", removed=" + this.removed + ", added=" + this.added + ']';
    }
}

