/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class FilterField
extends JosmTextField {
    public FilterField() {
        this.setToolTipText(I18n.tr("Enter a search expression", new Object[0]));
        SelectAllOnFocusGainedDecorator.decorate(this);
    }

    public FilterField filter(JTable table, AbstractTableModel model) {
        return this.filter(new TableFilterBehaviour(table, model));
    }

    public FilterField filter(FilterBehaviour behaviour) {
        this.getDocument().addDocumentListener(new FilterFieldAdapter(behaviour));
        return this;
    }

    private static class TableFilterBehaviour
    implements FilterBehaviour {
        private final JTable table;
        private final AbstractTableModel model;

        TableFilterBehaviour(JTable table, AbstractTableModel model) {
            this.table = Objects.requireNonNull(table, "table");
            this.model = Objects.requireNonNull(model, "model");
            Objects.requireNonNull(table.getRowSorter(), "table.rowSorter");
        }

        @Override
        public void filter(String expr) {
            try {
                TableRowSorter sorter = (TableRowSorter)this.table.getRowSorter();
                if (expr == null || expr.isEmpty()) {
                    sorter.setRowFilter(null);
                } else {
                    expr = expr.replace("+", "\\+");
                    List andFilters = Arrays.stream(expr.split("\\s+", -1)).map(word -> RowFilter.regexFilter("(?i)" + word, new int[0])).collect(Collectors.toList());
                    sorter.setRowFilter(RowFilter.andFilter(andFilters));
                }
                this.model.fireTableDataChanged();
            }
            catch (ClassCastException | PatternSyntaxException ex) {
                Logging.warn(ex);
            }
        }
    }

    @FunctionalInterface
    public static interface FilterBehaviour {
        public void filter(String var1);
    }

    private class FilterFieldAdapter
    implements DocumentListener {
        private final FilterBehaviour behaviour;

        FilterFieldAdapter(FilterBehaviour behaviour) {
            this.behaviour = Objects.requireNonNull(behaviour);
        }

        private void filter() {
            this.behaviour.filter(Utils.strip(FilterField.this.getText()));
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.filter();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.filter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.filter();
        }
    }
}

