/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.ListProperty;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.NameFinder;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmJsonReader;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.UncheckedParseException;
import org.openstreetmap.josm.tools.Utils;

public class OverpassDownloadReader
extends BoundingBoxDownloader {
    public static final StringProperty OVERPASS_SERVER = new StringProperty("download.overpass.server", "https://overpass-api.de/api/");
    public static final ListProperty OVERPASS_SERVER_HISTORY = new ListProperty("download.overpass.servers", Arrays.asList("https://overpass-api.de/api/", "http://overpass.openstreetmap.ru/cgi/"));
    public static final BooleanProperty FOR_MULTI_FETCH = new BooleanProperty("download.overpass.for-multi-fetch", false);
    private static final String DATA_PREFIX = "?data=";
    static final Pattern OUTPUT_FORMAT_STATEMENT = Pattern.compile(".*\\[out:([a-z]{3,})\\].*", 32);
    static final Map<OverpassOutputFormat, Class<? extends AbstractReader>> outputFormatReaders = new ConcurrentHashMap<OverpassOutputFormat, Class<? extends AbstractReader>>();
    final String overpassServer;
    final String overpassQuery;

    public OverpassDownloadReader(Bounds downloadArea, String overpassServer, String overpassQuery) {
        super(downloadArea);
        this.setDoAuthenticate(false);
        this.overpassServer = overpassServer;
        this.overpassQuery = overpassQuery.trim();
    }

    public static final Class<? extends AbstractReader> registerOverpassOutputFormatReader(OverpassOutputFormat format, Class<? extends AbstractReader> readerClass) {
        return outputFormatReaders.put(Objects.requireNonNull(format), Objects.requireNonNull(readerClass));
    }

    @Override
    protected String getBaseUrl() {
        return this.overpassServer;
    }

    @Override
    protected String getRequestForBbox(double lon1, double lat1, double lon2, double lat2) {
        if (this.overpassQuery.isEmpty()) {
            return super.getRequestForBbox(lon1, lat1, lon2, lat2);
        }
        String query = this.overpassQuery.replace("{{bbox}}", OverpassDownloadReader.bbox(lon1, lat1, lon2, lat2)).replace("{{center}}", OverpassDownloadReader.center(lon1, lat1, lon2, lat2));
        String expandedOverpassQuery = OverpassDownloadReader.expandExtendedQueries(query);
        return "interpreter?data=" + Utils.encodeUrl(expandedOverpassQuery);
    }

    static String expandExtendedQueries(String query) {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = Pattern.compile("\\{\\{(date|geocodeArea|geocodeBbox|geocodeCoords|geocodeId):([^}]+)\\}\\}").matcher(query);
        block16: while (matcher.find()) {
            try {
                switch (matcher.group(1)) {
                    case "date": {
                        matcher.appendReplacement(sb, OverpassDownloadReader.date(matcher.group(2), LocalDateTime.now(ZoneId.systemDefault())));
                        continue block16;
                    }
                    case "geocodeArea": {
                        matcher.appendReplacement(sb, OverpassDownloadReader.geocodeArea(matcher.group(2)));
                        continue block16;
                    }
                    case "geocodeBbox": {
                        matcher.appendReplacement(sb, OverpassDownloadReader.geocodeBbox(matcher.group(2)));
                        continue block16;
                    }
                    case "geocodeCoords": {
                        matcher.appendReplacement(sb, OverpassDownloadReader.geocodeCoords(matcher.group(2)));
                        continue block16;
                    }
                    case "geocodeId": {
                        matcher.appendReplacement(sb, OverpassDownloadReader.geocodeId(matcher.group(2)));
                        continue block16;
                    }
                }
                Logging.warn("Unsupported syntax: " + matcher.group(1));
            }
            catch (IOException | IndexOutOfBoundsException | NoSuchElementException | UncheckedParseException ex) {
                String msg = I18n.tr("Failed to evaluate {0}", matcher.group());
                Logging.log(Logging.LEVEL_WARN, msg, ex);
                matcher.appendReplacement(sb, "// " + msg + "\n");
            }
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    static String bbox(double lon1, double lat1, double lon2, double lat2) {
        return lat1 + "," + lon1 + "," + lat2 + "," + lon2;
    }

    static String center(double lon1, double lat1, double lon2, double lat2) {
        LatLon c = new BBox(lon1, lat1, lon2, lat2).getCenter();
        return c.lat() + "," + c.lon();
    }

    static String date(String humanDuration, LocalDateTime from) {
        String duration = humanDuration.toLowerCase(Locale.ENGLISH).replace(" ", "").replaceAll("years?", "Y").replaceAll("months?", "X").replaceAll("weeks?", "W").replaceAll("days?", "D").replaceAll("hours?", "H").replaceAll("minutes?", "M").replaceAll("seconds?", "S");
        Matcher matcher = Pattern.compile("((?:[0-9]+Y)?(?:[0-9]+X)?(?:[0-9]+W)?)((?:[0-9]+D)?)((?:[0-9]+H)?(?:[0-9]+M)?(?:[0-9]+(?:[.,][0-9]{0,9})?S)?)?").matcher(duration);
        boolean javaPer = false;
        boolean javaDur = false;
        if (matcher.matches()) {
            javaPer = matcher.group(1) != null && !matcher.group(1).isEmpty();
            javaDur = matcher.group(3) != null && !matcher.group(3).isEmpty();
            duration = 'P' + matcher.group(1).replace('X', 'M') + matcher.group(2);
            if (javaDur) {
                duration = duration + 'T' + matcher.group(3);
            }
        }
        Period p = null;
        Duration d = null;
        int idx = duration.indexOf(84);
        if (javaPer) {
            p = Period.parse(javaDur ? duration.substring(0, idx) : duration);
        }
        if (javaDur) {
            d = Duration.parse(javaPer ? 'P' + duration.substring(idx, duration.length()) : duration);
        } else if (!javaPer) {
            d = Duration.parse(duration);
        }
        LocalDateTime dt = from;
        if (p != null) {
            dt = dt.minus(p);
        }
        if (d != null) {
            dt = dt.minus(d);
        }
        return dt.toInstant(ZoneOffset.UTC).toString();
    }

    private static NameFinder.SearchResult searchName(String area) throws IOException {
        return OverpassDownloadReader.searchName(NameFinder.queryNominatim(area));
    }

    static NameFinder.SearchResult searchName(List<NameFinder.SearchResult> results) {
        return (NameFinder.SearchResult)results.stream().filter(x -> OsmPrimitiveType.NODE != x.getOsmId().getType()).iterator().next();
    }

    static String geocodeArea(String area) throws IOException {
        EnumMap<OsmPrimitiveType, Long> idOffset = new EnumMap<OsmPrimitiveType, Long>(OsmPrimitiveType.class);
        idOffset.put(OsmPrimitiveType.NODE, 0L);
        idOffset.put(OsmPrimitiveType.WAY, 2400000000L);
        idOffset.put(OsmPrimitiveType.RELATION, 3600000000L);
        PrimitiveId osmId = OverpassDownloadReader.searchName(area).getOsmId();
        Logging.debug("Area ''{0}'' resolved to {1}", area, osmId);
        return String.format("area(%d)", osmId.getUniqueId() + (Long)idOffset.get((Object)osmId.getType()));
    }

    static String geocodeBbox(String area) throws IOException {
        Bounds bounds = OverpassDownloadReader.searchName(area).getBounds();
        return bounds.getMinLat() + "," + bounds.getMinLon() + "," + bounds.getMaxLat() + "," + bounds.getMaxLon();
    }

    static String geocodeCoords(String area) throws IOException {
        NameFinder.SearchResult result = OverpassDownloadReader.searchName(area);
        return result.getLat() + "," + result.getLon();
    }

    static String geocodeId(String area) throws IOException {
        PrimitiveId osmId = OverpassDownloadReader.searchName(area).getOsmId();
        return String.format("%s(%d)", osmId.getType().getAPIName(), osmId.getUniqueId());
    }

    @Override
    protected InputStream getInputStreamRaw(String urlStr, ProgressMonitor progressMonitor, String reason, boolean uncompressAccordingToContentDisposition) throws OsmTransferException {
        try {
            int index = urlStr.indexOf(DATA_PREFIX);
            return super.getInputStreamRaw(urlStr.substring(0, index), progressMonitor, reason, uncompressAccordingToContentDisposition, "POST", Utils.decodeUrl(urlStr.substring(index + DATA_PREFIX.length())).getBytes(StandardCharsets.UTF_8));
        }
        catch (OsmApiException ex) {
            String errorPlusRest;
            String errorIndicator = "Error</strong>: ";
            if (ex.getMessage() != null && ex.getMessage().contains("Error</strong>: ") && (errorPlusRest = ex.getMessage().split("Error</strong>: ", -1)[1]) != null) {
                ex.setErrorHeader(errorPlusRest.split("</", -1)[0].replaceAll(".*::request_read_and_idx::", ""));
            }
            throw ex;
        }
    }

    @Override
    protected void adaptRequest(HttpClient request) {
        Matcher timeoutMatcher = Pattern.compile("\\[timeout:(\\d+)\\]").matcher(this.overpassQuery);
        int timeout = timeoutMatcher.find() ? (int)TimeUnit.SECONDS.toMillis(Integer.parseInt(timeoutMatcher.group(1))) : (int)TimeUnit.MINUTES.toMillis(3L);
        request.setConnectTimeout(timeout);
        request.setReadTimeout(timeout);
    }

    @Override
    protected String getTaskName() {
        return I18n.tr("Contacting Server...", new Object[0]);
    }

    @Override
    protected DataSet parseDataSet(InputStream source, ProgressMonitor progressMonitor) throws IllegalDataException {
        Class<? extends AbstractReader> readerClass;
        AbstractReader reader = null;
        Matcher m = OUTPUT_FORMAT_STATEMENT.matcher(this.overpassQuery);
        if (m.matches() && (readerClass = outputFormatReaders.get((Object)OverpassOutputFormat.from(m.group(1)))) != null) {
            try {
                reader = readerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                Logging.error(e);
            }
        }
        if (reader == null) {
            reader = new OverpassOsmReader();
        }
        return ((AbstractReader)reader).doParseDataSet(source, progressMonitor);
    }

    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        DataSet ds = super.parseOsm(progressMonitor);
        if (!this.considerAsFullDownload()) {
            DataSet noBounds = new DataSet();
            DataSetMerger dsm = new DataSetMerger(noBounds, ds);
            dsm.merge(null, false);
            return dsm.getTargetDataSet();
        }
        if (ds != null && ds.getDataSources().isEmpty() && this.overpassQuery.contains("{{bbox}}")) {
            if (this.crosses180th) {
                Bounds bounds = new Bounds(this.lat1, this.lon1, this.lat2, 180.0);
                DataSource src = new DataSource(bounds, this.getBaseUrl());
                ds.addDataSource(src);
                bounds = new Bounds(this.lat1, -180.0, this.lat2, this.lon2);
                src = new DataSource(bounds, this.getBaseUrl());
                ds.addDataSource(src);
            } else {
                Bounds bounds = new Bounds(this.lat1, this.lon1, this.lat2, this.lon2);
                DataSource src = new DataSource(bounds, this.getBaseUrl());
                ds.addDataSource(src);
            }
        }
        return ds;
    }

    public static String fixQuery(String query) {
        return query == null ? query : query.replaceAll("out( body| skel| ids)?( id| qt)?;", "out meta$2;").replaceAll("(?s)\\[out:(csv)[^\\]]*\\]", "[out:xml]");
    }

    @Override
    public boolean considerAsFullDownload() {
        return this.overpassQuery.equals("[out:xml]; \n(\n    node({{bbox}});\n<;\n);\n(._;>;);out meta;");
    }

    static {
        OverpassDownloadReader.registerOverpassOutputFormatReader(OverpassOutputFormat.OSM_XML, OverpassOsmReader.class);
        OverpassDownloadReader.registerOverpassOutputFormatReader(OverpassOutputFormat.OSM_JSON, OverpassOsmJsonReader.class);
    }

    public static enum OverpassOutputFormat {
        OSM_XML("xml"),
        OSM_JSON("json"),
        CSV("csv"),
        CUSTOM("custom"),
        POPUP("popup"),
        PBF("pbf");

        private final String directive;

        private OverpassOutputFormat(String directive) {
            this.directive = directive;
        }

        public String getDirective() {
            return this.directive;
        }

        static OverpassOutputFormat from(String directive) {
            for (OverpassOutputFormat oof : OverpassOutputFormat.values()) {
                if (!oof.directive.equals(directive)) continue;
                return oof;
            }
            throw new IllegalArgumentException(directive);
        }
    }

    static final class OverpassOsmReader
    extends OsmReader {
        OverpassOsmReader() {
        }

        @Override
        protected void parseUnknown(boolean printWarning) throws XMLStreamException {
            String text;
            if ("remark".equals(this.parser.getLocalName()) && this.parser.getEventType() == 1 && (text = this.parser.getElementText()).contains("runtime error")) {
                throw new XMLStreamException(text);
            }
            super.parseUnknown(printWarning);
        }
    }

    static final class OverpassOsmJsonReader
    extends OsmJsonReader {
        OverpassOsmJsonReader() {
        }
    }
}

