/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.TextTagParser;

public final class OsmUtils {
    public static final String TRUE_VALUE = "yes";
    public static final String FALSE_VALUE = "no";
    public static final String REVERSE_VALUE = "-1";
    public static final String trueval = "yes";
    public static final String falseval = "no";
    public static final String reverseval = "-1";

    private OsmUtils() {
    }

    public static Boolean getOsmBoolean(String value) {
        if (value == null) {
            return null;
        }
        String lowerValue = value.toLowerCase(Locale.ENGLISH);
        if (OsmUtils.isTrue(lowerValue)) {
            return Boolean.TRUE;
        }
        if (OsmUtils.isFalse(lowerValue)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static String getNamedOsmBoolean(String value) {
        Boolean res = OsmUtils.getOsmBoolean(value);
        return res == null ? value : (res != false ? "yes" : "no");
    }

    public static boolean isReversed(String value) {
        if (value == null) {
            return false;
        }
        switch (value) {
            case "reverse": 
            case "-1": {
                return true;
            }
        }
        return false;
    }

    public static boolean isTrue(String value) {
        if (value == null) {
            return false;
        }
        switch (value) {
            case "true": 
            case "yes": 
            case "1": 
            case "on": {
                return true;
            }
        }
        return false;
    }

    public static boolean isFalse(String value) {
        if (value == null) {
            return false;
        }
        switch (value) {
            case "false": 
            case "no": 
            case "0": 
            case "off": {
                return true;
            }
        }
        return false;
    }

    public static OsmPrimitive createPrimitive(String assertion) {
        return OsmUtils.createPrimitive(assertion, LatLon.ZERO, false);
    }

    public static OsmPrimitive createPrimitive(String assertion, LatLon around, boolean enforceLocation) {
        Node p;
        CheckParameterUtil.ensureParameterNotNull(assertion, "assertion");
        String[] x = assertion.split("\\s+", 2);
        OsmPrimitive osmPrimitive = "n".equals(x[0]) || "node".equals(x[0]) ? OsmUtils.newNode(around) : ("w".equals(x[0]) || "way".equals(x[0]) || "area".equals(x[0]) ? OsmUtils.newWay(around, enforceLocation) : (p = "r".equals(x[0]) || "relation".equals(x[0]) ? OsmUtils.newRelation(around, enforceLocation) : null));
        if (p == null) {
            throw new IllegalArgumentException("Expecting n/node/w/way/r/relation/area, but got '" + x[0] + "' for assertion '" + assertion + '\'');
        }
        if (x.length > 1) {
            for (Map.Entry<String, String> i : TextTagParser.readTagsFromText(x[1]).entrySet()) {
                p.put(i.getKey(), i.getValue());
            }
        }
        return p;
    }

    private static Node newNode(LatLon around) {
        return new Node(around);
    }

    private static Way newWay(LatLon around, boolean enforceLocation) {
        Way w = new Way();
        if (enforceLocation) {
            w.addNode(OsmUtils.newNode(new LatLon(around.lat() + 0.1, around.lon())));
            w.addNode(OsmUtils.newNode(new LatLon(around.lat() - 0.1, around.lon())));
        }
        return w;
    }

    private static Relation newRelation(LatLon around, boolean enforceLocation) {
        Relation r = new Relation();
        if (enforceLocation) {
            r.addMember(new RelationMember(null, OsmUtils.newNode(around)));
        }
        return r;
    }

    public static String getLayer(IPrimitive w) {
        String layer1 = w.get("layer");
        if ("0".equals(layer1)) {
            layer1 = null;
        }
        return layer1;
    }

    public static boolean isOsmCollectionEditable(Collection<? extends IPrimitive> collection) {
        if (collection == null || collection.isEmpty()) {
            return false;
        }
        OsmData<?, ?, ?, ?> ds = collection.iterator().next().getDataSet();
        return ds == null || !ds.isLocked();
    }

    public static Stream<String> splitMultipleValues(String value) {
        return Pattern.compile("\\s*;\\s*").splitAsStream(value);
    }
}

