/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.AbstractUploadDialog;
import org.openstreetmap.josm.gui.io.BasicUploadSettingsPanel;
import org.openstreetmap.josm.gui.io.ChangesetManagementPanel;
import org.openstreetmap.josm.gui.io.IUploadDialog;
import org.openstreetmap.josm.gui.io.UploadDialogModel;
import org.openstreetmap.josm.gui.io.UploadParameterSummaryPanel;
import org.openstreetmap.josm.gui.io.UploadStrategySelectionPanel;
import org.openstreetmap.josm.gui.io.UploadTextComponentValidator;
import org.openstreetmap.josm.gui.io.UploadedObjectsSummaryPanel;
import org.openstreetmap.josm.gui.tagging.TagEditorPanel;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.MultiLineFlowLayout;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.UploadStrategy;
import org.openstreetmap.josm.io.UploadStrategySpecification;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.PreferenceChangeEvent;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;
import org.openstreetmap.josm.spi.preferences.Setting;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class UploadDialog
extends AbstractUploadDialog
implements PropertyChangeListener,
PreferenceChangedListener {
    private static UploadDialog uploadDialog;
    private UploadedObjectsSummaryPanel pnlUploadedObjects;
    private ChangesetManagementPanel pnlChangesetManagement;
    private BasicUploadSettingsPanel pnlBasicUploadSettings;
    private UploadStrategySelectionPanel pnlUploadStrategySelectionPanel;
    private TitledBorder tagSettingsBorder;
    private JPanel pnlTagEditorBorder;
    private TagEditorPanel pnlTagEditor;
    private JTabbedPane tpConfigPanels;
    private JButton btnUpload;
    private final transient UploadDialogModel model = new UploadDialogModel();
    private transient DataSet dataSet;

    public UploadDialog() {
        super((Window)GuiHelper.getFrameForComponent(MainApplication.getMainFrame()), Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
        this.pack();
    }

    public static synchronized UploadDialog getUploadDialog() {
        if (uploadDialog == null) {
            uploadDialog = new UploadDialog();
        }
        return uploadDialog;
    }

    protected JPanel buildContentPanel() {
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.pnlUploadedObjects = new UploadedObjectsSummaryPanel();
        this.pnlUploadedObjects.setMinimumSize(new Dimension(200, 50));
        splitPane.setLeftComponent(this.pnlUploadedObjects);
        this.tpConfigPanels = new CompactTabbedPane();
        splitPane.setRightComponent(this.tpConfigPanels);
        this.pnlBasicUploadSettings = new BasicUploadSettingsPanel(this.model);
        this.tpConfigPanels.add(this.pnlBasicUploadSettings);
        this.tpConfigPanels.setTitleAt(0, I18n.tr("Description", new Object[0]));
        this.tpConfigPanels.setToolTipTextAt(0, I18n.tr("Describe the changes you made", new Object[0]));
        JPanel pnlSettings = new JPanel(new GridBagLayout());
        this.pnlTagEditorBorder = new JPanel(new BorderLayout());
        this.tagSettingsBorder = BorderFactory.createTitledBorder(I18n.tr("Tags of new changeset", new Object[0]));
        this.pnlTagEditorBorder.setBorder(this.tagSettingsBorder);
        this.pnlTagEditor = new TagEditorPanel(this.model, null, 255);
        this.pnlTagEditorBorder.add((Component)this.pnlTagEditor, "Center");
        this.pnlChangesetManagement = new ChangesetManagementPanel(this.model);
        this.pnlUploadStrategySelectionPanel = new UploadStrategySelectionPanel();
        pnlSettings.add((Component)this.pnlChangesetManagement, GBC.eop().fill(2));
        pnlSettings.add((Component)this.pnlUploadStrategySelectionPanel, GBC.eop().fill(2));
        pnlSettings.add((Component)this.pnlTagEditorBorder, GBC.eol().fill(1));
        this.tpConfigPanels.add(pnlSettings);
        this.tpConfigPanels.setTitleAt(1, I18n.tr("Settings", new Object[0]));
        this.tpConfigPanels.setToolTipTextAt(1, I18n.tr("Decide how to upload the data and which changeset to use", new Object[0]));
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)splitPane, "Center");
        pnl.add((Component)this.buildActionPanel(), "South");
        return pnl;
    }

    protected JPanel buildActionPanel() {
        JPanel pnl = new JPanel(new MultiLineFlowLayout(1));
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.btnUpload = new JButton(new UploadAction(this));
        pnl.add(this.btnUpload);
        this.btnUpload.setFocusable(true);
        InputMapUtils.enableEnter(this.btnUpload);
        InputMapUtils.addCtrlEnterAction(this.getRootPane(), this.btnUpload.getAction());
        CancelAction cancelAction = new CancelAction(this);
        pnl.add(new JButton(cancelAction));
        InputMapUtils.addEscapeAction(this.getRootPane(), cancelAction);
        pnl.add(new JButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Dialog/Upload"))));
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Dialog/Upload"));
        return pnl;
    }

    protected void build() {
        this.setTitle(I18n.tr("Upload to ''{0}''", OsmApi.getOsmApi().getBaseUrl()));
        this.setContentPane(this.buildContentPanel());
        this.addWindowListener(new WindowEventHandler());
        this.pnlChangesetManagement.addPropertyChangeListener(this);
        this.pnlChangesetManagement.addPropertyChangeListener(this.pnlBasicUploadSettings.getUploadParameterSummaryPanel());
        this.pnlUploadedObjects.addPropertyChangeListener(this.pnlUploadStrategySelectionPanel);
        this.pnlUploadedObjects.addPropertyChangeListener(this.pnlBasicUploadSettings.getUploadParameterSummaryPanel());
        this.pnlUploadStrategySelectionPanel.addPropertyChangeListener(this);
        this.pnlUploadStrategySelectionPanel.addPropertyChangeListener(this.pnlBasicUploadSettings.getUploadParameterSummaryPanel());
        this.pnlBasicUploadSettings.getUploadParameterSummaryPanel().setConfigurationParameterRequestListener(() -> this.tpConfigPanels.setSelectedIndex(2));
        this.pnlBasicUploadSettings.getUploadTextValidators().forEach(v -> v.addChangeListener(e -> this.btnUpload.setEnabled(this.pnlBasicUploadSettings.getUploadTextValidators().stream().noneMatch(UploadTextComponentValidator::isUploadRejected))));
        this.setMinimumSize(new Dimension(600, 350));
        Config.getPref().addPreferenceChangeListener(this);
    }

    public void initLifeCycle(DataSet dataSet) {
        HashMap<String, String> map = new HashMap<String, String>();
        this.dataSet = dataSet;
        this.pnlBasicUploadSettings.initLifeCycle(map);
        this.model.clear();
        this.model.putAll(map);
        this.model.putAll(this.dataSet);
    }

    public void setUploadedPrimitives(APIDataSet toUpload) {
        if (toUpload == null) {
            if (this.pnlUploadedObjects != null) {
                List<OsmPrimitive> emptyList = Collections.emptyList();
                this.pnlUploadedObjects.setUploadedPrimitives(emptyList, emptyList, emptyList);
            }
            return;
        }
        this.pnlBasicUploadSettings.setUploadedPrimitives(toUpload.getPrimitives());
        this.pnlUploadedObjects.setUploadedPrimitives(toUpload.getPrimitivesToAdd(), toUpload.getPrimitivesToUpdate(), toUpload.getPrimitivesToDelete());
    }

    public void setFocusToUploadButton() {
        this.btnUpload.requestFocus();
    }

    @Override
    public void rememberUserInput() {
        this.pnlBasicUploadSettings.rememberUserInput();
        this.pnlUploadStrategySelectionPanel.rememberUserInput();
    }

    public void startUserInput() {
        this.tpConfigPanels.setSelectedIndex(0);
        this.pnlBasicUploadSettings.startUserInput();
        this.pnlTagEditor.initAutoCompletion(MainApplication.getLayerManager().getEditLayer());
        this.pnlUploadStrategySelectionPanel.initFromPreferences();
        UploadParameterSummaryPanel pnl = this.pnlBasicUploadSettings.getUploadParameterSummaryPanel();
        pnl.setUploadStrategySpecification(this.pnlUploadStrategySelectionPanel.getUploadStrategySpecification());
        pnl.setCloseChangesetAfterNextUpload(this.pnlChangesetManagement.isCloseChangesetAfterUpload());
        pnl.setNumObjects(this.pnlUploadedObjects.getNumObjectsToUpload());
    }

    public Changeset getChangeset() {
        Changeset cs = Optional.ofNullable(this.pnlChangesetManagement.getSelectedChangeset()).orElseGet(Changeset::new);
        cs.setKeys(this.model.getTags(false));
        return cs;
    }

    public void setSelectedChangesetForNextUpload(Changeset cs) {
        this.pnlChangesetManagement.setSelectedChangesetForNextUpload(cs);
    }

    @Override
    public UploadStrategySpecification getUploadStrategySpecification() {
        UploadStrategySpecification spec = this.pnlUploadStrategySelectionPanel.getUploadStrategySpecification();
        spec.setCloseChangesetAfterUpload(this.pnlChangesetManagement.isCloseChangesetAfterUpload());
        return spec;
    }

    public UploadDialogModel getModel() {
        return this.model;
    }

    @Override
    public String getUploadComment() {
        return this.model.getValue("comment");
    }

    @Override
    public String getUploadSource() {
        return this.model.getValue("source");
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(MainApplication.getMainFrame(), new Dimension(800, 600))).applySafe(this);
            this.startUserInput();
        } else if (this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(visible);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(ChangesetManagementPanel.SELECTED_CHANGESET_PROP)) {
            Changeset cs = (Changeset)evt.getNewValue();
            if (cs == null) {
                this.tagSettingsBorder.setTitle(I18n.tr("Tags of new changeset", new Object[0]));
            } else {
                this.tagSettingsBorder.setTitle(I18n.tr("Tags of changeset {0}", cs.getId()));
            }
        }
    }

    @Override
    public void preferenceChanged(PreferenceChangeEvent e) {
        if (e.getKey() != null && e.getSource() != this.getClass() && e.getSource() != BasicUploadSettingsPanel.class) {
            switch (e.getKey()) {
                case "osm-server.url": {
                    this.osmServerUrlChanged(e.getNewValue());
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    private void osmServerUrlChanged(Setting<?> newValue) {
        String url = newValue == null || newValue.getValue() == null ? OsmApi.getOsmApi().getBaseUrl() : newValue.getValue().toString();
        this.setTitle(I18n.tr("Upload to ''{0}''", url));
    }

    @Override
    public Map<String, String> getTags(boolean keepEmpty) {
        this.saveEdits();
        return this.model.getTags(keepEmpty);
    }

    @Override
    public void handleMissingComment() {
        this.tpConfigPanels.setSelectedIndex(0);
        this.pnlBasicUploadSettings.initEditingOfUploadComment();
    }

    @Override
    public void handleMissingSource() {
        this.tpConfigPanels.setSelectedIndex(0);
        this.pnlBasicUploadSettings.initEditingOfUploadSource();
    }

    @Override
    public void handleIllegalChunkSize() {
        this.tpConfigPanels.setSelectedIndex(0);
    }

    public void saveEdits() {
        this.pnlBasicUploadSettings.saveEdits();
        this.pnlTagEditor.saveEdits();
    }

    public void clean() {
        this.setUploadedPrimitives(null);
        this.dataSet = null;
    }

    static final class CompactTabbedPane
    extends JTabbedPane {
        CompactTabbedPane() {
        }

        @Override
        public Dimension getPreferredSize() {
            super.getPreferredSize();
            return super.getMinimumSize();
        }
    }

    static class UploadAction
    extends AbstractAction {
        private final transient IUploadDialog dialog;

        UploadAction(IUploadDialog dialog) {
            this.dialog = dialog;
            this.putValue("Name", I18n.tr("Upload Changes", new Object[0]));
            new ImageProvider("upload").getResource().attachImageIcon(this, true);
            this.putValue("ShortDescription", I18n.tr("Upload the changed primitives", new Object[0]));
        }

        protected void warnIllegalChunkSize() {
            HelpAwareOptionPane.showOptionDialog((Component)((Object)this.dialog), I18n.tr("Please enter a valid chunk size first", new Object[0]), I18n.tr("Illegal chunk size", new Object[0]), 0, HelpUtil.ht("/Dialog/Upload#IllegalChunkSize"));
        }

        static boolean isUploadCommentTooShort(String comment) {
            String s = Utils.strip(comment);
            if (s.isEmpty()) {
                return true;
            }
            Character.UnicodeBlock block = Character.UnicodeBlock.of(s.charAt(0));
            if (block != null && block.toString().contains("CJK")) {
                return s.length() < 4;
            }
            return s.length() < 10;
        }

        private static String lower(String s) {
            return s.toLowerCase(Locale.ENGLISH);
        }

        static String validateUploadTag(String uploadValue, String preferencePrefix, List<String> defMandatory, List<String> defForbidden, List<String> defException) {
            String uploadValueLc = UploadAction.lower(uploadValue);
            List missingTerms = Config.getPref().getList(preferencePrefix + ".mandatory-terms", defMandatory).stream().map(UploadAction::lower).filter(x -> !uploadValueLc.contains((CharSequence)x)).collect(Collectors.toList());
            if (!missingTerms.isEmpty()) {
                return I18n.tr("The following required terms are missing: {0}", missingTerms);
            }
            List<String> exceptions = Config.getPref().getList(preferencePrefix + ".exception-terms", defException);
            List forbiddenTerms = Config.getPref().getList(preferencePrefix + ".forbidden-terms", defForbidden).stream().map(UploadAction::lower).filter(x -> {
                if (!uploadValueLc.contains((CharSequence)x)) return false;
                if (!exceptions.stream().noneMatch(uploadValueLc::contains)) return false;
                return true;
            }).collect(Collectors.toList());
            if (!forbiddenTerms.isEmpty()) {
                return I18n.tr("The following forbidden terms have been found: {0}", forbiddenTerms);
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Map<String, String> tags = this.dialog.getTags(true);
            Logging.info("Starting upload with tags {0}", tags);
            ArrayList<String> emptyChangesetTags = new ArrayList<String>();
            for (Map.Entry<String, String> i : tags.entrySet()) {
                boolean ignoreKey;
                boolean isKeyEmpty = Utils.isStripEmpty(i.getKey());
                boolean isValueEmpty = Utils.isStripEmpty(i.getValue());
                boolean bl = ignoreKey = "comment".equals(i.getKey()) || "source".equals(i.getKey());
                if (!(isKeyEmpty ^ isValueEmpty) || ignoreKey) continue;
                emptyChangesetTags.add(I18n.tr("{0}={1}", i.getKey(), i.getValue()));
            }
            if (!emptyChangesetTags.isEmpty() && 0 != JOptionPane.showConfirmDialog(MainApplication.getMainFrame(), I18n.trn("<html>The following changeset tag contains an empty key/value:<br>{0}<br>Continue?</html>", "<html>The following changeset tags contain an empty key/value:<br>{0}<br>Continue?</html>", emptyChangesetTags.size(), Utils.joinAsHtmlUnorderedList(emptyChangesetTags)), I18n.tr("Empty metadata", new Object[0]), 2, 2)) {
                this.dialog.handleMissingComment();
                return;
            }
            UploadStrategySpecification strategy = this.dialog.getUploadStrategySpecification();
            if (strategy.getStrategy() == UploadStrategy.CHUNKED_DATASET_STRATEGY && strategy.getChunkSize() == -1) {
                this.warnIllegalChunkSize();
                this.dialog.handleIllegalChunkSize();
                return;
            }
            if (this.dialog instanceof AbstractUploadDialog) {
                ((AbstractUploadDialog)this.dialog).setCanceled(false);
                ((AbstractUploadDialog)this.dialog).setVisible(false);
            }
        }
    }

    static class CancelAction
    extends AbstractAction {
        private final transient IUploadDialog dialog;

        CancelAction(IUploadDialog dialog) {
            this.dialog = dialog;
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            new ImageProvider("cancel").getResource().attachImageIcon(this, true);
            this.putValue("ShortDescription", I18n.tr("Cancel the upload and resume editing", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.dialog instanceof AbstractUploadDialog) {
                ((AbstractUploadDialog)this.dialog).setCanceled(true);
                ((AbstractUploadDialog)this.dialog).setVisible(false);
            }
        }
    }

    class WindowEventHandler
    extends WindowAdapter {
        private boolean activatedOnce;

        WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            UploadDialog.this.setCanceled(true);
        }

        @Override
        public void windowActivated(WindowEvent e) {
            if (!this.activatedOnce && UploadDialog.this.tpConfigPanels.getSelectedIndex() == 0) {
                UploadDialog.this.pnlBasicUploadSettings.initEditingOfUploadComment();
                this.activatedOnce = true;
            }
        }
    }
}

