/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.tools.Utils;

public class LayerDetails {
    private final Map<String, String> styles = new ConcurrentHashMap<String, String>();
    private final Collection<String> crs = new ArrayList<String>();
    private String title;
    private String name;
    private String abstr;
    private final LayerDetails parentLayer;
    private Bounds bounds;
    private List<LayerDetails> children = new ArrayList<LayerDetails>();

    public LayerDetails(LayerDetails parentLayer) {
        this.parentLayer = parentLayer;
    }

    public Collection<String> getCrs() {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.parentLayer != null) {
            ret.addAll(this.parentLayer.getCrs());
        }
        ret.addAll(this.crs);
        return ret;
    }

    public Map<String, String> getStyles() {
        ConcurrentHashMap<String, String> ret = new ConcurrentHashMap<String, String>();
        if (this.parentLayer != null) {
            ret.putAll(this.parentLayer.getStyles());
        }
        ret.putAll(this.styles);
        return ret;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addStyle(String name, String title) {
        this.styles.put(name, title == null ? "" : title);
    }

    public void addCrs(String crs) {
        this.crs.add(crs);
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public void setBounds(Bounds bounds) {
        this.bounds = bounds;
    }

    public String toString() {
        String baseName = Utils.isEmpty(this.title) ? this.name : this.title;
        return this.abstr == null || this.abstr.equalsIgnoreCase(baseName) ? baseName : baseName + " (" + this.abstr + ')';
    }

    public LayerDetails getParent() {
        return this.parentLayer;
    }

    public void setChildren(List<LayerDetails> children) {
        this.children = children;
    }

    public List<LayerDetails> getChildren() {
        return this.children;
    }

    public boolean isSelectable() {
        return !Utils.isEmpty(this.name);
    }

    public String getAbstract() {
        return this.abstr;
    }

    public void setAbstract(String abstr) {
        this.abstr = abstr;
    }

    public Stream<LayerDetails> flattened() {
        return Stream.concat(Stream.of(this), this.getChildren().stream().flatMap(LayerDetails::flattened));
    }
}

