/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.coor;

import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.Projecting;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public interface ILatLon {
    public static final double MAX_SERVER_PRECISION = 1.0E-7;

    public double lon();

    public double lat();

    default public boolean isLatLonKnown() {
        return !Double.isNaN(this.lat()) && !Double.isNaN(this.lon());
    }

    default public EastNorth getEastNorth(Projecting projecting) {
        if (!this.isLatLonKnown()) {
            return null;
        }
        return projecting.latlon2eastNorth(this);
    }

    default public boolean equalsEpsilon(ILatLon other) {
        return this.equalsEpsilon(other, 1.0E-7);
    }

    default public boolean equalsEpsilon(ILatLon other, double precision) {
        double p = precision / 2.0;
        return Math.abs(this.lat() - other.lat()) <= p && Math.abs(this.lon() - other.lon()) <= p;
    }

    default public double greatCircleDistance(ILatLon other) {
        double sinHalfLat = Math.sin(Utils.toRadians(other.lat() - this.lat()) / 2.0);
        double sinHalfLon = Math.sin(Utils.toRadians(other.lon() - this.lon()) / 2.0);
        double d = 2.0 * Ellipsoid.WGS84.a * Math.asin(Math.sqrt(sinHalfLat * sinHalfLat + Math.cos(Utils.toRadians(this.lat())) * Math.cos(Utils.toRadians(other.lat())) * sinHalfLon * sinHalfLon));
        if (Double.isNaN(d)) {
            Logging.error("NaN in greatCircleDistance: {0} {1}", this, other);
            d = Math.PI * Ellipsoid.WGS84.a;
        }
        return d;
    }

    default public double bearing(ILatLon other) {
        double lat1 = Utils.toRadians(this.lat());
        double lat2 = Utils.toRadians(other.lat());
        double dlon = Utils.toRadians(other.lon() - this.lon());
        double bearing = Math.atan2(Math.sin(dlon) * Math.cos(lat2), Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(dlon));
        if ((bearing %= Math.PI * 2) < 0.0) {
            bearing += Math.PI * 2;
        }
        return bearing;
    }
}

