/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.draw;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.osm.visitor.paint.OffsetIterator;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.draw.MapPath2D;
import org.openstreetmap.josm.gui.draw.SymbolShape;

public class MapViewPath
extends MapPath2D {
    private final MapViewState state;

    public MapViewPath(MapView mv) {
        this(mv.getState());
    }

    public MapViewPath(MapViewState state) {
        this.state = state;
    }

    public MapViewState getMapViewState() {
        return this.state;
    }

    public MapViewPath moveTo(ILatLon n) {
        this.moveTo(n.getEastNorth(this.state.getProjecting()));
        return this;
    }

    public MapViewPath moveTo(EastNorth eastNorth) {
        this.moveTo(this.state.getPointFor(eastNorth));
        return this;
    }

    @Override
    public MapViewPath moveTo(MapViewState.MapViewPoint p) {
        super.moveTo(p);
        return this;
    }

    public MapViewPath lineTo(ILatLon n) {
        this.lineTo(n.getEastNorth(this.state.getProjecting()));
        return this;
    }

    public MapViewPath lineTo(EastNorth eastNorth) {
        this.lineTo(this.state.getPointFor(eastNorth));
        return this;
    }

    @Override
    public MapViewPath lineTo(MapViewState.MapViewPoint p) {
        super.lineTo(p);
        return this;
    }

    public MapViewPath shapeAround(ILatLon p1, SymbolShape symbol, double size) {
        this.shapeAround(p1.getEastNorth(this.state.getProjecting()), symbol, size);
        return this;
    }

    public MapViewPath shapeAround(EastNorth eastNorth, SymbolShape symbol, double size) {
        this.shapeAround(this.state.getPointFor(eastNorth), symbol, size);
        return this;
    }

    @Override
    public MapViewPath shapeAround(MapViewState.MapViewPoint p, SymbolShape symbol, double size) {
        super.shapeAround(p, symbol, size);
        return this;
    }

    public MapViewPath append(Iterable<? extends ILatLon> nodes, boolean connect) {
        this.appendWay(nodes, connect, false);
        return this;
    }

    public MapViewPath appendClosed(Iterable<? extends ILatLon> nodes, boolean connect) {
        this.appendWay(nodes, connect, true);
        return this;
    }

    private void appendWay(Iterable<? extends ILatLon> nodes, boolean connect, boolean close) {
        boolean useMoveTo = !connect;
        for (ILatLon iLatLon : nodes) {
            if (useMoveTo) {
                this.moveTo(iLatLon);
            } else {
                this.lineTo(iLatLon);
            }
            useMoveTo = false;
        }
        if (close) {
            this.closePath();
        }
    }

    public void appendFromEastNorth(Path2D.Double path) {
        new PathVisitor(){

            @Override
            public void visitMoveTo(double x, double y) {
                MapViewPath.this.moveTo(new EastNorth(x, y));
            }

            @Override
            public void visitLineTo(double x, double y) {
                MapViewPath.this.lineTo(new EastNorth(x, y));
            }

            @Override
            public void visitClose() {
                MapViewPath.this.closePath();
            }
        }.visit(path);
    }

    public double visitLine(PathSegmentConsumer consumer) {
        LineVisitor visitor = new LineVisitor(consumer);
        visitor.visit(this);
        return visitor.inLineOffset;
    }

    public Shape computeClippedLine(Stroke stroke) {
        MapPath2D clamped = new MapPath2D();
        if (this.visitClippedLine(stroke, (double inLineOffset, MapViewState.MapViewPoint start, MapViewState.MapViewPoint end, boolean startIsOldEnd) -> {
            if (!startIsOldEnd) {
                clamped.moveTo(start);
            }
            clamped.lineTo(end);
        })) {
            return clamped;
        }
        return this;
    }

    public boolean visitClippedLine(Stroke stroke, PathSegmentConsumer consumer) {
        if (stroke instanceof BasicStroke && ((BasicStroke)stroke).getDashArray() != null) {
            float length = 0.0f;
            for (float f : ((BasicStroke)stroke).getDashArray()) {
                length += f;
            }
            return this.visitClippedLine(length, consumer);
        }
        return this.visitClippedLine(0.0, consumer);
    }

    public boolean visitClippedLine(double strokeLength, PathSegmentConsumer consumer) {
        return new ClampingPathVisitor(this.state.getViewClipRectangle(), strokeLength, consumer).visit(this);
    }

    public double getLength() {
        return this.visitLine((inLineOffset, start, end, startIsOldEnd) -> {});
    }

    public MapViewPath offset(double viewOffset) {
        OffsetPathVisitor visitor = new OffsetPathVisitor(this.state, viewOffset);
        visitor.visit(this);
        return visitor.getPath();
    }

    private final class LineVisitor
    extends AbstractMapPathVisitor {
        private final PathSegmentConsumer consumer;
        private MapViewState.MapViewPoint last;
        private double inLineOffset;
        private boolean startIsOldEnd;

        LineVisitor(PathSegmentConsumer consumer) {
            this.consumer = consumer;
        }

        @Override
        void visitMoveTo(MapViewState.MapViewPoint p) {
            this.last = p;
            this.startIsOldEnd = false;
        }

        @Override
        void visitLineTo(MapViewState.MapViewPoint p) {
            this.consumer.addLineBetween(this.inLineOffset, this.last, p, this.startIsOldEnd);
            this.inLineOffset += this.last.distanceToInView(p);
            this.last = p;
            this.startIsOldEnd = true;
        }
    }

    @FunctionalInterface
    public static interface PathSegmentConsumer {
        public void addLineBetween(double var1, MapViewState.MapViewPoint var3, MapViewState.MapViewPoint var4, boolean var5);
    }

    private class ClampingPathVisitor
    extends AbstractMapPathVisitor {
        private final MapViewState.MapViewRectangle clip;
        private final PathSegmentConsumer consumer;
        protected double strokeProgress;
        private final double strokeLength;
        private MapViewState.MapViewPoint cursor;
        private boolean cursorIsActive;

        ClampingPathVisitor(MapViewState.MapViewRectangle clip, double strokeLength, PathSegmentConsumer consumer) {
            this.clip = clip;
            this.strokeLength = strokeLength;
            this.consumer = consumer;
        }

        @Override
        void visitMoveTo(MapViewState.MapViewPoint point) {
            this.cursor = point;
            this.cursorIsActive = false;
        }

        @Override
        void visitLineTo(MapViewState.MapViewPoint next) {
            MapViewState.MapViewPoint entry = this.clip.getLineEntry(this.cursor, next);
            if (entry != null) {
                MapViewState.MapViewPoint exit = this.clip.getLineEntry(next, this.cursor);
                if (!this.cursorIsActive || !entry.equals(this.cursor)) {
                    entry = this.alignStrokeOffset(entry, this.cursor);
                }
                this.consumer.addLineBetween(this.strokeProgress + this.cursor.distanceToInView(entry), entry, exit, this.cursorIsActive);
                this.cursorIsActive = exit.equals(next);
            }
            this.strokeProgress += this.cursor.distanceToInView(next);
            this.cursor = next;
        }

        private MapViewState.MapViewPoint alignStrokeOffset(MapViewState.MapViewPoint entry, MapViewState.MapViewPoint originalStart) {
            double distanceSq = entry.distanceToInViewSq(originalStart);
            if (distanceSq < 0.01 || this.strokeLength <= 0.001) {
                return entry;
            }
            double distance = Math.sqrt(distanceSq);
            double offset = (this.strokeProgress + distance) % this.strokeLength;
            if (offset < 0.01) {
                return entry;
            }
            return entry.interpolate(originalStart, offset / distance);
        }
    }

    private class OffsetPathVisitor
    extends AbstractMapPathVisitor {
        private final MapViewPath collector;
        private final ArrayList<MapViewState.MapViewPoint> points;
        private final double offset;

        OffsetPathVisitor(MapViewState state, double offset) {
            this.points = new ArrayList();
            this.collector = new MapViewPath(state);
            this.offset = offset;
        }

        @Override
        void visitMoveTo(MapViewState.MapViewPoint p) {
            this.finishLineSegment();
            this.points.add(p);
        }

        @Override
        void visitLineTo(MapViewState.MapViewPoint p) {
            this.points.add(p);
        }

        MapViewPath getPath() {
            this.finishLineSegment();
            return this.collector;
        }

        private void finishLineSegment() {
            if (this.points.size() > 2) {
                OffsetIterator iterator = new OffsetIterator(this.points, this.offset);
                this.collector.moveTo(iterator.next());
                while (iterator.hasNext()) {
                    this.collector.lineTo(iterator.next());
                }
                this.points.clear();
            }
        }
    }

    private abstract class AbstractMapPathVisitor
    implements PathVisitor {
        private MapViewState.MapViewPoint lastMoveTo;

        private AbstractMapPathVisitor() {
        }

        @Override
        public void visitMoveTo(double x, double y) {
            MapViewState.MapViewPoint move;
            this.lastMoveTo = move = MapViewPath.this.state.getForView(x, y);
            this.visitMoveTo(move);
        }

        abstract void visitMoveTo(MapViewState.MapViewPoint var1);

        @Override
        public void visitLineTo(double x, double y) {
            this.visitLineTo(MapViewPath.this.state.getForView(x, y));
        }

        abstract void visitLineTo(MapViewState.MapViewPoint var1);

        @Override
        public void visitClose() {
            this.visitLineTo(this.lastMoveTo);
        }
    }

    private static interface PathVisitor {
        default public boolean visit(Path2D.Double path) {
            double[] coords = new double[8];
            PathIterator it = path.getPathIterator(null);
            while (!it.isDone()) {
                int type = it.currentSegment(coords);
                switch (type) {
                    case 4: {
                        this.visitClose();
                        break;
                    }
                    case 1: {
                        this.visitLineTo(coords[0], coords[1]);
                        break;
                    }
                    case 0: {
                        this.visitMoveTo(coords[0], coords[1]);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                it.next();
            }
            return true;
        }

        public void visitClose();

        public void visitMoveTo(double var1, double var3);

        public void visitLineTo(double var1, double var3);
    }
}

