/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.widgets.JosmEditorPane;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Utils;

public class UrlLabel
extends JLabel
implements MouseListener {
    private String url = "";
    private String description = "";

    public UrlLabel() {
        this.init("", "", 0);
    }

    public UrlLabel(String url) {
        this(url, url, 0);
    }

    public UrlLabel(String url, int fontPlus) {
        this(url, url, fontPlus);
    }

    public UrlLabel(String url, String description) {
        this(url, description, 0);
    }

    public UrlLabel(String url, String description, Icon image) {
        super(image);
        this.init(url, description, 0);
    }

    public UrlLabel(String url, String description, int fontPlus) {
        this.init(url, description, fontPlus);
    }

    private void init(String url, String description, int fontPlus) {
        this.addMouseListener(this);
        this.setUrl(url);
        this.setDescription(description);
        if (fontPlus != 0) {
            this.setFont(this.getFont().deriveFont(0, (float)this.getFont().getSize() + (float)fontPlus));
        }
        this.refresh();
    }

    protected final void refresh() {
        if (!Utils.isEmpty(this.url)) {
            this.refresh("<html><a color=\"" + JosmEditorPane.getLinkColor() + "\" href=\"" + this.url + "\">" + this.description + "</a></html>", Cursor.getPredefinedCursor(12), String.format("<html>%s<br/>%s</html>", this.url, I18n.tr("Right click = copy to clipboard", new Object[0])));
        } else {
            this.refresh("<html>" + this.description + "</html>", null, null);
        }
    }

    private void refresh(String text, Cursor cursor, String tooltip) {
        boolean hasImage;
        boolean bl = hasImage = this.getIcon() != null;
        if (!hasImage) {
            this.setText(text);
        }
        this.setCursor(cursor);
        this.setToolTipText(tooltip);
    }

    public final void setUrl(String url) {
        this.url = url;
        this.refresh();
    }

    public final void setDescription(String description) {
        this.setDescription(description, true);
    }

    public final void setDescription(String description, boolean escapeReservedCharacters) {
        String string = this.description = description == null ? "" : description;
        if (escapeReservedCharacters) {
            this.description = Utils.escapeReservedCharactersHTML(this.description);
        }
        this.refresh();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!Utils.isEmpty(this.url)) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                OpenBrowser.displayUrl(this.url);
            } else if (SwingUtilities.isRightMouseButton(e)) {
                ClipboardUtils.copyString(this.url);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

