/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelationMember;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.tools.Utils;

public interface IRelation<M extends IRelationMember<?>>
extends IPrimitive {
    public int getMembersCount();

    default public boolean isEmpty() {
        return this.getMembersCount() == 0;
    }

    public M getMember(int var1);

    public List<M> getMembers();

    public void setMembers(List<M> var1);

    public long getMemberId(int var1);

    public String getRole(int var1);

    public OsmPrimitiveType getMemberType(int var1);

    default public boolean hasIncompleteMembers() {
        return false;
    }

    @Override
    default public int compareTo(IPrimitive o) {
        return o instanceof IRelation ? Long.compare(this.getUniqueId(), o.getUniqueId()) : -1;
    }

    @Override
    default public String getDisplayName(NameFormatter formatter) {
        return formatter.format(this);
    }

    default public boolean isBoundary() {
        return "boundary".equals(this.get("type"));
    }

    @Override
    default public boolean isMultipolygon() {
        return "multipolygon".equals(this.get("type")) || this.isBoundary();
    }

    default public List<? extends IPrimitive> getMemberPrimitivesList() {
        return Utils.transform(this.getMembers(), IRelationMember::getMember);
    }

    @Override
    default public List<? extends IPrimitive> getChildren() {
        return this.getMemberPrimitivesList();
    }

    default public Collection<? extends IPrimitive> getIncompleteMembers() {
        return this.getMembers().stream().filter(rm -> rm.getMember().isIncomplete()).map(rm -> rm.getMember()).collect(Collectors.toSet());
    }

    default public List<? extends IPrimitive> findRelationMembers(String role) {
        return this.getMembers().stream().filter(rmv -> role.equals(rmv.getRole())).map(IRelationMember::getMember).collect(Collectors.toList());
    }

    default public boolean isUseful() {
        return !this.isEmpty() && this.hasKeys();
    }
}

