/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.draw;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.Optional;
import java.util.stream.Stream;
import org.openstreetmap.josm.tools.GuiSizesHelper;

public enum SymbolShape {
    SQUARE("square", 4, 0.7853981633974483),
    CIRCLE("circle", 1, 0.0),
    TRIANGLE("triangle", 3, 1.5707963267948966),
    PENTAGON("pentagon", 5, 1.5707963267948966),
    HEXAGON("hexagon", 6, 0.0),
    HEPTAGON("heptagon", 7, 1.5707963267948966),
    OCTAGON("octagon", 8, 0.39269908169872414),
    NONAGON("nonagon", 9, 1.5707963267948966),
    DECAGON("decagon", 10, 0.0);

    private final String name;
    final int sides;
    final double rotation;

    private SymbolShape(String name, int sides, double rotation) {
        this.name = name;
        this.sides = sides;
        this.rotation = rotation;
    }

    public Shape shapeAround(double x, double y, double size) {
        Shape shape;
        size = GuiSizesHelper.getSizeDpiAdjusted(size);
        double radius = size / 2.0;
        switch (this.ordinal()) {
            case 0: {
                shape = new Rectangle2D.Double(x - radius, y - radius, size, size);
                break;
            }
            case 1: {
                shape = new Ellipse2D.Double(x - radius, y - radius, size, size);
                break;
            }
            default: {
                shape = this.buildPolygon(x, y, radius);
            }
        }
        return shape;
    }

    private Shape buildPolygon(double cx, double cy, double radius) {
        GeneralPath polygon = new GeneralPath();
        for (int i = 0; i < this.sides; ++i) {
            double angle = Math.PI * 2 / (double)this.sides * (double)i - this.rotation;
            double x = cx + radius * Math.cos(angle);
            double y = cy + radius * Math.sin(angle);
            if (i == 0) {
                polygon.moveTo(x, y);
                continue;
            }
            polygon.lineTo(x, y);
        }
        polygon.closePath();
        return polygon;
    }

    public int getSides() {
        return this.sides;
    }

    public double getRotation() {
        return this.rotation;
    }

    public String getName() {
        return this.name;
    }

    public static Optional<SymbolShape> forName(String val) {
        return Stream.of(SymbolShape.values()).filter(shape -> val.equals(shape.name)).findAny();
    }
}

