/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadParams;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryDataSetListener;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.UrlPatterns;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.SAXException;

public class DownloadOsmChangeTask
extends DownloadOsmTask {
    @Override
    public String[] getPatterns() {
        return DownloadOsmChangeTask.patterns(UrlPatterns.OsmChangeUrlPattern.class);
    }

    @Override
    public String getTitle() {
        return I18n.tr("Download OSM Change", new Object[0]);
    }

    @Override
    public Future<?> download(DownloadParams settings, Bounds downloadArea, ProgressMonitor progressMonitor) {
        return null;
    }

    @Override
    public Future<?> loadUrl(DownloadParams settings, String url, ProgressMonitor progressMonitor) {
        Optional<UrlPatterns.OsmChangeUrlPattern> urlPattern = Arrays.stream(UrlPatterns.OsmChangeUrlPattern.values()).filter(p -> p.matches(url)).findFirst();
        Object newUrl = url;
        Matcher matcher = UrlPatterns.OsmChangeUrlPattern.OSM_WEBSITE.matcher(url);
        if (matcher.matches()) {
            newUrl = OsmApi.getOsmApi().getBaseUrl() + "changeset/" + Long.parseLong(matcher.group(2)) + "/download";
        }
        this.downloadTask = new DownloadTask(settings, (OsmServerReader)new OsmServerLocationReader((String)newUrl), progressMonitor, true, Compression.byExtension((String)newUrl));
        this.extractOsmFilename(settings, urlPattern.orElse(UrlPatterns.OsmChangeUrlPattern.EXTERNAL_OSC_FILE).pattern(), (String)newUrl);
        return MainApplication.worker.submit(this.downloadTask);
    }

    private static Map<OsmPrimitive, Instant> getToLoad(DataSet ds) {
        HashMap<OsmPrimitive, Instant> toLoad = new HashMap<OsmPrimitive, Instant>();
        for (OsmPrimitive p : ds.allNonDeletedPrimitives()) {
            if (!p.isIncomplete()) continue;
            Instant timestamp = p.getReferrers().stream().filter(ref -> !ref.isTimestampEmpty()).findFirst().map(AbstractPrimitive::getInstant).orElse(null);
            toLoad.put(p, timestamp);
        }
        return toLoad;
    }

    protected class DownloadTask
    extends DownloadOsmTask.DownloadTask {
        public DownloadTask(DownloadParams settings, OsmServerReader reader, ProgressMonitor progressMonitor, boolean zoomAfterDownload, Compression compression) {
            super(DownloadOsmChangeTask.this, settings, reader, progressMonitor, zoomAfterDownload, compression);
        }

        @Override
        protected DataSet parseDataSet() throws OsmTransferException {
            return this.reader.parseOsmChange(this.progressMonitor.createSubTaskMonitor(-1, false), this.compression);
        }

        @Override
        public void realRun() throws IOException, SAXException, OsmTransferException {
            super.realRun();
            HashMap<OsmPrimitive, Instant> toLoadNext = new HashMap<OsmPrimitive, Instant>();
            Map<OsmPrimitive, Instant> toLoad = DownloadOsmChangeTask.getToLoad(this.dataSet);
            while (!toLoad.isEmpty()) {
                this.loadLastVersions(toLoad, toLoadNext);
                toLoad.putAll(toLoadNext);
                toLoadNext.clear();
            }
        }

        private void loadLastVersions(Map<OsmPrimitive, Instant> toLoad, Map<OsmPrimitive, Instant> toLoadNext) throws OsmTransferException {
            Map<OsmPrimitiveType, Map<OsmPrimitive, Instant>> typeMap = toLoad.entrySet().stream().collect(Collectors.groupingBy(entry -> ((OsmPrimitive)entry.getKey()).getType(), Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            Map idMap = toLoad.keySet().stream().collect(Collectors.toMap(IPrimitive::getPrimitiveId, Function.identity()));
            block5: for (OsmPrimitiveType type : Arrays.asList(OsmPrimitiveType.NODE, OsmPrimitiveType.WAY, OsmPrimitiveType.RELATION)) {
                if (!typeMap.containsKey((Object)type)) continue;
                MultiFetchServerObjectReader reader = MultiFetchServerObjectReader.create();
                typeMap.get((Object)type).forEach((primitive, instant) -> reader.append((OsmPrimitive)primitive));
                DataSet ds = reader.parseOsm(this.progressMonitor.createSubTaskMonitor(1, false));
                switch (type) {
                    case NODE: {
                        OsmPrimitive original;
                        for (Node node : ds.getNodes()) {
                            original = (Node)idMap.get(node.getPrimitiveId());
                            if (original != null && toLoad.get(original).isAfter(node.getInstant())) {
                                ((Node)original).load(node.save());
                            }
                            toLoad.remove(original);
                        }
                        continue block5;
                    }
                    case WAY: {
                        OsmPrimitive original;
                        for (Way way : ds.getWays()) {
                            original = (Way)idMap.get(way.getPrimitiveId());
                            if (original != null && toLoad.get(original).isAfter(way.getInstant())) {
                                Instant date = toLoad.get(original);
                                ((Way)original).load(way.save());
                                for (Long nodeId : way.getNodeIds()) {
                                    if (way.getDataSet().getPrimitiveById(nodeId, OsmPrimitiveType.NODE) != null) continue;
                                    Node n = new Node(nodeId);
                                    way.getDataSet().addPrimitive(n);
                                    toLoadNext.put(n, date);
                                }
                            }
                            toLoad.remove(original);
                        }
                        continue block5;
                    }
                    case RELATION: {
                        OsmPrimitive original;
                        for (Relation relation : ds.getRelations()) {
                            original = (Relation)idMap.get(relation.getPrimitiveId());
                            if (original != null && toLoad.get(original).isAfter(relation.getInstant())) {
                                ((Relation)original).load(relation.save());
                            }
                            toLoad.remove(relation);
                        }
                        continue block5;
                    }
                    default: {
                        throw new IllegalStateException("Only Node, Ways, and Relations should be returned by the API");
                    }
                }
            }
        }

        @Override
        protected void finish() {
            super.finish();
            if (DownloadOsmChangeTask.this.isFailed() || DownloadOsmChangeTask.this.isCanceled() || DownloadOsmChangeTask.this.downloadedData == null) {
                return;
            }
            try {
                Map<OsmPrimitive, Instant> toLoad = DownloadOsmChangeTask.getToLoad((DataSet)DownloadOsmChangeTask.this.downloadedData);
                if (DownloadOsmChangeTask.this.isCanceled()) {
                    return;
                }
                MainApplication.worker.submit(new HistoryLoaderAndListener(toLoad));
            }
            catch (RejectedExecutionException e) {
                DownloadOsmChangeTask.this.rememberException(e);
                DownloadOsmChangeTask.this.setFailed(true);
            }
        }
    }

    private static final class HistoryLoaderAndListener
    extends HistoryLoadTask
    implements HistoryDataSetListener {
        private final Map<OsmPrimitive, Instant> toLoad;

        private HistoryLoaderAndListener(Map<OsmPrimitive, Instant> toLoad) {
            this.toLoad = toLoad;
            this.setChangesetDataNeeded(false);
            this.addOsmPrimitives(toLoad.keySet());
            HistoryDataSet.getInstance().addHistoryDataSetListener(this);
        }

        @Override
        public void historyUpdated(HistoryDataSet source, PrimitiveId id) {
            HashMap<OsmPrimitive, Instant> toLoadNext = new HashMap<OsmPrimitive, Instant>();
            Iterator<Map.Entry<OsmPrimitive, Instant>> it = this.toLoad.entrySet().iterator();
            while (it.hasNext()) {
                PrimitiveData data;
                HistoryOsmPrimitive hp;
                Map.Entry<OsmPrimitive, Instant> entry = it.next();
                OsmPrimitive p = entry.getKey();
                History history = source.getHistory(p.getPrimitiveId());
                Instant date = entry.getValue();
                if (history == null || date == null || (hp = history.getByDate(date)) == null) continue;
                switch (p.getType()) {
                    case NODE: {
                        data = ((HistoryNode)hp).fillPrimitiveData(new NodeData());
                        break;
                    }
                    case WAY: {
                        data = ((HistoryWay)hp).fillPrimitiveData(new WayData());
                        for (Long nodeId : ((HistoryWay)hp).getNodes()) {
                            if (p.getDataSet().getPrimitiveById(nodeId, OsmPrimitiveType.NODE) != null) continue;
                            Node n = new Node(nodeId);
                            p.getDataSet().addPrimitive(n);
                            toLoadNext.put(n, date);
                        }
                        break;
                    }
                    case RELATION: {
                        data = ((HistoryRelation)hp).fillPrimitiveData(new RelationData());
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Unknown primitive type");
                    }
                }
                try {
                    p.load(data);
                    it.remove();
                }
                catch (AssertionError e) {
                    Logging.log(Logging.LEVEL_ERROR, "Cannot load " + String.valueOf(p) + ":", (Throwable)((Object)e));
                }
            }
            source.removeHistoryDataSetListener(this);
            if (toLoadNext.isEmpty()) {
                MainApplication.getMap().repaint();
            } else {
                MainApplication.worker.submit(new HistoryLoaderAndListener(toLoadNext));
            }
        }

        @Override
        public void historyDataSetCleared(HistoryDataSet source) {
        }
    }
}

