/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol;

import jakarta.json.Json;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.AddNodeHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.AddWayHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.AuthorizationHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.FeaturesHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.ImageryHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.ImportHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.LoadAndZoomHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.LoadDataHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.LoadObjectHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.OpenApiHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.OpenFileHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.VersionHandler;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class RequestProcessor
extends Thread {
    private static final ReentrantLock ORDER_LOCK = new ReentrantLock(true);
    private static final Charset RESPONSE_CHARSET = StandardCharsets.UTF_8;
    private static final String RESPONSE_TEMPLATE = "<!DOCTYPE html><html><head><meta charset=\"" + RESPONSE_CHARSET.name() + "\">%s</head><body>%s</body></html>";
    public static final String JOSM_REMOTE_CONTROL = "JOSM RemoteControl";
    public static final String PROTOCOLVERSION = Json.createObjectBuilder().add("protocolversion", Json.createObjectBuilder().add("major", 1).add("minor", 12)).add("application", "JOSM RemoteControl").add("version", Version.getInstance().getVersion()).build().toString();
    private final Socket request;
    private static final Map<String, Class<? extends RequestHandler>> handlers = new TreeMap<String, Class<? extends RequestHandler>>();

    public RequestProcessor(Socket request) {
        super("RemoteControl request processor");
        this.setDaemon(true);
        this.request = Objects.requireNonNull(request);
    }

    public static void processRequest(Socket request) {
        new RequestProcessor(request).start();
    }

    public static void addRequestHandlerClass(String command, Class<? extends RequestHandler> handler) {
        RequestProcessor.addRequestHandlerClass(command, handler, false);
    }

    private static void addRequestHandlerClass(String command, Class<? extends RequestHandler> handler, boolean silent) {
        String commandWithSlash;
        if (command.charAt(0) == '/') {
            command = command.substring(1);
        }
        if (handlers.get(commandWithSlash = "/" + command) != null) {
            Logging.info("RemoteControl: ignoring duplicate command " + command + " with handler " + handler.getName());
        } else {
            if (!silent) {
                Logging.info("RemoteControl: adding command \"" + command + "\" (handled by " + handler.getSimpleName() + ")");
            }
            handlers.put(commandWithSlash, handler);
            try {
                Optional.ofNullable(handler.getConstructor(new Class[0]).newInstance(new Object[0]).getPermissionPref()).ifPresent(PermissionPrefWithDefault::addPermissionPref);
            }
            catch (ReflectiveOperationException | RuntimeException e) {
                Logging.debug(e);
            }
        }
    }

    public static void initialize() {
        if (handlers.isEmpty()) {
            RequestProcessor.addRequestHandlerClass("load_and_zoom", LoadAndZoomHandler.class, true);
            RequestProcessor.addRequestHandlerClass("zoom", LoadAndZoomHandler.class, true);
            RequestProcessor.addRequestHandlerClass("load_object", LoadObjectHandler.class, true);
            RequestProcessor.addRequestHandlerClass("load_data", LoadDataHandler.class, true);
            RequestProcessor.addRequestHandlerClass("import", ImportHandler.class, true);
            RequestProcessor.addRequestHandlerClass("open_file", OpenFileHandler.class, true);
            PermissionPrefWithDefault.addPermissionPref(PermissionPrefWithDefault.ALLOW_WEB_RESOURCES);
            RequestProcessor.addRequestHandlerClass("imagery", ImageryHandler.class, true);
            PermissionPrefWithDefault.addPermissionPref(PermissionPrefWithDefault.CHANGE_SELECTION);
            PermissionPrefWithDefault.addPermissionPref(PermissionPrefWithDefault.CHANGE_VIEWPORT);
            RequestProcessor.addRequestHandlerClass("add_node", AddNodeHandler.class, true);
            RequestProcessor.addRequestHandlerClass("add_way", AddWayHandler.class, true);
            RequestProcessor.addRequestHandlerClass("version", VersionHandler.class, true);
            RequestProcessor.addRequestHandlerClass("features", FeaturesHandler.class, true);
            RequestProcessor.addRequestHandlerClass("openapi.json", OpenApiHandler.class, true);
            RequestProcessor.addRequestHandlerClass("oauth_authorization", AuthorizationHandler.class, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ORDER_LOCK.lock();
        try (Socket socket = this.request;
             OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(this.request.getOutputStream()), RESPONSE_CHARSET);
             BufferedReader in = new BufferedReader(new InputStreamReader(this.request.getInputStream(), StandardCharsets.US_ASCII));){
            RequestProcessor.realRun(in, out, this.request);
        }
        catch (IOException ioe) {
            Logging.debug(Logging.getErrorMessage(ioe));
        }
        finally {
            ORDER_LOCK.unlock();
        }
    }

    private static void realRun(BufferedReader in, Writer out, Socket request) throws IOException {
        try {
            String get = in.readLine();
            if (get == null) {
                RequestProcessor.sendInternalError(out, null);
                return;
            }
            Logging.info("RemoteControl received: " + get);
            StringTokenizer st = new StringTokenizer(get);
            if (!st.hasMoreTokens()) {
                RequestProcessor.sendInternalError(out, null);
                return;
            }
            String method = st.nextToken();
            if (!st.hasMoreTokens()) {
                RequestProcessor.sendInternalError(out, null);
                return;
            }
            String url = st.nextToken();
            if (!"GET".equals(method)) {
                RequestProcessor.sendNotImplemented(out);
                return;
            }
            int questionPos = url.indexOf(63);
            String command = questionPos < 0 ? url : url.substring(0, questionPos);
            Map<String, String> headers = RequestProcessor.parseHeaders(in);
            String sender = RequestProcessor.parseSender(headers, request);
            RequestProcessor.callHandler(url, command, out, sender);
        }
        catch (ReflectiveOperationException e) {
            Logging.error(e);
            try {
                RequestProcessor.sendInternalError(out, e.getMessage());
            }
            catch (IOException e1) {
                Logging.warn(e1);
            }
        }
    }

    private static Map<String, String> parseHeaders(BufferedReader in) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        int k = 0;
        int maxHeaders = 20;
        int lastSize = -1;
        while (k < maxHeaders && lastSize != headers.size()) {
            lastSize = headers.size();
            String get = in.readLine();
            if (get == null) continue;
            ++k;
            String[] h = get.split(": ", 2);
            if (h.length != 2) continue;
            headers.put(h[0], h[1]);
        }
        return headers;
    }

    private static String parseSender(Map<String, String> headers, Socket request) {
        Matcher m;
        if (!request.getInetAddress().isLoopbackAddress()) {
            return request.getInetAddress().getHostAddress();
        }
        String ref = headers.get("Referer");
        Pattern r = Pattern.compile("(https?://)?([^/]*)");
        if (ref != null && (m = r.matcher(ref)).find()) {
            return m.group(2);
        }
        return "localhost";
    }

    private static void callHandler(String url, String command, Writer out, String sender) throws ReflectiveOperationException, IOException {
        Class<? extends RequestHandler> handlerClass = handlers.get(command);
        if (handlerClass == null) {
            String usage = RequestProcessor.getUsageAsHtml();
            String websiteDoc = HelpUtil.getWikiBaseHelpUrl() + "/Help/Preferences/RemoteControl";
            String help = "No command specified! The following commands are available:<ul>" + usage + "</ul>See <a href=\"" + websiteDoc + "\">" + websiteDoc + "</a> for complete documentation.";
            RequestProcessor.sendErrorHtml(out, 400, "Bad Request", help);
        } else {
            RequestHandler handler = handlerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            try {
                handler.setCommand(command);
                handler.setUrl(url);
                handler.setSender(sender);
                handler.handle();
                RequestProcessor.sendHeader(out, "200 OK", handler.getContentType(), false);
                out.write("Content-length: " + handler.getContent().length() + "\r\n");
                out.write("\r\n");
                out.write(handler.getContent());
                out.flush();
            }
            catch (RequestHandler.RequestHandlerOsmApiException ex) {
                Logging.debug(ex);
                RequestProcessor.sendBadGateway(out, ex.getMessage());
            }
            catch (RequestHandler.RequestHandlerErrorException ex) {
                Logging.debug(ex);
                RequestProcessor.sendInternalError(out, ex.getMessage());
            }
            catch (RequestHandler.RequestHandlerBadRequestException ex) {
                Logging.debug(ex);
                RequestProcessor.sendBadRequest(out, ex.getMessage());
            }
            catch (RequestHandler.RequestHandlerForbiddenException ex) {
                Logging.debug(ex);
                RequestProcessor.sendForbidden(out, ex.getMessage());
            }
        }
    }

    private static void sendError(Writer out, int errorCode, String errorName, String help) throws IOException {
        RequestProcessor.sendErrorHtml(out, errorCode, errorName, (String)(help == null ? "" : "<p>" + Utils.escapeReservedCharactersHTML(help) + "</p>"));
    }

    private static void sendErrorHtml(Writer out, int errorCode, String errorName, String helpHtml) throws IOException {
        RequestProcessor.sendHeader(out, errorCode + " " + errorName, "text/html", true);
        out.write(String.format(RESPONSE_TEMPLATE, "<title>" + errorName + "</title>", "<h1>HTTP Error " + errorCode + ": " + errorName + "</h1>" + helpHtml));
        out.flush();
    }

    private static void sendInternalError(Writer out, String help) throws IOException {
        RequestProcessor.sendError(out, 500, "Internal Server Error", help);
    }

    private static void sendNotImplemented(Writer out) throws IOException {
        RequestProcessor.sendError(out, 501, "Not Implemented", null);
    }

    private static void sendBadGateway(Writer out, String help) throws IOException {
        RequestProcessor.sendError(out, 502, "Bad Gateway", help);
    }

    private static void sendForbidden(Writer out, String help) throws IOException {
        RequestProcessor.sendError(out, 403, "Forbidden", help);
    }

    private static void sendBadRequest(Writer out, String help) throws IOException {
        RequestProcessor.sendError(out, 400, "Bad Request", help);
    }

    private static void sendHeader(Writer out, String status, String contentType, boolean endHeaders) throws IOException {
        out.write("HTTP/1.1 " + status + "\r\n");
        out.write("Date: " + String.valueOf(new Date()) + "\r\n");
        out.write("Server: JOSM RemoteControl\r\n");
        out.write("Content-type: " + contentType + "; charset=" + RESPONSE_CHARSET.name().toLowerCase(Locale.ENGLISH) + "\r\n");
        out.write("Access-Control-Allow-Origin: *\r\n");
        if (endHeaders) {
            out.write("\r\n");
        }
    }

    public static Stream<RequestHandler> getHandlersInfo(Collection<String> handlers) {
        return Utils.firstNonNull(handlers, RequestProcessor.handlers.keySet()).stream().map(RequestProcessor::getHandlerInfo).filter(Objects::nonNull);
    }

    public static RequestHandler getHandlerInfo(String cmd) {
        if (cmd == null) {
            return null;
        }
        if (!((String)cmd).startsWith("/")) {
            cmd = "/" + (String)cmd;
        }
        try {
            Class<? extends RequestHandler> c = handlers.get(cmd);
            if (c == null) {
                return null;
            }
            RequestHandler handler = handlers.get(cmd).getConstructor(new Class[0]).newInstance(new Object[0]);
            handler.setCommand((String)cmd);
            return handler;
        }
        catch (ReflectiveOperationException ex) {
            Logging.warn("Unknown handler " + (String)cmd);
            Logging.error(ex);
            return null;
        }
    }

    public static String getUsageAsHtml() throws ReflectiveOperationException {
        StringBuilder usage = new StringBuilder(1024);
        for (Map.Entry<String, Class<? extends RequestHandler>> handler : handlers.entrySet()) {
            RequestHandler sample = handler.getValue().getConstructor(new Class[0]).newInstance(new Object[0]);
            CharSequence[] mandatory = sample.getMandatoryParams();
            CharSequence[] optional = sample.getOptionalParams();
            String[] examples = sample.getUsageExamples(handler.getKey().substring(1));
            usage.append("<li>").append(handler.getKey());
            if (!Utils.isEmpty(sample.getUsage())) {
                usage.append(" &mdash; <i>").append(sample.getUsage()).append("</i>");
            }
            if (mandatory != null && mandatory.length > 0) {
                usage.append("<br/>mandatory parameters: ").append(String.join((CharSequence)", ", mandatory));
            }
            if (optional != null && optional.length > 0) {
                usage.append("<br/>optional parameters: ").append(String.join((CharSequence)", ", optional));
            }
            if (examples != null && examples.length > 0) {
                usage.append("<br/>examples: ");
                for (String ex : examples) {
                    usage.append("<br/> <a href=\"http://localhost:8111").append(ex).append("\">").append(ex).append("</a>");
                }
            }
            usage.append("</li>");
        }
        return usage.toString();
    }

    static {
        RequestProcessor.initialize();
    }
}

