/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.morfologik;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.rules.spelling.morfologik.MorfologikMultiSpeller;

public class MorfologikMultiSpellerTest {
    @Test
    public void testIsMisspelled() throws IOException {
        MorfologikMultiSpeller speller = this.getSpeller();
        Assert.assertFalse((boolean)speller.isMisspelled("wordone"));
        Assert.assertFalse((boolean)speller.isMisspelled("wordtwo"));
        Assert.assertFalse((boolean)speller.isMisspelled("Abc"));
        Assert.assertFalse((boolean)speller.isMisspelled("wordthree"));
        Assert.assertFalse((boolean)speller.isMisspelled("wordfour"));
        Assert.assertFalse((boolean)speller.isMisspelled("\u00fcblich"));
        Assert.assertFalse((boolean)speller.isMisspelled("sch\u00f6n"));
        Assert.assertFalse((boolean)speller.isMisspelled("F\u00f6n"));
        Assert.assertFalse((boolean)speller.isMisspelled("F\u00fcn"));
        Assert.assertFalse((boolean)speller.isMisspelled("F\u00e4n"));
        Assert.assertFalse((boolean)speller.isMisspelled("H\u00e4user"));
        Assert.assertTrue((boolean)speller.isMisspelled("notthere"));
        Assert.assertTrue((boolean)speller.isMisspelled("Fun"));
        Assert.assertTrue((boolean)speller.isMisspelled("F\u00fcns"));
        Assert.assertTrue((boolean)speller.isMisspelled("AF\u00fcn"));
    }

    @Test
    public void testGetSuggestions() throws IOException {
        MorfologikMultiSpeller speller = this.getSpeller();
        Assert.assertThat((Object)speller.getSuggestions("wordone").toString(), (Matcher)Is.is((Object)"[]"));
        Assert.assertThat((Object)speller.getSuggestions("wordones").toString(), (Matcher)Is.is((Object)"[wordone]"));
        Assert.assertThat((Object)speller.getSuggestions("Abd").toString(), (Matcher)Is.is((Object)"[Abc]"));
        Assert.assertThat((Object)speller.getSuggestions("Fxn").toString(), (Matcher)Is.is((Object)"[F\u00e4n, F\u00f6n, F\u00fcn]"));
        Assert.assertThat((Object)speller.getSuggestions("H\u00e4users").toString(), (Matcher)Is.is((Object)"[H\u00e4user]"));
    }

    @Test(expected=RuntimeException.class)
    public void testInvalidFileName() throws IOException {
        new MorfologikMultiSpeller("/xx/spelling/test.dict.README", "/xx/spelling/test2.txt", 1);
    }

    @Test(expected=RuntimeException.class)
    public void testInvalidFile() throws IOException {
        new MorfologikMultiSpeller("/xx/spelling/no-such-file", "/xx/spelling/test2.txt", 1);
    }

    private MorfologikMultiSpeller getSpeller() throws IOException {
        return new MorfologikMultiSpeller("/xx/spelling/test.dict", "/xx/spelling/test2.txt", 1);
    }
}

