/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.FloatIntHashMap;
import com.carrotsearch.hppc.HashOrderMixing;

public class FloatIntScatterMap
extends FloatIntHashMap {
    public FloatIntScatterMap() {
        this(4);
    }

    public FloatIntScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public FloatIntScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(float key) {
        return BitMixer.mixPhi(key);
    }

    public static FloatIntScatterMap from(float[] keys, int[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        FloatIntScatterMap map = new FloatIntScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

