/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.languagetool.server.DatabaseLogEntry;

public class DatabaseCacheStatsLogEntry
extends DatabaseLogEntry {
    private Calendar date;
    private Long server;
    private float cacheHits;

    public DatabaseCacheStatsLogEntry(Long server, float cacheHits) {
        this.server = server;
        this.cacheHits = cacheHits;
        this.date = Calendar.getInstance();
    }

    @Override
    public Map<Object, Object> getMapping() {
        HashMap<Object, Object> parameters = new HashMap<Object, Object>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        parameters.put("date", dateFormat.format(this.date.getTime()));
        parameters.put("server", this.server);
        parameters.put("cache_hits", Float.valueOf(this.cacheHits));
        return parameters;
    }

    @Override
    public String getMappingIdentifier() {
        return "org.languagetool.server.LogMapper.cacheStats";
    }

    @Override
    public void followup(Map<Object, Object> parameters) {
    }
}

