/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.io;

import edu.berkeley.nlp.lm.ArrayEncodedNgramLanguageModel;
import edu.berkeley.nlp.lm.io.LmReaders;
import edu.berkeley.nlp.lm.util.Logger;

public class MakeLmBinaryFromGoogle {
    private static void usage() {
        System.err.println("Usage: <Google n-grams dir> <outputfile>");
        System.exit(1);
    }

    public static void main(String[] argv) {
        if (argv.length != 2) {
            MakeLmBinaryFromGoogle.usage();
        }
        Logger.setGlobalLogger(new Logger.SystemLogger(System.out, System.err));
        Logger.startTrack("Reading Lm File " + argv[0] + " . . . ", new Object[0]);
        String googleDir = argv[0];
        ArrayEncodedNgramLanguageModel<String> lm = LmReaders.readLmFromGoogleNgramDir(googleDir, true, false);
        Logger.endTrack();
        String outFile = argv[1];
        Logger.startTrack("Writing to file " + outFile + " . . . ", new Object[0]);
        LmReaders.writeLmBinary(lm, outFile);
        Logger.endTrack();
    }
}

